/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.entity;

import mod.pbj.registry.SoundRegistry;
import mod.pbj.util.HitboxHelper;
import mod.pbj.util.MiscUtil;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class ProjectileBulletEntity
extends class_1676 {
    public static final class_1299<ProjectileBulletEntity> TYPE;
    private int correlationId;
    public float speed;
    public float damage;
    public int time = 0;
    public int shotCount;
    public class_243 initPos = new class_243(0.0, 0.0, 0.0);
    public float maxDistance = 1500.0f;
    public float headshotMultiplier = 1.0f;
    public class_1799 gunStack;
    public static class_6862<class_2248> PASSABLE;
    public static class_6862<class_2248> BREAKABLE;
    private float bulletGravity = 0.03f;

    private static class_6862<class_2248> create(class_2960 loc) {
        return class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)loc);
    }

    public void setBulletGravity(float gravity) {
        this.bulletGravity = gravity;
    }

    public ProjectileBulletEntity(class_1937 world) {
        super(TYPE, world);
    }

    public ProjectileBulletEntity(class_1299<ProjectileBulletEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ProjectileBulletEntity(class_1299<ProjectileBulletEntity> entityType, double x, double y, double z, class_1937 world) {
        super(entityType, world);
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_23311();
    }

    public boolean checkLeftOwner() {
        class_1297 entity = this.method_24921();
        if (entity != null) {
            for (class_1297 entity1 : this.method_37908().method_8333((class_1297)this, this.method_5829().method_18804(this.method_18798()).method_1014(1.0), p_37272_ -> !p_37272_.method_7325() && p_37272_.method_5863())) {
                if (entity1.method_5668() != entity.method_5668()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean method_26958(class_1297 pTarget) {
        return super.method_26958(pTarget) && !pTarget.field_5960;
    }

    public boolean method_5863() {
        return true;
    }

    public float method_5871() {
        return 1.0f;
    }

    public boolean method_5640(double pDistance) {
        double d0 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public void method_5773() {
        class_1297 entity = this.method_24921();
        if (this.method_37908().field_9236 || (entity == null || !entity.method_31481()) && this.method_37908().method_22340(this.method_24515())) {
            super.method_5773();
            class_239 hitresult = class_1675.method_49997((class_1297)this, this::method_26958);
            if (hitresult.method_17783() != class_239.class_240.field_1333) {
                this.method_7488(hitresult);
            }
            this.method_5852();
            class_243 vec3 = this.method_18798();
            double d0 = this.method_23317() + vec3.field_1352;
            double d1 = this.method_23318() + vec3.field_1351;
            double d2 = this.method_23321() + vec3.field_1350;
            class_1675.method_7484((class_1297)this, (float)0.2f);
            float f = 0.95f;
            if (this.method_5799()) {
                for (int i = 0; i < 4; ++i) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11247, d0 - vec3.field_1352 * 0.25, d1 - vec3.field_1351 * 0.25, d2 - vec3.field_1350 * 0.25, vec3.field_1352, vec3.field_1351, vec3.field_1350);
                }
                f = 0.8f;
            }
            this.method_18799(vec3.method_1021((double)f));
            this.method_45319(new class_243(0.0, (double)(-this.bulletGravity), 0.0));
            this.method_5814(d0, d1, d2);
        } else {
            this.method_31472();
        }
    }

    public ProjectileBulletEntity(class_1309 shooter, class_1937 world, float damage, float speed, int shotCount, float maxDistance, float headshotMultiplier, class_1799 gunStack, int correlationId) {
        this(TYPE, shooter.method_23317(), shooter.method_23320() - (double)0.1f, shooter.method_23321(), world);
        this.method_7432((class_1297)shooter);
        this.method_5710(shooter.method_36454(), shooter.method_36455());
        this.damage = damage;
        this.speed = speed;
        this.shotCount = shotCount;
        this.initPos = new class_243(shooter.method_23317(), shooter.method_23320() - (double)0.1f, shooter.method_23321());
        this.maxDistance = maxDistance;
        this.headshotMultiplier = headshotMultiplier;
        this.gunStack = gunStack;
        this.correlationId = correlationId;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    protected void method_7488(class_239 pResult) {
        class_239.class_240 hitresult$type = pResult.method_17783();
        if (hitresult$type == class_239.class_240.field_1331) {
            this.method_7454((class_3966)pResult);
            this.method_37908().method_32888((class_6880)class_5712.field_28162, pResult.method_17784(), class_5712.class_7397.method_43286((class_1297)this, (class_2680)null));
        } else if (hitresult$type == class_239.class_240.field_1332) {
            class_3965 blockhitresult = (class_3965)pResult;
            this.method_24920(blockhitresult);
            class_2338 blockpos = blockhitresult.method_17777();
            class_2680 blockState = this.method_37908().method_8320(blockpos);
            if (blockState.method_26164(BREAKABLE)) {
                this.method_37908().method_8651(blockpos, true, this.method_24921());
                return;
            }
            if (blockState.method_26164(PASSABLE)) {
                return;
            }
            this.method_37908().method_43276((class_6880)class_5712.field_28162, blockpos, class_5712.class_7397.method_43286((class_1297)this, (class_2680)this.method_37908().method_8320(blockpos)));
        }
    }

    protected void method_24920(class_3965 pResult) {
        if (pResult.method_17784().method_1022(this.initPos) >= (double)this.maxDistance) {
            this.method_31472();
            return;
        }
        class_2680 blockState = this.method_37908().method_8320(pResult.method_17777());
        if (blockState.method_26164(BREAKABLE)) {
            this.method_37908().method_8651(pResult.method_17777(), true, this.method_24921());
            return;
        }
        if (blockState.method_26164(PASSABLE)) {
            return;
        }
        super.method_24920(pResult);
        if (this.method_24921() != null && this.method_37908() instanceof class_3218) {
            for (class_3222 serverPlayer : ((class_3218)MiscUtil.getLevel(this.method_24921())).method_18766(p -> true)) {
                if (serverPlayer != this.method_24921() && !(serverPlayer.method_5858(this.method_24921()) < (double)(this.maxDistance * this.maxDistance))) continue;
            }
        }
        this.method_5783(this.method_37908().method_8320(pResult.method_17777()).method_26231().method_10596(), 1.0f / (float)this.shotCount, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
        class_5819 source = class_5819.method_43047();
        double d0 = pResult.method_17784().field_1352;
        double d1 = pResult.method_17784().field_1351;
        double d2 = pResult.method_17784().field_1350;
        double d3 = d0 - (double)pResult.method_17777().method_10263() - 0.5;
        double d5 = d2 - (double)pResult.method_17777().method_10260() - 0.5;
        double d6 = Math.max(Math.abs(d3), Math.abs(d5));
        d0 = (double)pResult.method_17777().method_10263() + 0.5 + d3 / d6 * 0.5;
        d2 = (double)pResult.method_17777().method_10260() + 0.5 + d5 / d6 * 0.5;
        float f = class_3532.method_15386((float)this.damage);
        double d4 = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int i = (int)(15.0 * d4);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 sv = (class_3218)class_19372;
            for (int j = 0; j < i; ++j) {
                sv.method_14199((class_2394)new class_2388(class_2398.field_11217, blockState), d0, d1, d2, 1, source.method_43056() ? source.method_43058() / 4.0 : -source.method_43058() / 4.0, (double)j / (double)i / 2.0, source.method_43056() ? source.method_43058() / 4.0 : -source.method_43058() / 4.0, 0.15);
            }
        }
    }

    protected void method_7454(class_3966 pResult) {
        if (pResult.method_17784().method_1022(this.initPos) >= (double)this.maxDistance) {
            this.method_31472();
            return;
        }
        class_1297 entity = pResult.method_17782();
        class_238 boundingBox = HitboxHelper.getFixedBoundingBox(entity, this.method_24921());
        class_243 startVec = this.method_19538();
        class_243 endVec = startVec.method_1019(this.method_18798());
        class_243 hitPos = boundingBox.method_992(startVec, endVec).orElse(null);
        double headshotmulti = 1.0;
        if (hitPos != null) {
            if (this.method_24921() != null && this.method_37908() instanceof class_3218) {
                for (class_3222 serverPlayer : ((class_3218)MiscUtil.getLevel(this.method_24921())).method_18766(p -> true)) {
                    if (serverPlayer != this.method_24921() && !(serverPlayer.method_5858(this.method_24921()) < (double)(this.maxDistance * this.maxDistance))) continue;
                }
            }
            class_243 hitBoxPos = hitPos.method_1020(entity.method_19538());
            boolean headshot = false;
            float eyeHeight = entity.method_5751();
            if (entity instanceof class_1657 && (double)eyeHeight - 0.25 < hitBoxPos.field_1351 && hitBoxPos.field_1351 < (double)eyeHeight + 0.25) {
                headshot = true;
                headshotmulti = this.headshotMultiplier;
            }
            if (!(entity instanceof class_1657) && (double)eyeHeight - 0.25 < hitBoxPos.field_1351 && hitBoxPos.field_1351 < (double)eyeHeight + 0.25) {
                headshot = true;
                headshotmulti = this.headshotMultiplier;
            }
            class_1282 damageSource = pResult.method_17782().method_48923().method_48800((class_1297)this, (class_1309)this.method_24921());
            if (headshot) {
                this.method_37908().method_8396(null, entity.method_24515(), SoundRegistry.HIT_HEADSHOT.get(), class_3419.field_15251, 0.8f / (float)this.shotCount, 1.0f);
            }
            pResult.method_17782().method_5643(damageSource, (float)((double)this.damage * headshotmulti));
            pResult.method_17782().field_6008 = 1;
            this.method_31472();
        }
    }

    static {
        PASSABLE = ProjectileBulletEntity.create(class_2960.method_60655((String)"pointblank", (String)"passable"));
        BREAKABLE = ProjectileBulletEntity.create(class_2960.method_60655((String)"pointblank", (String)"breakable"));
        TYPE = class_1299.class_1300.method_5903(ProjectileBulletEntity::new, (class_1311)class_1311.field_17715).method_5901().method_5904().method_19947().method_17687(0.0225f, 0.0225f).method_27299(256).method_20815().method_27300(1).method_5905("bullet");
    }
}

