/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class AccuracyFeature
extends ConditionalFeature {
    private static final float MIN_ACCURACY_MODIFIER = 0.1f;
    private static final float MAX_ACCURACY_MODIFIER = 10.0f;
    private float accuracyModifier;

    private AccuracyFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, float accuracyModifier) {
        super(owner, predicate);
        this.accuracyModifier = accuracyModifier;
    }

    public class_5250 getDescription() {
        if (this.accuracyModifier < 1.0f) {
            return class_2561.method_43471((String)"description.pointblank.reducesAccuracy").method_10852((class_2561)class_2561.method_43470((String)String.format(" %.0f%%", Float.valueOf(100.0f * (1.0f - this.accuracyModifier)))));
        }
        return class_2561.method_43471((String)"description.pointblank.increasesAccuracy").method_10852((class_2561)class_2561.method_43470((String)String.format(" %.0f%%", Float.valueOf(100.0f * (this.accuracyModifier - 1.0f)))));
    }

    public float getAccuracyModifier() {
        return this.accuracyModifier;
    }

    public static float getAccuracyModifier(class_1799 itemStack) {
        List<Features.EnabledFeature> enabledAccuracyFeatures = Features.getEnabledFeatures(itemStack, AccuracyFeature.class);
        float accuracyModifier = 1.0f;
        for (Features.EnabledFeature enabledFeature : enabledAccuracyFeatures) {
            AccuracyFeature accuracyFeature = (AccuracyFeature)enabledFeature.feature();
            accuracyModifier *= accuracyFeature.getAccuracyModifier();
        }
        return class_3532.method_15363((float)accuracyModifier, (float)0.1f, (float)10.0f);
    }

    public static class Builder
    implements FeatureBuilder<Builder, AccuracyFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private float accuracyModifier;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withAccuracyModifier(double accuracyModifier) {
            this.accuracyModifier = (float)accuracyModifier;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withAccuracyModifier(JsonUtil.getJsonFloat(obj, "accuracyModifier"));
            return this;
        }

        @Override
        public AccuracyFeature build(FeatureProvider featureProvider) {
            return new AccuracyFeature(featureProvider, this.condition, this.accuracyModifier);
        }
    }
}

