/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Predicate;
import mod.pbj.client.GunClientState;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.item.GunItem;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class AdsSpeedFeature
extends ConditionalFeature {
    private float adsMultiplier;

    public AdsSpeedFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, float adsMultiplier) {
        super(owner, predicate);
        this.adsMultiplier = adsMultiplier;
    }

    public static long getTotalAdsSpeed(class_1799 itemStack, class_1657 player, GunClientState state) {
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return 0L;
        }
        List<Features.EnabledFeature> enabledAccuracyFeatures = Features.getEnabledFeatures(itemStack, AdsSpeedFeature.class);
        float adsModifier = 1.0f;
        for (Features.EnabledFeature enabledFeature : enabledAccuracyFeatures) {
            AdsSpeedFeature adsFeature = (AdsSpeedFeature)enabledFeature.feature();
            if (!adsFeature.predicate.test(new ConditionContext((class_1309)player, itemStack, state))) continue;
            adsModifier *= adsFeature.getAdsMultiplier();
        }
        return Math.round((float)((GunItem)itemStack.method_7909()).getAdsSpeed() * adsModifier);
    }

    public float getAdsMultiplier() {
        return this.adsMultiplier;
    }

    public static class Builder
    implements FeatureBuilder<Builder, AdsSpeedFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private float adsSpeedMultiplier;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withAdsSpeedMultiplier(double adsSpeed) {
            this.adsSpeedMultiplier = (float)adsSpeed;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withAdsSpeedMultiplier(JsonUtil.getJsonFloat(obj, "adsModifier"));
            return this;
        }

        @Override
        public AdsSpeedFeature build(FeatureProvider featureProvider) {
            return new AdsSpeedFeature(featureProvider, this.condition, this.adsSpeedMultiplier);
        }
    }
}

