/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_7923;

public class AttributeFeature
extends ConditionalFeature {
    public final class_6880.class_6883<class_1320> baseAttribute;
    public final class_1322 modifier;

    public AttributeFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, class_6880.class_6883<class_1320> baseAttribute, class_1322 modifier) {
        super(owner, predicate);
        this.baseAttribute = baseAttribute;
        this.modifier = modifier;
    }

    @Override
    public List<class_2561> getDescriptions() {
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        components.add((class_2561)class_5250.method_43477((class_7417)class_2561.method_43471((String)((class_1320)this.baseAttribute.comp_349()).method_26830()).method_10851()).method_27693(": %s".formatted(this.getFormattedModifier(this.modifier))));
        return components;
    }

    private String getFormattedModifier(class_1322 modifier) {
        Object string = switch (modifier.comp_2450()) {
            default -> throw new MatchException(null, null);
            case class_1322.class_1323.field_6328 -> "+ ";
            case class_1322.class_1323.field_6330 -> "base x ";
            case class_1322.class_1323.field_6331 -> "x ";
        };
        string = (String)string + modifier.comp_2449();
        return string;
    }

    public static class Builder
    implements FeatureBuilder<Builder, AttributeFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private class_6880.class_6883<class_1320> baseAttribute;
        private class_1322 modifier;
        public static final HashMap<class_1322.class_1323, String[]> modifierValues = new HashMap();

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withAttribute(class_6880.class_6883<class_1320> attribute) {
            this.baseAttribute = attribute;
            return this;
        }

        public Builder withAttributeModifier(class_1322 attributeModifier) {
            this.modifier = attributeModifier;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            class_2960 attribute = class_2960.method_60654((String)JsonUtil.getJsonString(obj, "attribute"));
            this.withAttribute((class_6880.class_6883<class_1320>)((class_6880.class_6883)class_7923.field_41190.method_55841(attribute).orElseThrow()));
            JsonObject modObj = obj.getAsJsonObject("modifier");
            if (modObj == null) {
                throw new IllegalStateException("AttributeFeature needs a \"modifier\" object!");
            }
            class_1322 modifier = new class_1322(attribute, modObj.get("amount").getAsDouble(), Builder.operationFromString(modObj.has("operator") ? modObj.get("operator").getAsString() : modObj.get("operation").getAsString()));
            this.withAttributeModifier(modifier);
            return this;
        }

        public static class_1322.class_1323 operationFromString(String str) {
            class_1322.class_1323[] fop = new class_1322.class_1323[]{null};
            modifierValues.forEach((op, strArr) -> {
                for (String key : strArr) {
                    if (!str.trim().equalsIgnoreCase(key)) continue;
                    fop[0] = op;
                    return;
                }
            });
            return fop[0];
        }

        @Override
        public AttributeFeature build(FeatureProvider featureProvider) {
            return new AttributeFeature(featureProvider, this.condition, this.baseAttribute, this.modifier);
        }

        static {
            modifierValues.put(class_1322.class_1323.field_6328, new String[]{"add_value", "addition", "+"});
            modifierValues.put(class_1322.class_1323.field_6330, new String[]{"add_multiplied_base", "multiply_base", "*b", "xb"});
            modifierValues.put(class_1322.class_1323.field_6331, new String[]{"add_multiplied_total", "multiply_total", "*", "x"});
        }
    }
}

