/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public class DefenseFeature
extends ConditionalFeature {
    private final float defenseModifier;
    private final int defense;
    private final float toughnessModifier;
    private final float toughness;

    public DefenseFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, float defenseModifier, int defense, float toughness, float toughnessModifier) {
        super(owner, predicate);
        this.defenseModifier = defenseModifier;
        this.defense = defense;
        this.toughnessModifier = toughnessModifier;
        this.toughness = toughness;
    }

    public static float getToughnessModifier(class_1799 itemStack) {
        List<Features.EnabledFeature> enabledDefenseFeatures = Features.getEnabledFeatures(itemStack, DefenseFeature.class);
        float toughnessModifier = 1.0f;
        for (Features.EnabledFeature enabledFeature : enabledDefenseFeatures) {
            DefenseFeature defenseFeature = (DefenseFeature)enabledFeature.feature();
            toughnessModifier *= defenseFeature.getToughnessModifier();
        }
        return class_3532.method_15363((float)toughnessModifier, (float)0.01f, (float)10.0f);
    }

    public static float getToughnessAdditive(class_1799 itemStack) {
        List<Features.EnabledFeature> enabledDefenseFeatures = Features.getEnabledFeatures(itemStack, DefenseFeature.class);
        float toughness = 0.0f;
        for (Features.EnabledFeature enabledFeature : enabledDefenseFeatures) {
            DefenseFeature defenseFeature = (DefenseFeature)enabledFeature.feature();
            toughness += defenseFeature.getToughnessAdditive();
        }
        return toughness;
    }

    public static float getDefenseModifier(class_1799 itemStack) {
        List<Features.EnabledFeature> enabledDefenseFeatures = Features.getEnabledFeatures(itemStack, DefenseFeature.class);
        float defenseModifier = 1.0f;
        for (Features.EnabledFeature enabledFeature : enabledDefenseFeatures) {
            DefenseFeature defenseFeature = (DefenseFeature)enabledFeature.feature();
            defenseModifier *= defenseFeature.getDefenseModifier();
        }
        return class_3532.method_15363((float)defenseModifier, (float)0.01f, (float)10.0f);
    }

    public static int getDefenseAdditive(class_1799 itemStack) {
        List<Features.EnabledFeature> enabledDefenseFeatures = Features.getEnabledFeatures(itemStack, DefenseFeature.class);
        int defenseModifier = 0;
        for (Features.EnabledFeature enabledFeature : enabledDefenseFeatures) {
            DefenseFeature defenseFeature = (DefenseFeature)enabledFeature.feature();
            defenseModifier += defenseFeature.getDefenseAdditive();
        }
        return defenseModifier;
    }

    @Override
    public List<class_2561> getDescriptions() {
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        if (this.defense != 0) {
            components.add((class_2561)class_5250.method_43477((class_7417)class_2561.method_43471((String)"description.pointblank.armor").method_10851()).method_27693(String.format(" %s", this.defense)));
        }
        if (this.toughness != 0.0f) {
            components.add((class_2561)class_5250.method_43477((class_7417)class_2561.method_43471((String)"description.pointblank.toughness").method_10851()).method_27693(String.format(" %s", Float.valueOf(this.toughness))));
        }
        if (this.defenseModifier > 1.0f) {
            components.add((class_2561)class_5250.method_43477((class_7417)class_2561.method_43471((String)"description.pointblank.increasesDefense").method_10851()).method_27693(String.format(" %sx", Float.valueOf(this.defenseModifier))));
        }
        if (this.defenseModifier < 1.0f) {
            components.add((class_2561)class_5250.method_43477((class_7417)class_2561.method_43471((String)"description.pointblank.decreasesDefense").method_10851()).method_27693(String.format(" %sx", Float.valueOf(this.defenseModifier))));
        }
        if (this.toughnessModifier > 1.0f) {
            components.add((class_2561)class_5250.method_43477((class_7417)class_2561.method_43471((String)"description.pointblank.increasesToughness").method_10851()).method_27693(String.format(" %sx", Float.valueOf(this.toughnessModifier))));
        }
        if (this.toughnessModifier < 1.0f) {
            components.add((class_2561)class_5250.method_43477((class_7417)class_2561.method_43471((String)"description.pointblank.decreasesToughness").method_10851()).method_27693(String.format(" %sx", Float.valueOf(this.toughnessModifier))));
        }
        return components;
    }

    @Deprecated
    private class_5250 getToughnessComponent() {
        class_5250 start = this.toughnessModifier < 1.0f ? class_2561.method_43471((String)"description.pointblank.reducesToughness") : class_2561.method_43471((String)"description.pointblank.increasesToughness");
        start.method_27693(String.format(" %.0f%%", 100.0 * (1.0 - (double)this.toughnessModifier))).method_10852((class_2561)class_2561.method_43470((String)"description.pointblank.increasesToughness").method_27693(" +%s".formatted(Float.valueOf(this.toughness))));
        return start;
    }

    @Deprecated
    public class_5250 getDefenseComponent() {
        return class_2561.method_43470((String)String.format(" %.0f%%", 100.0 * (1.0 - (double)this.defenseModifier))).method_10852((class_2561)class_2561.method_43470((String)"description.pointblank.increasesDefense").method_27693(" +%s".formatted(this.defense)));
    }

    public float getDefenseModifier() {
        return this.defenseModifier;
    }

    public int getDefenseAdditive() {
        return this.defense;
    }

    public float getToughnessModifier() {
        return this.toughnessModifier;
    }

    public float getToughnessAdditive() {
        return this.toughness;
    }

    public static class Builder
    implements FeatureBuilder<Builder, DefenseFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private float defenseModifier;
        private int defense;
        private float toughness;
        private float toughnessModifier;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withDefenseModifier(double defenseModifier) {
            this.defenseModifier = (float)defenseModifier;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withDefenseModifier(JsonUtil.getJsonFloat(obj, "defenseModifier", 1.0f));
            this.withDefense(JsonUtil.getJsonInt(obj, "defenseAdditive", 0));
            this.withToughnessModifier(JsonUtil.getJsonFloat(obj, "toughnessModifier", 1.0f));
            this.withToughness(JsonUtil.getJsonFloat(obj, "toughnessAdditive", 0.0f));
            return this;
        }

        public Builder withDefense(int defenseAdditive) {
            this.defense = defenseAdditive;
            return this;
        }

        public Builder withToughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public Builder withToughnessModifier(float toughnessModifier) {
            this.toughnessModifier = toughnessModifier;
            return this;
        }

        @Override
        public DefenseFeature build(FeatureProvider featureProvider) {
            return new DefenseFeature(featureProvider, this.condition, this.defenseModifier, this.defense, this.toughness, this.toughnessModifier);
        }
    }
}

