/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.item.GunItem;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.class_1799;
import net.minecraft.class_3532;

public class ReloadFeature
extends ConditionalFeature {
    private static final int MIN_AMMO_PER_RELOAD_ITERATION = 1;
    private static final int MAX_AMMO_PER_RELOAD_ITERATION = Integer.MAX_VALUE;
    private int maxAmmoPerReloadIteration;

    private ReloadFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, int maxAmmoPerReloadIteration) {
        super(owner, predicate);
        this.maxAmmoPerReloadIteration = maxAmmoPerReloadIteration;
    }

    public static int getMaxAmmoPerReloadIteration(class_1799 itemStack) {
        if (!(itemStack.method_7909() instanceof GunItem)) {
            return 0;
        }
        Features.EnabledFeature enabledReloadFeature = Features.getFirstEnabledFeature(itemStack, ReloadFeature.class);
        if (enabledReloadFeature != null) {
            return ((ReloadFeature)enabledReloadFeature.feature()).maxAmmoPerReloadIteration;
        }
        return Integer.MAX_VALUE;
    }

    public static class Builder
    implements FeatureBuilder<Builder, ReloadFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private int maxAmmoPerReloadIteration;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withMaxAmmoPerReloadIteration(int maxAmmoPerReloadIteration) {
            this.maxAmmoPerReloadIteration = class_3532.method_15340((int)maxAmmoPerReloadIteration, (int)1, (int)Integer.MAX_VALUE);
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            if (obj.has("maxAmmoPerReloadIteration")) {
                this.withMaxAmmoPerReloadIteration(JsonUtil.getJsonInt(obj, "maxAmmoPerReloadIteration"));
            }
            return this;
        }

        @Override
        public ReloadFeature build(FeatureProvider featureProvider) {
            return new ReloadFeature(featureProvider, this.condition, this.maxAmmoPerReloadIteration);
        }
    }
}

