/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import mod.pbj.client.GunClientState;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class SkinFeature
extends ConditionalFeature {
    private class_2960 texture;
    private Map<String, Pair<class_2960, Predicate<ConditionContext>>> conditions;

    private SkinFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, class_2960 texture, Map<String, Pair<class_2960, Predicate<ConditionContext>>> conditions) {
        super(owner, predicate);
        this.texture = texture;
        this.conditions = conditions;
    }

    public class_5250 getDescription() {
        return class_2561.method_43470((String)"Changes skin");
    }

    public static class_2960 getTexture(class_1799 itemStack, class_1657 player) {
        Object object;
        Features.EnabledFeature enabledSkinTexture = Features.getFirstEnabledFeature(itemStack, SkinFeature.class);
        if (enabledSkinTexture != null && (object = enabledSkinTexture.feature()) instanceof SkinFeature) {
            SkinFeature feature = (SkinFeature)object;
            if (feature.conditions != null && !feature.conditions.isEmpty()) {
                for (Map.Entry entry : feature.conditions.entrySet()) {
                    String gunId;
                    GunClientState gunState = GunClientState.getMainHeldState();
                    ConditionContext testCondition = new ConditionContext((class_1309)player, itemStack, gunState);
                    if (gunState != null && itemStack.method_7909().toString().equals(entry.getKey()) && !((Predicate)((Pair)entry.getValue()).getSecond()).test(testCondition)) {
                        return null;
                    }
                    if (gunState == null || !itemStack.method_7909().toString().equals(entry.getKey()) || feature.conditions == null || !feature.conditions.containsKey(gunId = itemStack.method_7909().toString())) continue;
                    return (class_2960)feature.conditions.get(gunId).getFirst();
                }
            }
            return feature.texture;
        }
        return null;
    }

    public static class Builder
    implements FeatureBuilder<Builder, SkinFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private Map<String, Pair<class_2960, Predicate<ConditionContext>>> resourceConditions;
        private class_2960 skinResource;
        private Map<String, Pair<class_2960, Predicate<ConditionContext>>> conditions;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withTexture(String texture) {
            this.skinResource = class_2960.method_60655((String)"pointblank", (String)texture);
            return this;
        }

        public void withTextures(JsonArray textureArray) {
            this.resourceConditions = new HashMap<String, Pair<class_2960, Predicate<ConditionContext>>>();
            for (int i = 0; i < textureArray.size(); ++i) {
                JsonObject obj = textureArray.get(i).getAsJsonObject();
                String weaponId = "pointblank:" + obj.get("id").getAsString();
                String texture = obj.get("texture").getAsString();
                Predicate<ConditionContext> textureCondition = ctx -> true;
                if (obj.has("condition") && obj.get("condition") != null) {
                    textureCondition = Conditions.fromJson(obj.get("condition"));
                }
                this.resourceConditions.put(weaponId, (Pair<class_2960, Predicate<ConditionContext>>)Pair.of((Object)class_2960.method_60655((String)"pointblank", (String)texture), textureCondition));
            }
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            if (obj.has("skins")) {
                this.withTextures(obj.getAsJsonArray("skins"));
            }
            if (obj.has("texture")) {
                this.withTexture(JsonUtil.getJsonString(obj, "texture"));
            }
            return this;
        }

        @Override
        public SkinFeature build(FeatureProvider featureProvider) {
            return new SkinFeature(featureProvider, this.condition, this.skinResource, this.resourceConditions);
        }
    }
}

