/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.inventory;

import java.util.HashMap;
import java.util.Map;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.inventory.VirtualInventory;
import mod.pbj.util.MiscUtil;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlotMapping {
    private static final int CURRENT_VERSION = 1;
    private static final long EXPIRATION_DURATION = 604800000L;
    public static final String TAG_SLOT_MAPPING = "pointblank:attachmentSlotMapping";
    private static final Logger logger = LogManager.getLogger((String)"pointblank");
    private Map<String, Map<Integer, AttachmentCategory>> mapping = new HashMap<String, Map<Integer, AttachmentCategory>>();
    private class_1657 player;

    static SlotMapping getOrCreate(class_1657 player) {
        SlotMapping slotMapping = new SlotMapping(player);
        slotMapping.loadSlotMapping();
        return slotMapping;
    }

    SlotMapping(class_1657 player) {
        this.player = player;
    }

    Map<Integer, AttachmentCategory> getOrCreateSlotMapping(VirtualInventory virtualInventory) {
        String key = virtualInventory.getPath();
        Map<Integer, AttachmentCategory> result = null;
        if (key == null) {
            return null;
        }
        result = this.mapping.get(key);
        if (result != null && !virtualInventory.isValidSlotMapping(result)) {
            logger.debug("Invalid slot mapping found for key {} in inventory {}. Here it is: {}", (Object)key, (Object)virtualInventory, result);
            result = null;
        }
        if (result == null) {
            logger.debug("Creating a slot mapping for key {} in inventory {}", (Object)key, (Object)virtualInventory);
            result = virtualInventory.createSlotMapping(key);
            if (key != null) {
                this.mapping.put(key, result);
            }
            this.saveSlotMapping();
            logger.debug("Created a slot mapping for key {} in inventory {}. Here it is: {}", (Object)key, (Object)virtualInventory, result);
        }
        return result;
    }

    Map<Integer, AttachmentCategory> getStackSlotMapping(VirtualInventory virtualInventory) {
        return this.mapping.get(virtualInventory.getPath());
    }

    void saveSlotMapping() {
        class_2487 persistentData = MiscUtil.getPersistentData(this.player);
        class_2487 slotMappingTag = this.serializeSlotMapping();
        persistentData.method_10566(TAG_SLOT_MAPPING, (class_2520)slotMappingTag);
    }

    private void loadSlotMapping() {
        class_2487 persistentData = MiscUtil.getPersistentData(this.player);
        class_2487 slotMappingTag = persistentData.method_10562(TAG_SLOT_MAPPING);
        if (slotMappingTag != null) {
            this.deserializeStackIdSlotMapping(slotMappingTag);
        }
    }

    class_2487 serializeSlotMapping() {
        class_2487 rootTag = new class_2487();
        long currentTime = System.currentTimeMillis();
        rootTag.method_10569("Version", 1);
        rootTag.method_10544("Timestamp", currentTime);
        class_2499 mappingsList = new class_2499();
        for (Map.Entry<String, Map<Integer, AttachmentCategory>> entry : this.mapping.entrySet()) {
            class_2487 mappingTag = new class_2487();
            mappingTag.method_10582("id", entry.getKey());
            mappingTag.method_10544("CreationTime", currentTime);
            class_2487 slotMappingsTag = new class_2487();
            for (Map.Entry<Integer, AttachmentCategory> slotEntry : entry.getValue().entrySet()) {
                slotMappingsTag.method_10582(slotEntry.getKey().toString(), slotEntry.getValue().getName());
            }
            mappingTag.method_10566("SlotMappings", (class_2520)slotMappingsTag);
            mappingsList.add((Object)mappingTag);
        }
        rootTag.method_10566("Mappings", (class_2520)mappingsList);
        return rootTag;
    }

    void deserializeStackIdSlotMapping(class_2487 rootTag) {
        int storedVersion = rootTag.method_10550("Version");
        long storedTimestamp = rootTag.method_10537("Timestamp");
        long currentTime = System.currentTimeMillis();
        if (storedVersion != 1 || currentTime - storedTimestamp > 604800000L) {
            logger.warn("Skipping loading of outdated or expired slot mappings.");
            return;
        }
        this.mapping.clear();
        class_2499 mappingsList = rootTag.method_10554("Mappings", 10);
        for (int i = 0; i < mappingsList.size(); ++i) {
            class_2487 mappingTag = mappingsList.method_10602(i);
            long creationTime = mappingTag.method_10537("CreationTime");
            if (currentTime - creationTime > 604800000L) continue;
            String stackId = mappingTag.method_10558("id");
            class_2487 slotMappingsTag = mappingTag.method_10562("SlotMappings");
            HashMap<Integer, AttachmentCategory> slotMappings = new HashMap<Integer, AttachmentCategory>();
            for (String slotKey : slotMappingsTag.method_10541()) {
                String slotValue = slotMappingsTag.method_10558(slotKey);
                slotMappings.put(Integer.parseInt(slotKey), AttachmentCategory.fromString(slotValue));
            }
            this.mapping.put(stackId, slotMappings);
        }
    }
}

