/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.inventory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mod.pbj.Nameable;
import mod.pbj.Platform;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.attachment.Attachments;
import mod.pbj.event.AttachmentAddedEvent;
import mod.pbj.event.AttachmentRemovedEvent;
import mod.pbj.inventory.AttachmentContainerMenu;
import mod.pbj.inventory.AttachmentSlot;
import mod.pbj.inventory.SimpleAttachmentContainer;
import mod.pbj.inventory.SlotMapping;
import mod.pbj.util.MiscUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualInventory
implements class_1265 {
    private static final Logger logger = LogManager.getLogger((String)"pointblank");
    protected AttachmentCategory category;
    protected class_1799 itemStack;
    protected VirtualInventory parent;
    protected Map<AttachmentCategory, VirtualInventory> elements;
    protected class_1657 owner;

    private VirtualInventory(class_1657 owner, AttachmentCategory category, VirtualInventory parent, class_1799 itemStack) {
        this.owner = owner;
        this.category = category;
        this.parent = parent;
        this.itemStack = itemStack != null ? itemStack : class_1799.field_8037;
        this.elements = new LinkedHashMap<AttachmentCategory, VirtualInventory>();
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    private void addElement(VirtualInventory e) {
        AttachmentCategory category = e.category;
        if (category == null) {
            logger.error("Adding an element without a category");
        }
        this.elements.put(e.category, e);
    }

    public Map<AttachmentCategory, VirtualInventory> getElements() {
        return Collections.unmodifiableMap(this.elements);
    }

    public VirtualInventory getElement(AttachmentCategory category) {
        return this.elements.get(category);
    }

    private Collection<AttachmentCategory> getCategories() {
        return this.elements.keySet();
    }

    public boolean mayPlace(class_1799 attachmentStack, AttachmentSlot attachmentSlot) {
        if (attachmentSlot.getSlotIndex() > this.elements.size()) {
            return false;
        }
        if (!this.isCompatibleAttachment(attachmentStack)) {
            return false;
        }
        AttachmentCategory attachmentCategory = ((Attachment)attachmentStack.method_7909()).getCategory();
        return !this.hasAttachmentInCategory(attachmentCategory);
    }

    public boolean hasAttachments() {
        return this.elements.values().stream().anyMatch(e -> e.itemStack != null && !e.itemStack.method_7960());
    }

    private boolean hasAttachmentInCategory(AttachmentCategory category) {
        VirtualInventory e = this.elements.get(category);
        return e != null && e.itemStack != null && !e.itemStack.method_7960();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCompatibleAttachment(class_1799 attachmentStack) {
        class_1792 class_17922 = attachmentStack.method_7909();
        if (!(class_17922 instanceof Attachment)) return false;
        Attachment attachment = (Attachment)class_17922;
        if (!((AttachmentHost)this.itemStack.method_7909()).getCompatibleAttachments().contains(attachment)) return false;
        return true;
    }

    public boolean mayPickup(class_1657 player) {
        return false;
    }

    String getPath() {
        if (this.parent != null) {
            class_1792 class_17922 = this.itemStack.method_7909();
            if (class_17922 instanceof Nameable) {
                Nameable nameable = (Nameable)class_17922;
                return this.parent.getPath() + "/" + nameable.getName();
            }
            return this.parent.getPath() + "/" + this.itemStack.method_7909().toString();
        }
        return MiscUtil.getItemStackId(this.itemStack).toString();
    }

    private class_1799 getRootStack() {
        if (this.parent != null) {
            return this.parent.getRootStack();
        }
        return this.itemStack;
    }

    public void method_5453(class_1263 c) {
        if (!(c instanceof SimpleAttachmentContainer)) {
            return;
        }
        SimpleAttachmentContainer container = (SimpleAttachmentContainer)c;
        AttachmentContainerMenu menu = container.getMenu();
        logger.debug("Virtual inventory {} handling changes in container {}, stack tags {}", (Object)this, (Object)container, (Object)MiscUtil.getTag(this.itemStack));
        SlotMapping slotMapping = menu.getSlotMapping();
        Map<Integer, AttachmentCategory> stackSlotMapping = slotMapping.getStackSlotMapping(this);
        if (stackSlotMapping == null) {
            logger.warn("Slot mapping not found for container {}, stack tags {}", (Object)System.identityHashCode(container), (Object)MiscUtil.getTag(this.itemStack));
            return;
        }
        List<Attachment> removedItems = Attachments.removeAllAttachments(this.itemStack);
        for (int i = 1; i < container.method_5439(); ++i) {
            class_1792 class_17922;
            class_1799 slotStack = container.method_5438(i);
            if (!slotStack.method_7960() && (class_17922 = slotStack.method_7909()) instanceof Attachment) {
                Attachment a1 = (Attachment)class_17922;
                logger.debug("Adding attachment '{}' from slot {} with tag {} to stack '{}'", (Object)slotStack, (Object)i, (Object)MiscUtil.getTag(slotStack), (Object)this.itemStack);
                Attachments.addAttachment(this.itemStack, slotStack, true);
                if (!removedItems.contains(a1)) {
                    AttachmentAddedEvent event = new AttachmentAddedEvent(this.owner, this.itemStack, slotStack);
                    Platform.getInstance().getEventBus().postEvent(event);
                    logger.debug("Added new attachment '{}' from slot {} with tag {} to stack '{}' with tag {} and path {}", (Object)slotStack, (Object)i, (Object)MiscUtil.getTag(slotStack), (Object)this.itemStack, (Object)MiscUtil.getTag(this.itemStack));
                } else {
                    logger.debug("Re-added existing attachment '{}' from slot {} with tag {} to stack '{}' with tag {}", (Object)slotStack, (Object)i, (Object)MiscUtil.getTag(slotStack), (Object)this.itemStack, (Object)MiscUtil.getTag(this.itemStack));
                }
                stackSlotMapping.put(i, a1.getCategory());
                VirtualInventory childInventory = VirtualInventory.createInventory(this.owner, this, slotStack);
                if (childInventory == null) continue;
                this.elements.put(a1.getCategory(), childInventory);
                continue;
            }
            AttachmentCategory category = stackSlotMapping.remove(i);
            if (category == null) continue;
            logger.debug("Removing attachment '{}' from slot {}, with tag {} from stack '{}'", (Object)slotStack, (Object)i, (Object)MiscUtil.getTag(slotStack), (Object)this.itemStack);
            VirtualInventory e = this.elements.get(category);
            if (e == null) continue;
            AttachmentRemovedEvent event = new AttachmentRemovedEvent(this.owner, this.getRootStack(), this.itemStack, slotStack);
            Platform.getInstance().getEventBus().postEvent(event);
            e.itemStack = class_1799.field_8037;
            e.elements.clear();
        }
        slotMapping.saveSlotMapping();
        if (this.parent != null) {
            this.parent.onContentChange();
        }
        menu.updateAttachmentSlots();
        menu.method_7623();
        logger.debug("Virtual inventory {} handled changes for container {}, stack tags {}", (Object)this, (Object)container, (Object)MiscUtil.getTag(this.itemStack));
    }

    private void onContentChange() {
        logger.debug("Updating tag content for {}, tag: {}", (Object)this, (Object)MiscUtil.getTag(this.itemStack));
        this.updateTag();
        logger.debug("Updating tag content for {}, tag: {}", (Object)this, (Object)MiscUtil.getTag(this.itemStack));
        if (this.parent != null) {
            this.parent.updateTag();
        }
    }

    private class_2487 updateTag() {
        if (this.itemStack == null) {
            return null;
        }
        if (this.itemStack.method_7960()) {
            logger.error("Virtual inventory {} attempted to update empty stack {}", (Object)this, (Object)this.itemStack);
            return null;
        }
        class_2487 tag = MiscUtil.getOrCreateTag(this.itemStack);
        class_1792 class_17922 = this.itemStack.method_7909();
        if (class_17922 instanceof Attachment) {
            Attachment attachment = (Attachment)class_17922;
            String attachmentId = class_7923.field_41178.method_10221((Object)attachment.method_8389()).toString();
            tag.method_10582("id", attachmentId);
            tag.method_10556("rmv", tag.method_10577("rmv"));
        }
        class_2499 nestedAttachments = tag.method_10554("as", 10);
        nestedAttachments.clear();
        for (Map.Entry entry : this.elements.entrySet()) {
            class_2487 nestedAttachmentTag = ((VirtualInventory)entry.getValue()).updateTag();
            if (nestedAttachmentTag == null) continue;
            nestedAttachments.add((Object)nestedAttachmentTag);
        }
        tag.method_10566("as", (class_2520)nestedAttachments);
        MiscUtil.setTag(this.itemStack, tag);
        return tag;
    }

    Map<Integer, AttachmentCategory> createSlotMapping(String stackId) {
        HashMap<Integer, AttachmentCategory> mapping = new HashMap<Integer, AttachmentCategory>();
        int i = 1;
        for (AttachmentCategory category : this.getCategories()) {
            VirtualInventory e = this.getElement(category);
            class_1799 itemStack = e.getItemStack();
            if (itemStack != null && !itemStack.method_7960()) {
                mapping.put(i, category);
            }
            ++i;
        }
        return mapping;
    }

    boolean isValidSlotMapping(Map<Integer, AttachmentCategory> mapping) {
        if (mapping.isEmpty()) {
            return this.elements.isEmpty();
        }
        return this.elements.keySet().containsAll(mapping.values());
    }

    public String toString() {
        return String.format("{vi: %d, path: %s, elements: %s}", System.identityHashCode(this), this.getPath(), this.elements);
    }

    private static VirtualInventory createInventory(class_1657 owner, VirtualInventory parentInventory, class_1799 currentStack) {
        class_1792 class_17922;
        AttachmentCategory currentCategory = null;
        if (currentStack != null && (class_17922 = currentStack.method_7909()) instanceof Attachment) {
            Attachment attachment = (Attachment)class_17922;
            currentCategory = attachment.getCategory();
        }
        VirtualInventory currentInventory = new VirtualInventory(owner, currentCategory, parentInventory, currentStack);
        if (currentStack == null) {
            return currentInventory;
        }
        class_2487 currentTag = MiscUtil.getOrCreateTag(currentStack);
        class_1792 class_17923 = currentStack.method_7909();
        if (!(class_17923 instanceof AttachmentHost)) {
            return currentInventory;
        }
        AttachmentHost attachmentHost = (AttachmentHost)class_17923;
        HashMap<AttachmentCategory, class_1799> attachmentStacks = new HashMap<AttachmentCategory, class_1799>();
        if (currentTag.method_10573("as", 9)) {
            class_2499 attachmentsList = currentTag.method_10554("as", 10);
            for (int i = 0; i < attachmentsList.size(); ++i) {
                class_2487 attachmentTag = attachmentsList.method_10602(i);
                String itemId = attachmentTag.method_10558("id");
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)itemId));
                if (!(item instanceof Attachment)) continue;
                Attachment attachment = (Attachment)item;
                class_1799 attachmentItemStack = new class_1799((class_1935)item);
                MiscUtil.setTag(attachmentItemStack, attachmentTag);
                attachmentStacks.put(attachment.getCategory(), attachmentItemStack);
            }
        }
        for (AttachmentCategory category : attachmentHost.getCompatibleAttachmentCategories()) {
            class_1799 attachmentStack = (class_1799)attachmentStacks.get(category);
            VirtualInventory nestedInventory = attachmentStack == null ? new VirtualInventory(owner, category, currentInventory, null) : VirtualInventory.createInventory(owner, currentInventory, attachmentStack);
            if (nestedInventory == null) continue;
            currentInventory.addElement(nestedInventory);
        }
        logger.debug("Created {} with stack: {}, tag {}, elements: {}", (Object)currentInventory, (Object)currentStack, (Object)MiscUtil.getTag(currentStack), currentInventory.elements);
        return currentInventory;
    }

    public static VirtualInventory createInventory(class_1657 owner, class_1799 mainStack) {
        return VirtualInventory.createInventory(owner, null, mainStack);
    }
}

