/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mod.pbj.Nameable;
import mod.pbj.client.EntityRendererBuilder;
import mod.pbj.client.effect.AbstractEffect;
import mod.pbj.client.effect.Effect;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.client.render.ProjectileItemEntityRenderer;
import mod.pbj.client.render.ProjectileItemRenderer;
import mod.pbj.client.render.SpriteEntityRenderer;
import mod.pbj.crafting.Craftable;
import mod.pbj.entity.EntityBuilder;
import mod.pbj.entity.EntityBuilderProvider;
import mod.pbj.entity.ProjectileLike;
import mod.pbj.entity.SlowProjectile;
import mod.pbj.item.EffectBuilderInfo;
import mod.pbj.item.ExplosionProvider;
import mod.pbj.item.HurtingItem;
import mod.pbj.registry.EffectRegistry;
import mod.pbj.util.JsonUtil;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.SoundInfo;
import mod.pbj.util.TimeUnit;
import mod.pbj.util.TopDownAttackTrajectory;
import mod.pbj.util.Tradeable;
import mod.pbj.util.Trajectory;
import mod.pbj.util.TrajectoryPhaseListener;
import mod.pbj.util.TrajectoryProvider;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_756;
import net.minecraft.class_897;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AmmoItem
extends HurtingItem
implements ExplosionProvider,
TrajectoryProvider,
Craftable,
Nameable,
GeoItem,
Tradeable {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final RawAnimation ANIMATION_DRAW = RawAnimation.begin().thenPlay("animation.model.draw");
    private static final RawAnimation ANIMATION_THROW = RawAnimation.begin().thenPlay("animation.model.throw");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean hasProjectile;
    private String name;
    private float tradePrice;
    private int tradeBundleQuantity;
    private int tradeLevel;
    private List<EffectBuilderInfo> projectileEffectBuilderSuppliers;
    private EntityBuilder<?, ?> entityBuilder;
    private boolean isTopDownAttackEnabled;
    private double initialVelocity;
    private Map<TopDownAttackTrajectory.Phase, SoundInfo> topDownProjectileSoundEvents;
    private long craftingDuration;

    public AmmoItem(String name) {
        this(name, null);
    }

    public AmmoItem(String name, Builder builder) {
        super(new class_1792.class_1793(), builder);
        this.name = name;
        if (name.equals("grenade")) {
            SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        }
        if (builder != null) {
            this.tradePrice = builder.tradePrice;
            this.tradeBundleQuantity = builder.tradeBundleQuantity;
            this.tradeLevel = builder.tradeLevel;
            this.setHasProjectile(builder.hasProjectile);
            this.entityBuilder = builder.getOrCreateEntityBuilder();
            this.isTopDownAttackEnabled = builder.isTopDownAttackEnabled;
            this.initialVelocity = builder.initialVelocity;
            this.topDownProjectileSoundEvents = builder.topDownProjectileSoundEvents;
            this.craftingDuration = builder.craftingDuration;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ProjectileLike createProjectile(class_1309 player, double posX, double posY, double posZ) {
        ProjectileLike projectile = (ProjectileLike)this.entityBuilder.build(MiscUtil.getLevel((class_1297)player));
        ((class_1297)projectile).method_5814(posX, posY, posZ);
        ((class_1676)projectile).method_7432((class_1297)player);
        return projectile;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registry) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private class_756 renderer;

            public class_756 getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new ProjectileItemRenderer(AmmoItem.this.name);
                }
                return this.renderer;
            }
        });
    }

    public boolean isHasProjectile() {
        return this.hasProjectile;
    }

    public void setHasProjectile(boolean hasProjectile) {
        this.hasProjectile = hasProjectile;
    }

    @Override
    public float getPrice() {
        return this.tradePrice;
    }

    @Override
    public int getTradeLevel() {
        return this.tradeLevel;
    }

    @Override
    public int getBundleQuantity() {
        return this.tradeBundleQuantity;
    }

    @Override
    public long getCraftingDuration() {
        return this.craftingDuration;
    }

    @Override
    public Trajectory<?> createTrajectory(final class_1937 level, class_243 startPosition, class_243 targetLocation) {
        TopDownAttackTrajectory trajectory = null;
        if (this.isTopDownAttackEnabled) {
            TopDownAttackTrajectory topDownAttackTrajectory = TopDownAttackTrajectory.createTrajectory(startPosition, targetLocation, this.initialVelocity);
            if (topDownAttackTrajectory != null) {
                topDownAttackTrajectory.addListener(new TrajectoryPhaseListener<TopDownAttackTrajectory.Phase>(){

                    @Override
                    public void onStartPhase(TopDownAttackTrajectory.Phase phase, class_243 position) {
                        SoundInfo soundInfo;
                        if (AmmoItem.this.topDownProjectileSoundEvents != null && (soundInfo = AmmoItem.this.topDownProjectileSoundEvents.get((Object)phase)) != null) {
                            level.method_8486(position.field_1352, position.field_1351, position.field_1350, soundInfo.soundEvent().get(), class_3419.field_15245, soundInfo.volume(), 1.0f, false);
                        }
                    }
                });
            }
            trajectory = topDownAttackTrajectory;
        }
        return trajectory;
    }

    public static class Builder
    extends HurtingItem.Builder<Builder>
    implements Nameable {
        private static final double DEFAULT_GRAVITY = 0.05;
        private static final float DEFAULT_INITIAL_VELOCITY = 50.0f;
        private static final float DEFAULT_WIDTH = 0.25f;
        private static final float DEFAULT_HEIGHT = 0.25f;
        private static final float DEFAULT_PRICE = Float.NaN;
        private static final int DEFAULT_TRADE_LEVEL = 0;
        private static final int DEFAULT_TRADE_BUNDLE_QUANTITY = 1;
        private static final int DEFAULT_CRAFTING_DURATION = 500;
        private static Effect.BlendMode DEFAULT_BLEND_MODE = Effect.BlendMode.NORMAL;
        private String name;
        private float tradePrice = Float.NaN;
        private int tradeBundleQuantity = 1;
        private int tradeLevel = 0;
        private Supplier<EntityBuilder<?, ?>> entityBuilderSupplier;
        private boolean hasProjectile;
        private boolean isTopDownAttackEnabled;
        private List<EffectBuilderInfo> projectileEffectBuilderSuppliers = new ArrayList<EffectBuilderInfo>();
        private Supplier<EntityRendererBuilder<?, class_1297, class_897<class_1297>>> rendererBuilder;
        private double gravity = 0.05;
        private double initialVelocity = 50.0;
        private float boundingBoxWidth = 0.25f;
        private float boundingBoxHeight = 0.25f;
        private EntityBuilder<?, ?> entityBuilder;
        private Map<TopDownAttackTrajectory.Phase, SoundInfo> topDownProjectileSoundEvents = new HashMap<TopDownAttackTrajectory.Phase, SoundInfo>();
        private long craftingDuration = 500L;
        private AmmoItem builtItem;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCraftingDuration(int duration, TimeUnit timeUnit) {
            this.craftingDuration = timeUnit.toMillis(duration);
            return this;
        }

        public Builder withTradePrice(double price, int tradeBundleQuantity, int tradeLevel) {
            this.tradePrice = (float)price;
            this.tradeLevel = tradeLevel;
            this.tradeBundleQuantity = tradeBundleQuantity;
            return this;
        }

        public Builder withTradePrice(double price, int tradeLevel) {
            return this.withTradePrice(price, 1, tradeLevel);
        }

        public Builder withProjectileInitialVelocity(double initialVelocity) {
            this.hasProjectile = true;
            this.initialVelocity = initialVelocity;
            return this;
        }

        public Builder withProjectileGravity(double gravity) {
            this.hasProjectile = true;
            this.gravity = gravity;
            return this;
        }

        public Builder withProjectileRenderer(Supplier<EntityRendererBuilder<?, class_1297, class_897<class_1297>>> rendererBuilder) {
            this.hasProjectile = true;
            this.rendererBuilder = rendererBuilder;
            return this;
        }

        public Builder withProjectileEffect(Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> effectSupplier) {
            this.hasProjectile = true;
            this.projectileEffectBuilderSuppliers.add(new EffectBuilderInfo(effectSupplier, p -> true));
            return this;
        }

        public Builder withProjectileEffect(Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> effectSupplier, Predicate<ProjectileLike> predicate) {
            this.hasProjectile = true;
            this.projectileEffectBuilderSuppliers.add(new EffectBuilderInfo(effectSupplier, predicate));
            return this;
        }

        public Builder withProjectileTopDownAttackEnabled(boolean topDownAttackEnabled) {
            this.isTopDownAttackEnabled = topDownAttackEnabled;
            return this;
        }

        public Builder withProjectileTopDownAttackPhaseSound(TopDownAttackTrajectory.Phase phase, Supplier<class_3414> sound, float volume) {
            this.topDownProjectileSoundEvents.put(phase, new SoundInfo(sound, volume));
            return this;
        }

        public Builder withProjectileBoundingBoxSize(float width, float height) {
            this.hasProjectile = true;
            this.boundingBoxWidth = width;
            this.boundingBoxHeight = height;
            return this;
        }

        public Builder withEntityBuilderProvider(Supplier<EntityBuilder<?, ?>> entityBuilderSupplier) {
            this.entityBuilderSupplier = entityBuilderSupplier;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj, boolean isClientSide) {
            super.withJsonObject(obj, isClientSide);
            this.withName(JsonUtil.getJsonString(obj, "name"));
            this.withTradePrice(JsonUtil.getJsonFloat(obj, "tradePrice", Float.NaN), JsonUtil.getJsonInt(obj, "traceBundleQuantity", 1), JsonUtil.getJsonInt(obj, "tradeLevel", 0));
            this.withCraftingDuration(JsonUtil.getJsonInt(obj, "craftingDuration", 500), TimeUnit.MILLISECOND);
            JsonObject projectileObj = obj.getAsJsonObject("projectile");
            if (projectileObj != null) {
                float size = JsonUtil.getJsonFloat(projectileObj, "boundingBoxSize", Float.NEGATIVE_INFINITY);
                if (size > 0.0f) {
                    this.withProjectileBoundingBoxSize(size, size);
                } else {
                    float width = JsonUtil.getJsonFloat(projectileObj, "width", 0.25f);
                    float height = JsonUtil.getJsonFloat(projectileObj, "height", 0.25f);
                    this.withProjectileBoundingBoxSize(width, height);
                    size = Math.max(width, height);
                }
                this.withProjectileGravity(JsonUtil.getJsonDouble(projectileObj, "gravity", 0.05));
                this.withProjectileInitialVelocity(JsonUtil.getJsonDouble(projectileObj, "initialVelocity", 0.05));
                this.withProjectileTopDownAttackEnabled(JsonUtil.getJsonBoolean(projectileObj, "topDownAttackEnabled", false));
                JsonObject rendererObj = projectileObj.getAsJsonObject("renderer");
                if (rendererObj != null && isClientSide) {
                    String rendererType = JsonUtil.getJsonString(rendererObj, "type");
                    if (rendererType.equalsIgnoreCase("sprite")) {
                        SpriteEntityRenderer.Builder rendererBuilder = new SpriteEntityRenderer.Builder();
                        rendererBuilder.withTexture(JsonUtil.getJsonString(rendererObj, "texture"));
                        rendererBuilder.withSize(JsonUtil.getJsonFloat(rendererObj, "size", size));
                        JsonObject spritesObj = rendererObj.getAsJsonObject("sprites");
                        if (spritesObj == null) {
                            throw new IllegalArgumentException("Element 'sprites' not defined in json: " + String.valueOf(rendererObj));
                        }
                        int rows = JsonUtil.getJsonInt(spritesObj, "rows", 1);
                        int columns = JsonUtil.getJsonInt(spritesObj, "columns", 1);
                        int fps = JsonUtil.getJsonInt(spritesObj, "fps", 60);
                        AbstractEffect.SpriteAnimationType spriteAnimationType = JsonUtil.getEnum(spritesObj, "type", AbstractEffect.SpriteAnimationType.class, AbstractEffect.SpriteAnimationType.LOOP, true);
                        rendererBuilder.withSprites(rows, columns, fps, spriteAnimationType);
                        rendererBuilder.withBlendMode(JsonUtil.getEnum(rendererObj, "blendMode", Effect.BlendMode.class, DEFAULT_BLEND_MODE, true));
                        rendererBuilder.withDepthTest(JsonUtil.getJsonBoolean(rendererObj, "depthTest", true));
                        rendererBuilder.withGlow(JsonUtil.getJsonBoolean(rendererObj, "glow", false));
                        rendererBuilder.withRotations(JsonUtil.getJsonFloat(rendererObj, "rotations", 0.0f));
                        this.withProjectileRenderer(() -> rendererBuilder);
                    } else if (rendererType.toLowerCase().equals("model")) {
                        this.withProjectileRenderer(() -> new ProjectileItemEntityRenderer.Builder());
                    }
                }
                for (String effectName : JsonUtil.getStrings(projectileObj, "effects")) {
                    Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> supplier = () -> EffectRegistry.getEffectBuilderSupplier(effectName).get();
                    this.withProjectileEffect(supplier);
                }
            }
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public AmmoItem build() {
            if (this.builtItem == null) {
                this.builtItem = new AmmoItem(this.name, this);
            }
            return this.builtItem;
        }

        @Override
        public EntityBuilderProvider getEntityBuilderProvider() {
            return this.hasProjectile ? () -> this.getOrCreateEntityBuilder() : null;
        }

        private EntityBuilder<?, ?> getOrCreateEntityBuilder() {
            if (this.entityBuilder == null) {
                this.entityBuilder = this.entityBuilderSupplier != null ? this.entityBuilderSupplier.get() : SlowProjectile.builder();
                this.entityBuilder.withItem(this::build);
                if (this.rendererBuilder != null) {
                    this.entityBuilder.withRenderer(this.rendererBuilder);
                }
                this.entityBuilder.withName(this.name);
                this.entityBuilder.withInitialVelocity(this.initialVelocity);
                this.entityBuilder.withGravity(this.gravity);
                for (EffectBuilderInfo ebi : this.projectileEffectBuilderSuppliers) {
                    this.entityBuilder.withEffect(ebi);
                }
            }
            return this.entityBuilder;
        }
    }
}

