/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.pbj.Nameable;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.attachment.Attachments;
import mod.pbj.client.controller.GlowAnimationController;
import mod.pbj.client.effect.AbstractEffect;
import mod.pbj.client.render.ArmorInHandRenderer;
import mod.pbj.client.render.ArmorItemRenderer;
import mod.pbj.crafting.Craftable;
import mod.pbj.feature.AttributeFeature;
import mod.pbj.feature.DefenseFeature;
import mod.pbj.feature.DescriptionFeature;
import mod.pbj.feature.Feature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.Features;
import mod.pbj.item.AttachmentItem;
import mod.pbj.item.ExpandedAttributes;
import mod.pbj.item.GunItem;
import mod.pbj.item.ItemBuilder;
import mod.pbj.registry.ItemRegistry;
import mod.pbj.util.JsonUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_5151;
import net.minecraft.class_572;
import net.minecraft.class_6880;
import net.minecraft.class_756;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArmorItem
extends class_1738
implements class_5151,
Nameable,
Craftable,
AttachmentHost,
GeoItem,
ExpandedAttributes {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String name;
    public class_2960 modelResourceLocation;
    private final List<Supplier<Attachment>> compatibleAttachmentsSuppliers;
    private Collection<Attachment> compatibleAttachments;
    private final List<String> compatibleAttachmentGroups;
    private final Map<Class<? extends Feature>, Feature> features;
    private final List<Supplier<AttachmentItem>> defaultAttachments;
    protected final class_1738.class_8051 type;
    private final int defense;
    private final float toughness;
    protected final float knockbackResistance;
    private final class_1856 repairMaterial;
    private final long craftingDuration;
    private final class_6880<class_3414> equipSound;
    private final List<GlowAnimationController.Builder> glowEffectBuilders;

    public ArmorItem(Builder builder, String namespace) {
        super(class_1740.field_7897, builder.armorType, new class_1792.class_1793().method_7889(1).method_7895(builder.durability));
        this.name = builder.name;
        this.modelResourceLocation = this.name.contains(":") ? class_2960.method_60654((String)this.name) : class_2960.method_60655((String)namespace, (String)this.name);
        this.glowEffectBuilders = builder.glowEffectBuilders;
        this.defense = builder.armor;
        this.type = builder.armorType;
        this.toughness = builder.armorToughness;
        this.equipSound = builder.equipSound;
        this.knockbackResistance = builder.knockbackResistance;
        this.compatibleAttachmentGroups = builder.compatibleAttachmentGroups;
        this.defaultAttachments = builder.defaultAttachments;
        this.compatibleAttachmentsSuppliers = builder.compatibleAttachments;
        this.craftingDuration = builder.craftingDuration;
        this.repairMaterial = class_1856.method_26964(builder.repairItems.stream());
        HashMap features = new HashMap();
        for (FeatureBuilder<?, ?> featureBuilder : builder.featureBuilders) {
            Object feature = featureBuilder.build(this);
            features.put(feature.getClass(), feature);
        }
        this.features = Collections.unmodifiableMap(features);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public Collection<Attachment> getCompatibleAttachments() {
        if (this.compatibleAttachments == null) {
            HashSet<AttachmentCategory> attachmentCategories = new HashSet<AttachmentCategory>();
            LinkedHashSet<Attachment> compatibleAttachments = new LinkedHashSet<Attachment>();
            for (Attachment attachment : this.getDefaultAttachments()) {
                if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) break;
                attachmentCategories.add(attachment.getCategory());
                compatibleAttachments.add(attachment);
            }
            for (Supplier supplier : this.compatibleAttachmentsSuppliers) {
                Attachment attachment = (Attachment)supplier.get();
                if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) break;
                attachmentCategories.add(attachment.getCategory());
                compatibleAttachments.add(attachment);
            }
            block2: for (String string : this.compatibleAttachmentGroups) {
                for (Supplier<? extends class_1792> ga : ItemRegistry.ITEMS.getAttachmentsForGroup(string)) {
                    class_1792 item = ga.get();
                    if (!(item instanceof Attachment)) continue;
                    Attachment attachment = (Attachment)item;
                    if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) continue block2;
                    compatibleAttachments.add(attachment);
                }
            }
            this.compatibleAttachments = compatibleAttachments;
        }
        return this.compatibleAttachments;
    }

    @Override
    public long getCraftingDuration() {
        return this.craftingDuration;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return this.features.values();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private ArmorItemRenderer renderer = null;
            public ArmorInHandRenderer inHandRenderer = null;

            @Nullable
            public class_756 getGeoItemRenderer() {
                if (this.inHandRenderer == null) {
                    this.inHandRenderer = new ArmorInHandRenderer(ArmorItem.this.modelResourceLocation, ArmorItem.this.glowEffectBuilders);
                }
                return this.inHandRenderer;
            }

            @Nullable
            public <T extends class_1309> class_572<?> getGeoArmorRenderer(@Nullable T livingEntity, class_1799 itemStack, @Nullable class_1304 equipmentSlot, @Nullable class_572<T> original) {
                if (this.inHandRenderer == null) {
                    this.inHandRenderer = new ArmorInHandRenderer(ArmorItem.this.modelResourceLocation, ArmorItem.this.glowEffectBuilders);
                }
                if (this.renderer == null) {
                    this.renderer = new ArmorItemRenderer(((ArmorItem)itemStack.method_7909()).modelResourceLocation, this.inHandRenderer);
                }
                this.renderer.prepForRender((class_1297)livingEntity, itemStack, equipmentSlot, (class_572)original);
                return this.renderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class_1738.class_8051 method_48398() {
        return this.type;
    }

    public int method_7837() {
        return 0;
    }

    public boolean method_7878(class_1799 pToRepair, class_1799 pRepair) {
        return this.repairMaterial.method_8093(pRepair) || super.method_7878(pToRepair, pRepair);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        for (Feature descFeature : Features.getEnabledFeatures(stack, DescriptionFeature.class).stream().map(Features.EnabledFeature::feature).toList()) {
            tooltipComponents.add(((DescriptionFeature)descFeature).getMutableDescription());
        }
    }

    public int getDefaultTooltipHideFlags(@NotNull class_1799 stack) {
        return 2;
    }

    public int getAdjustedDefense(class_1799 stack) {
        float defenseMod = DefenseFeature.getDefenseModifier(stack);
        int defenseAdd = DefenseFeature.getDefenseAdditive(stack);
        int defenseFinal = (int)((float)this.defense * defenseMod) + defenseAdd;
        return defenseFinal;
    }

    public float getAdjustedToughness(class_1799 stack) {
        float toughnessMod = DefenseFeature.getToughnessModifier(stack);
        float toughnessAdd = DefenseFeature.getToughnessAdditive(stack);
        float toughnessFinal = this.toughness * toughnessMod + toughnessAdd;
        return toughnessFinal;
    }

    public int method_7687() {
        return this.defense;
    }

    public float method_26353() {
        return this.toughness;
    }

    public class_1304 method_7685() {
        return this.type.method_48399();
    }

    public class_6880<class_3414> method_31570() {
        return this.equipSound;
    }

    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        for (Supplier<AttachmentItem> attachmentSupplier : this.defaultAttachments) {
            Attachments.addAttachment(stack, attachmentSupplier.get().method_7854(), true);
        }
        return stack;
    }

    @Override
    public class_9285 getDefaultAttributeModifiers(class_1799 stack) {
        class_9285.class_9286 builder = class_9285.method_57480();
        for (AttributeFeature feature : Features.getEnabledFeatures(stack, AttributeFeature.class).stream().map(enb -> (AttributeFeature)enb.feature()).toList()) {
            builder.method_57487(feature.baseAttribute, feature.modifier, class_9274.method_59524((class_1304)this.method_7685()));
        }
        int i = this.getAdjustedDefense(stack);
        float f = this.getAdjustedToughness(stack);
        class_9274 equipmentSlotGroup = class_9274.method_59524((class_1304)this.type.method_48399());
        class_2960 resourceLocation = class_2960.method_60656((String)("armor." + this.type.method_48400()));
        builder.method_57487(class_5134.field_23724, new class_1322(resourceLocation, (double)i, class_1322.class_1323.field_6328), equipmentSlotGroup);
        builder.method_57487(class_5134.field_23725, new class_1322(resourceLocation, (double)f, class_1322.class_1323.field_6328), equipmentSlotGroup);
        float g = ((class_1741)this.field_7881.comp_349()).comp_2304();
        if (g > 0.0f) {
            builder.method_57487(class_5134.field_23718, new class_1322(resourceLocation, (double)g, class_1322.class_1323.field_6328), equipmentSlotGroup);
        }
        return builder.method_57486();
    }

    public static class Builder
    extends ItemBuilder<Builder> {
        private long craftingDuration = 500L;
        private int armor;
        private float armorToughness;
        private float knockbackResistance;
        private int durability;
        private String name;
        private final class_6880<class_3414> equipSound = class_3417.field_14883;
        private class_1738.class_8051 armorType;
        private final List<class_1799> repairItems;
        private final List<Supplier<Attachment>> compatibleAttachments;
        private final List<String> compatibleAttachmentGroups;
        private final List<FeatureBuilder<?, ?>> featureBuilders;
        private final List<Supplier<AttachmentItem>> defaultAttachments;
        private final List<GlowAnimationController.Builder> glowEffectBuilders = new ArrayList<GlowAnimationController.Builder>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withArmorToughness(float toughness) {
            this.armorToughness = toughness;
            return this;
        }

        public Builder withArmor(int armor) {
            this.armor = armor;
            return this;
        }

        public Builder withType(class_1738.class_8051 type) {
            this.armorType = type;
            return this;
        }

        public Builder withKnockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        private Builder withCraftingDuration(long craftingDuration) {
            this.craftingDuration = craftingDuration;
            return this;
        }

        private Builder withFeature(FeatureBuilder<?, ?> featureBuilder) {
            this.featureBuilders.add(featureBuilder);
            return this;
        }

        private Builder withDurability(int durability) {
            this.durability = durability;
            return this;
        }

        public Builder withGlow(String glowingPartName) {
            return this.withGlow(glowingPartName, null);
        }

        public Builder withGlow(String glowingPartName, String textureName) {
            return this.withGlow(Collections.singleton(GunItem.FirePhase.ANY), Collections.singleton(glowingPartName), textureName);
        }

        public Builder withGlow(Collection<GunItem.FirePhase> firePhases, String glowingPartName) {
            return this.withGlow(firePhases, Collections.singleton(glowingPartName), null);
        }

        public Builder withGlow(Collection<GunItem.FirePhase> firePhases, Collection<String> glowingPartNames, String texture) {
            GlowAnimationController.Builder builder = new GlowAnimationController.Builder().withFirePhases(firePhases);
            if (texture != null) {
                builder.withTexture(class_2960.method_60655((String)"pointblank", (String)texture));
            }
            builder.withGlowingPartNames(glowingPartNames);
            this.glowEffectBuilders.add(builder);
            return this;
        }

        public Builder withGlow(Collection<GunItem.FirePhase> firePhases, String glowingPartName, String texture, AbstractEffect.SpriteAnimationType spriteAnimationType, int spriteRows, int spriteColumns, int spritesPerSecond, class_2350 ... directions) {
            GlowAnimationController.Builder builder = new GlowAnimationController.Builder().withFirePhases(firePhases);
            if (texture != null) {
                builder.withTexture(class_2960.method_60655((String)"pointblank", (String)texture));
            }
            builder.withGlowingPartNames(Collections.singleton(glowingPartName));
            builder.withSprites(spriteRows, spriteColumns, spritesPerSecond, spriteAnimationType);
            builder.withDirections(directions);
            this.glowEffectBuilders.add(builder);
            return this;
        }

        public Builder() {
            this.compatibleAttachments = new ArrayList<Supplier<Attachment>>();
            this.compatibleAttachmentGroups = new ArrayList<String>();
            this.featureBuilders = new ArrayList();
            this.defaultAttachments = new ArrayList<Supplier<AttachmentItem>>();
            this.repairItems = new ArrayList<class_1799>();
        }

        @Override
        public Builder withJsonObject(JsonObject obj, boolean isClientSide) {
            Supplier ri;
            this.withName(JsonUtil.getJsonString(obj, "name")).withCraftingDuration(JsonUtil.getJsonInt(obj, "craftingDuration", 500)).withArmor(JsonUtil.getJsonInt(obj, "defense", 0)).withDurability(JsonUtil.getJsonInt(obj, "durability", 128)).withArmorToughness(JsonUtil.getJsonFloat(obj, "toughness", 0.0f)).withType(JsonUtil.getEnum(obj, "armorType", class_1738.class_8051.class, class_1738.class_8051.field_41934, true));
            for (JsonObject featureObj : JsonUtil.getJsonObjects(obj, "features")) {
                FeatureBuilder<?, ?> featureBuilder = Features.fromJson(featureObj);
                this.withFeature(featureBuilder);
            }
            for (String compatibleAttachmentName : JsonUtil.getStrings(obj, "compatibleAttachments")) {
                ri = ItemRegistry.ITEMS.getDeferredRegisteredObject(compatibleAttachmentName);
                if (ri == null) continue;
                this.compatibleAttachments.add(() -> (Attachment)ri.get());
            }
            for (String compatibleAttachmentName : JsonUtil.getStrings(obj, "defaultAttachments")) {
                ri = ItemRegistry.ITEMS.getDeferredRegisteredObject(compatibleAttachmentName);
                if (ri == null) continue;
                this.defaultAttachments.add(() -> (AttachmentItem)ri.get());
            }
            for (JsonObject glowingPart : JsonUtil.getJsonObjects(obj, "glowingParts")) {
                String partName = JsonUtil.getJsonString(glowingPart, "name");
                List<GunItem.FirePhase> firePhases = Collections.singletonList(GunItem.FirePhase.ANY);
                String textureName = JsonUtil.getJsonString(glowingPart, "texture", null);
                class_2350 direction = JsonUtil.getEnum(glowingPart, "direction", class_2350.class, null, true);
                JsonObject spritesObj = glowingPart.getAsJsonObject("sprites");
                if (spritesObj != null) {
                    int rows = JsonUtil.getJsonInt(spritesObj, "rows", 1);
                    int columns = JsonUtil.getJsonInt(spritesObj, "columns", 1);
                    int fps = JsonUtil.getJsonInt(spritesObj, "fps", 60);
                    AbstractEffect.SpriteAnimationType spriteAnimationType = JsonUtil.getEnum(spritesObj, "type", AbstractEffect.SpriteAnimationType.class, AbstractEffect.SpriteAnimationType.LOOP, true);
                    if (direction != null) {
                        this.withGlow(firePhases, partName, textureName, spriteAnimationType, rows, columns, fps, direction);
                        continue;
                    }
                    this.withGlow(firePhases, partName, textureName, spriteAnimationType, rows, columns, fps, new class_2350[0]);
                    continue;
                }
                this.withGlow(firePhases, Collections.singletonList(partName), textureName);
            }
            List<String> compatibleAttachmentGroups = JsonUtil.getStrings(obj, "compatibleAttachmentGroups");
            this.compatibleAttachmentGroups.addAll(compatibleAttachmentGroups);
            return this;
        }

        public ArmorItem build() {
            return new ArmorItem(this, "pointblank");
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

