/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mod.pbj.Config;
import mod.pbj.Enableable;
import mod.pbj.Platform;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.config.ConfigManager;
import mod.pbj.config.ConfigOptionBuilder;
import mod.pbj.config.Configurable;
import mod.pbj.entity.EntityExt;
import mod.pbj.event.BlockHitEvent;
import mod.pbj.explosion.CustomExplosion;
import mod.pbj.feature.DamageFeature;
import mod.pbj.feature.FireModeFeature;
import mod.pbj.item.ExplosionDescriptor;
import mod.pbj.item.ItemBuilder;
import mod.pbj.network.CustomClientBoundExplosionPacket;
import mod.pbj.network.SpawnParticlePacket;
import mod.pbj.registry.EffectRegistry;
import mod.pbj.registry.SoundRegistry;
import mod.pbj.util.HitScan;
import mod.pbj.util.JsonUtil;
import mod.pbj.util.MiscUtil;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5362;
import net.minecraft.class_8109;

public abstract class HurtingItem
extends class_1792
implements Enableable {
    private static final float DEFAULT_EXPLOSION_SOUND_VOLUME = 4.0f;
    public static final double DEFAULT_MAX_SHOOTING_DISTANCE = 200.0;
    public static final float DEFAULT_DAMAGE = 5.0f;
    public static final float DEFAULT_HEADSHOT_SOUND_VOLUME = 3.0f;
    public static final float DEFAULT_LIGHT_DAMAGE_SOUND_VOLUME = 3.0f;
    public static final float DEFAULT_HEAVY_DAMAGE_SOUND_VOLUME = 3.0f;
    public static final float MAX_LIGHT_DAMAGE = 15.0f;
    public static final long DEFAULT_ENTITY_HIT_SOUND_COOLDOWN = 100L;
    protected ExplosionDescriptor explosionDescriptor;
    protected double maxShootingDistance;
    protected float damage;
    protected boolean isEnabled;
    protected float headshotSoundVolume;
    protected Supplier<class_3414> headshotSound;
    protected float lightDamageSoundVolume;
    protected Supplier<class_3414> lightDamageSound;
    protected float heavyDamageSoundVolume;
    protected Supplier<class_3414> heavyDamageSound;
    protected long entityHitSoundCooldown = 100L;

    public HurtingItem(class_1792.class_1793 properties, Builder<?> builder) {
        super(properties);
        if (builder != null) {
            this.explosionDescriptor = builder.explosionDescriptor;
            this.maxShootingDistance = builder.maxShootingDistance;
            this.isEnabled = builder.configOptionEnabled.get();
            this.damage = builder.configOptionDamage.get().floatValue();
            this.headshotSound = builder.headshotSound;
            this.headshotSoundVolume = builder.headshotSoundVolume;
            this.lightDamageSound = builder.lightDamageSound;
            this.lightDamageSoundVolume = builder.lightDamageSoundVolume;
            this.heavyDamageSound = builder.heavyDamageSound;
            this.heavyDamageSoundVolume = builder.heavyDamageSoundVolume;
        }
    }

    public float getDamage() {
        return this.damage;
    }

    public ExplosionDescriptor getExplosion() {
        return this.explosionDescriptor;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public float hurtEntity(class_1309 player, class_3966 entityHitResult, class_1297 projectile, class_1799 gunStack) {
        float damage = 0.0f;
        if (this.getExplosion() != null) {
            class_243 hitLocation = entityHitResult.method_17782().method_30950(0.0f);
            if (!MiscUtil.isProtected(entityHitResult.method_17782())) {
                this.explode(MiscUtil.getLevel((class_1297)player), projectile, null, hitLocation.field_1352, hitLocation.field_1351, hitLocation.field_1350);
            }
        } else {
            class_1297 hitEntity = entityHitResult.method_17782();
            if (MiscUtil.isProtected(hitEntity)) {
                class_243 pos = hitEntity.method_19538();
                MiscUtil.getLevel((class_1297)player).method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_15051, class_3419.field_15256, 3.0f, 1.0f);
            } else {
                class_1282 damageSource;
                boolean isHeadshot = false;
                if (hitEntity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)hitEntity;
                    isHeadshot = HitScan.isHeadshot(livingEntity, entityHitResult.method_17784());
                }
                if (player instanceof class_1657) {
                    damageSource = player.method_48923().method_48802((class_1657)player);
                } else {
                    class_8109 damageSources = MiscUtil.getLevel((class_1297)player).method_48963();
                    damageSource = damageSources.method_48830();
                }
                int origInvulnerableTime = hitEntity.field_6008;
                hitEntity.field_6008 = 0;
                double distanceToPlayer = entityHitResult.method_24801((class_1297)player);
                double adjustedDamage = FireModeFeature.getDamage(gunStack);
                if (isHeadshot) {
                    adjustedDamage *= Config.headshotDamageModifier;
                }
                adjustedDamage *= class_3532.method_15350((double)(1.0 - Math.pow(Math.sqrt(distanceToPlayer) / this.maxShootingDistance * 0.5, 6.0)), (double)0.0, (double)1.0);
                if (gunStack != null) {
                    adjustedDamage *= (double)DamageFeature.getHitScanDamageModifier(gunStack);
                    adjustedDamage *= Config.hitscanDamageModifier;
                }
                hitEntity.method_5643(damageSource, (float)adjustedDamage);
                EntityExt entityExt = (EntityExt)hitEntity;
                if (System.currentTimeMillis() - entityExt.getLastHitSoundTimestamp() > this.entityHitSoundCooldown) {
                    entityExt.setLastHitSoundTimestamp(System.currentTimeMillis());
                    if (isHeadshot && !MiscUtil.getLevel((class_1297)hitEntity).field_9236) {
                        MiscUtil.getLevel(hitEntity).method_43128(null, hitEntity.method_23317(), hitEntity.method_23318(), hitEntity.method_23321(), this.headshotSound.get(), class_3419.field_15248, this.headshotSoundVolume, 1.0f);
                    } else if (adjustedDamage < 15.0) {
                        MiscUtil.getLevel(hitEntity).method_43128(null, hitEntity.method_23317(), hitEntity.method_23318(), hitEntity.method_23321(), this.lightDamageSound.get(), class_3419.field_15248, this.lightDamageSoundVolume, 1.0f);
                    } else {
                        MiscUtil.getLevel(hitEntity).method_43128(null, hitEntity.method_23317(), hitEntity.method_23318(), hitEntity.method_23321(), this.heavyDamageSound.get(), class_3419.field_15248, this.heavyDamageSoundVolume, 1.0f);
                    }
                }
                hitEntity.field_6008 = origInvulnerableTime;
                damage = (float)adjustedDamage;
            }
        }
        if (projectile != null) {
            projectile.method_31472();
        }
        return damage;
    }

    public void handleBlockHit(class_1309 player, class_3965 blockHitResult, class_1297 projectile) {
        BlockHitEvent event = new BlockHitEvent(player, blockHitResult, projectile);
        Platform.getInstance().getEventBus().postEvent(event);
        if (!event.isCanceled()) {
            HurtingItem.spawnBlockBreakParticles((class_3222)player, blockHitResult.method_17777(), blockHitResult.method_17784());
            if (this.getExplosion() != null) {
                class_243 hitLocation = blockHitResult.method_17784();
                this.explode(MiscUtil.getLevel((class_1297)player), projectile, null, hitLocation.field_1352, hitLocation.field_1351, hitLocation.field_1350);
            }
            if (projectile != null) {
                projectile.method_31472();
            }
        }
    }

    public void discardProjectile(class_1297 projectile) {
        this.explodeProjectile(projectile);
    }

    public void explodeProjectile(class_1297 projectile) {
        this.explode(MiscUtil.getLevel(projectile), projectile, null, projectile.method_23317(), projectile.method_23318(), projectile.method_23321());
    }

    private static void spawnBlockBreakParticles(class_3222 player, class_2338 blockPos, class_243 hitLocation) {
        class_1937 level = MiscUtil.getLevel((class_1297)player);
        class_2680 blockState = level.method_8320(blockPos);
        if (blockState != null) {
            Platform.getInstance().getNetworkService().sendToClient(new SpawnParticlePacket((class_2396<?>)class_2398.field_11251, hitLocation.field_1352, hitLocation.field_1351, hitLocation.field_1350, 5), (class_1657)player);
        }
    }

    private void explode(class_1937 level, class_1297 entity, class_1282 damageSource, double posX, double posY, double posZ) {
        boolean fire;
        if (level.field_9236) {
            throw new IllegalArgumentException("Cannot use this method on the client side");
        }
        class_5362 calc = null;
        float power = this.explosionDescriptor.power();
        CustomExplosion customExplosion = CustomExplosion.explode(level, this, entity, damageSource, calc, posX, posY, posZ, power, fire = this.explosionDescriptor.fire(), this.explosionDescriptor.interaction(), false);
        if (!customExplosion.method_46667()) {
            customExplosion.method_8352();
        }
        for (class_3222 player : ((class_3218)level).method_18766(p -> true)) {
            if (!(player.method_5649(posX, posY, posZ) < 22000.0)) continue;
            Platform.getInstance().getNetworkService().sendToClient(new CustomClientBoundExplosionPacket(this, posX, posY, posZ, power, customExplosion.method_8346(), (class_243)customExplosion.method_8351().get(player)), (class_1657)player);
        }
    }

    public static abstract class Builder<T extends ItemBuilder<T>>
    extends ItemBuilder<T>
    implements Configurable,
    Enableable {
        private ExplosionDescriptor explosionDescriptor;
        private double maxShootingDistance = 200.0;
        private float damage = 5.0f;
        private Supplier<Boolean> configOptionEnabled;
        private Supplier<Double> configOptionDamage;
        private float headshotSoundVolume = 3.0f;
        private Supplier<class_3414> headshotSound = SoundRegistry.HIT_HEADSHOT;
        protected float lightDamageSoundVolume = 3.0f;
        protected Supplier<class_3414> lightDamageSound = SoundRegistry.HIT_LIGHT;
        protected float heavyDamageSoundVolume = 3.0f;
        protected Supplier<class_3414> heavyDamageSound = SoundRegistry.HIT_HEAVY;

        protected T cast(Builder<T> _this) {
            return (T)_this;
        }

        public T withDamage(float damage) {
            this.damage = damage;
            return this.cast(this);
        }

        public T withHeadshotSound(Supplier<class_3414> headshotSound, float headshotSoundVolume) {
            this.headshotSound = headshotSound;
            this.headshotSoundVolume = headshotSoundVolume;
            return this.cast(this);
        }

        public T withLightDamageSound(Supplier<class_3414> lightDamageSound, float lightDamageSoundVolume) {
            this.lightDamageSound = lightDamageSound;
            this.lightDamageSoundVolume = lightDamageSoundVolume;
            return this.cast(this);
        }

        public T withHeavyDamageSound(Supplier<class_3414> heavyDamageSound, float heavyDamageSoundVolume) {
            this.heavyDamageSound = heavyDamageSound;
            this.heavyDamageSoundVolume = heavyDamageSoundVolume;
            return this.cast(this);
        }

        public T withMaxShootingDistance(double distance) {
            this.maxShootingDistance = distance;
            return this.cast(this);
        }

        public T withExplosion(float power, boolean fire, class_1937.class_7867 explosionInteraction, List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>> effects) {
            return this.withExplosion(power, fire, explosionInteraction, null, 4.0f, effects);
        }

        public T withExplosion(float power, boolean fire, class_1937.class_7867 explosionInteraction, String soundName, float soundVolume, List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>> effects) {
            this.explosionDescriptor = new ExplosionDescriptor(power, fire, explosionInteraction, soundName, soundVolume, effects);
            return this.cast(this);
        }

        @Override
        public void configure(ConfigManager.Builder builder) {
            this.configOptionEnabled = ((ConfigOptionBuilder)((ConfigOptionBuilder)((ConfigOptionBuilder)builder.createBooleanOption().withName(this.getName() + ".enabled")).withDescription("Set to `false` to remove the item from the game.")).withDefault(true)).getSupplier();
            this.configOptionDamage = ((ConfigOptionBuilder)((ConfigOptionBuilder)((ConfigOptionBuilder)((ConfigOptionBuilder)builder.createDoubleOption().withName(this.getName() + ".damage")).withDescription("Sets this item damage.")).withRange(0.01, 100.0)).withDefault((Double)Double.valueOf(this.damage))).getSupplier();
        }

        @Override
        public T withJsonObject(JsonObject obj, boolean isClientSide) {
            JsonObject jsExplosion;
            this.withMaxShootingDistance(JsonUtil.getJsonDouble(obj, "maxShootingDistance", 200.0));
            this.withDamage(JsonUtil.getJsonFloat(obj, "damage", 5.0f));
            float headshotSoundVolume = JsonUtil.getJsonFloat(obj, "headshotSoundVolume", 3.0f);
            JsonElement headshotSoundElem = obj.get("headshotSound");
            if (headshotSoundElem != null && !headshotSoundElem.isJsonNull()) {
                String headshotSoundName = headshotSoundElem.getAsString();
                this.withHeadshotSound(() -> SoundRegistry.getSoundEvent(headshotSoundName), headshotSoundVolume);
            }
            if ((jsExplosion = obj.getAsJsonObject("explosion")) != null) {
                float power = JsonUtil.getJsonFloat(jsExplosion, "power", 1.0f);
                boolean fire = JsonUtil.getJsonBoolean(jsExplosion, "fire", false);
                String soundName = JsonUtil.getJsonString(jsExplosion, "sound", null);
                float soundVolume = JsonUtil.getJsonFloat(jsExplosion, "soundVolume", 4.0f);
                class_1937.class_7867 interaction = JsonUtil.getEnum(jsExplosion, "interaction", class_1937.class_7867.class, class_1937.class_7867.field_40889, true);
                ArrayList explosionEffects = new ArrayList();
                for (String effectName : JsonUtil.getStrings(jsExplosion, "effects")) {
                    Supplier<EffectBuilder> supplier = () -> EffectRegistry.getEffectBuilderSupplier(effectName).get();
                    explosionEffects.add(supplier);
                }
                this.withExplosion(power, fire, interaction, soundName, soundVolume, explosionEffects);
            }
            return this.cast(this);
        }

        @Override
        public boolean isEnabled() {
            return this.configOptionEnabled == null || this.configOptionEnabled.get() != false;
        }

        public float getDamage() {
            return this.damage;
        }
    }
}

