/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mod.pbj.Nameable;
import mod.pbj.entity.EntityBuilderProvider;
import mod.pbj.item.AmmoItem;
import mod.pbj.item.ArmorItem;
import mod.pbj.item.AttachmentItem;
import mod.pbj.item.GunItem;
import mod.pbj.item.MiscItem;
import mod.pbj.item.ThrowableItem;
import net.minecraft.class_1792;

public abstract class ItemBuilder<T extends ItemBuilder<T>>
implements Nameable {
    public static ItemBuilder<?> fromZipEntry(ZipFile zipFile, ZipEntry entry, boolean isClientSide) {
        ItemBuilder<?> itemBuilder;
        BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
        try {
            itemBuilder = ItemBuilder.fromReader(reader, isClientSide);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return itemBuilder;
    }

    public static ItemBuilder<?> fromPath(Path path, boolean isClientSide) {
        ItemBuilder<?> itemBuilder;
        block8: {
            BufferedReader br = Files.newBufferedReader(path);
            try {
                itemBuilder = ItemBuilder.fromReader(br, isClientSide);
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            br.close();
        }
        return itemBuilder;
    }

    public static ItemBuilder<?> fromReader(Reader reader, boolean isClientSide) {
        try {
            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String itemTypeStr = obj.has("type") ? obj.getAsJsonPrimitive("type").getAsString() : ItemType.GUN.toString();
            ItemType itemType = ItemType.valueOf(itemTypeStr.toUpperCase(Locale.ROOT));
            if (itemType == ItemType.GUN) {
                return new GunItem.Builder().withJsonObject(obj, isClientSide);
            }
            if (itemType == ItemType.AMMO) {
                return new AmmoItem.Builder().withJsonObject(obj, isClientSide);
            }
            if (itemType == ItemType.THROWABLE) {
                return new ThrowableItem.Builder().withJsonObject(obj, isClientSide);
            }
            if (itemType == ItemType.MISC) {
                return new MiscItem.MiscItemBuilder().withJsonObject(obj, isClientSide);
            }
            if (itemType == ItemType.ATTACHMENT) {
                return new AttachmentItem.Builder().withJsonObject(obj, isClientSide);
            }
            if (itemType == ItemType.ARMOR) {
                return new ArmorItem.Builder().withJsonObject(obj, isClientSide);
            }
            throw new IllegalArgumentException("Invalid item type: " + String.valueOf((Object)itemType));
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing JSON: " + e.getMessage(), e);
        }
    }

    public abstract T withJsonObject(JsonObject var1, boolean var2);

    public EntityBuilderProvider getEntityBuilderProvider() {
        return null;
    }

    public abstract class_1792 build();

    public static enum ItemType {
        GUN,
        AMMO,
        MISC,
        ATTACHMENT,
        THROWABLE,
        ARMOR;

    }
}

