/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import java.util.ArrayList;
import java.util.List;
import mod.pbj.NetworkService;
import mod.pbj.registry.ItemRegistry;
import mod.pbj.util.ClientUtil;
import mod.pbj.util.MiscUtil;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class ClientBoundPlayerDataSyncPacket {
    private class_2487 playerData;
    private List<Integer> enabledItems;

    public ClientBoundPlayerDataSyncPacket(class_2487 playerData, List<Integer> enabledItems) {
        this.playerData = playerData;
        this.enabledItems = enabledItems;
    }

    public ClientBoundPlayerDataSyncPacket() {
    }

    public static ClientBoundPlayerDataSyncPacket decode(class_2540 buf) {
        ClientBoundPlayerDataSyncPacket packet = new ClientBoundPlayerDataSyncPacket();
        packet.playerData = buf.method_10798();
        int itemCount = buf.readInt();
        packet.enabledItems = new ArrayList<Integer>();
        for (int i = 0; i < itemCount; ++i) {
            packet.enabledItems.add(buf.readInt());
        }
        return packet;
    }

    public static void encode(ClientBoundPlayerDataSyncPacket packet, class_2540 buf) {
        buf.method_10794((class_2520)packet.playerData);
        buf.method_53002(packet.enabledItems.size());
        for (int itemId : packet.enabledItems) {
            buf.method_53002(itemId);
        }
    }

    public static void handle(ClientBoundPlayerDataSyncPacket packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> {
            class_1657 player = ClientUtil.getClientPlayer();
            class_2487 serverSlotMapping = packet.playerData.method_10562("pointblank:attachmentSlotMapping");
            if (serverSlotMapping != null) {
                MiscUtil.getPersistentData(player).method_10566("pointblank:attachmentSlotMapping", (class_2520)serverSlotMapping);
            } else {
                MiscUtil.getPersistentData(player).method_10551(null);
            }
            ItemRegistry.ITEMS.syncEnabledItems(packet.enabledItems);
        });
        ctx.setPacketHandled(true);
    }

    public class_2487 getPlayerData() {
        return this.playerData;
    }
}

