/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import mod.pbj.NetworkService;
import mod.pbj.Platform;
import mod.pbj.block.entity.PrinterBlockEntity;
import mod.pbj.inventory.CraftingContainerMenu;
import mod.pbj.network.CraftingResponsePacket;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CraftingRequestPacket {
    private RequestType requestType;
    private class_2960 recipeId;

    public CraftingRequestPacket(RequestType requestType, class_2960 recipeId) {
        this.requestType = requestType;
        this.recipeId = recipeId;
    }

    public CraftingRequestPacket() {
    }

    public static void encode(CraftingRequestPacket packet, class_2540 buf) {
        buf.method_10817((Enum)packet.requestType);
        buf.method_10812(packet.recipeId);
    }

    public static CraftingRequestPacket decode(class_2540 buf) {
        return new CraftingRequestPacket((RequestType)buf.method_10818(RequestType.class), buf.method_10810());
    }

    public static void handle(CraftingRequestPacket packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> {
            class_3222 player = (class_3222)ctx.getSender();
            class_1703 patt0$temp = player.field_7512;
            if (patt0$temp instanceof CraftingContainerMenu) {
                CraftingContainerMenu containerMenu = (CraftingContainerMenu)patt0$temp;
                PrinterBlockEntity craftingBlockEntity = containerMenu.getWorkstationBlockEntity();
                if (packet.requestType == RequestType.START_CRAFTING) {
                    PrinterBlockEntity.CraftingEventHandler eventHandler = new PrinterBlockEntity.CraftingEventHandler(){

                        @Override
                        public void onCraftingCompleted(class_1657 player, class_1799 craftingItemStack, boolean isAddedToInventory) {
                            Platform.getInstance().getNetworkService().sendToClient(new CraftingResponsePacket(craftingItemStack, CraftingResponsePacket.CraftingResult.COMPLETED, isAddedToInventory), player);
                        }

                        @Override
                        public void onCraftingFailed(class_1657 player, class_1799 craftingItemStack, Exception craftingException) {
                            Platform.getInstance().getNetworkService().sendToClient(new CraftingResponsePacket(class_1799.field_8037, CraftingResponsePacket.CraftingResult.FAILED, false), player);
                        }
                    };
                    if (!craftingBlockEntity.tryCrafting((class_1657)player, packet.recipeId, eventHandler)) {
                        Platform.getInstance().getNetworkService().sendToClient(new CraftingResponsePacket(class_1799.field_8037, CraftingResponsePacket.CraftingResult.FAILED, false), (class_1657)player);
                    }
                } else if (packet.requestType == RequestType.CANCEL_CRAFTING) {
                    craftingBlockEntity.cancelCrafting((class_1657)player, packet.recipeId);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static enum RequestType {
        START_CRAFTING,
        CANCEL_CRAFTING;

    }
}

