/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import com.google.common.collect.Lists;
import java.util.List;
import mod.pbj.NetworkService;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.explosion.CustomExplosion;
import mod.pbj.util.ClientUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import net.minecraft.class_7923;

public class CustomClientBoundExplosionPacket {
    private class_1792 item;
    private double x;
    private double y;
    private double z;
    private float power;
    private List<class_2338> toBlow;
    private float knockbackX;
    private float knockbackY;
    private float knockbackZ;

    public CustomClientBoundExplosionPacket(class_1792 item, double posX, double posY, double posZ, float damage, List<class_2338> toBlow, class_243 knockback) {
        this.item = item;
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.power = damage;
        this.toBlow = Lists.newArrayList(toBlow);
        if (knockback != null) {
            this.knockbackX = (float)knockback.field_1352;
            this.knockbackY = (float)knockback.field_1351;
            this.knockbackZ = (float)knockback.field_1350;
        } else {
            this.knockbackX = 0.0f;
            this.knockbackY = 0.0f;
            this.knockbackZ = 0.0f;
        }
    }

    public CustomClientBoundExplosionPacket() {
    }

    public static CustomClientBoundExplosionPacket decode(class_2540 buf) {
        CustomClientBoundExplosionPacket packet = new CustomClientBoundExplosionPacket();
        class_1792 item = (class_1792)buf.method_52962(id -> (class_1792)class_7923.field_41178.method_10200(id));
        if (item != class_1802.field_8162) {
            packet.item = item;
        }
        packet.x = buf.readDouble();
        packet.y = buf.readDouble();
        packet.z = buf.readDouble();
        packet.power = buf.readFloat();
        int i = class_3532.method_15357((double)packet.x);
        int j = class_3532.method_15357((double)packet.y);
        int k = class_3532.method_15357((double)packet.z);
        packet.toBlow = buf.method_34066(p_178850_ -> {
            int l = p_178850_.readByte() + i;
            int i1 = p_178850_.readByte() + j;
            int j1 = p_178850_.readByte() + k;
            return new class_2338(l, i1, j1);
        });
        packet.knockbackX = buf.readFloat();
        packet.knockbackY = buf.readFloat();
        packet.knockbackZ = buf.readFloat();
        return packet;
    }

    public static void encode(CustomClientBoundExplosionPacket packet, class_2540 buf) {
        buf.method_52963(item -> class_7923.field_41178.method_10206(item), (Object)packet.item);
        buf.method_52940(packet.x);
        buf.method_52940(packet.y);
        buf.method_52940(packet.z);
        buf.method_52941(packet.power);
        int i = class_3532.method_15357((double)packet.x);
        int j = class_3532.method_15357((double)packet.y);
        int k = class_3532.method_15357((double)packet.z);
        buf.method_34062(packet.toBlow, (p_178855_, p_178856_) -> {
            int l = p_178856_.method_10263() - i;
            int i1 = p_178856_.method_10264() - j;
            int j1 = p_178856_.method_10260() - k;
            p_178855_.method_52997(l);
            p_178855_.method_52997(i1);
            p_178855_.method_52997(j1);
        });
        buf.method_52941(packet.knockbackX);
        buf.method_52941(packet.knockbackY);
        buf.method_52941(packet.knockbackZ);
    }

    public static void handle(CustomClientBoundExplosionPacket packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> ClientEventHandler.runSyncTick(() -> CustomClientBoundExplosionPacket.handleClient(packet, ctx)));
        ctx.setPacketHandled(true);
    }

    private static void handleClient(CustomClientBoundExplosionPacket packet, NetworkService.MessageContext ctx) {
        CustomExplosion explosion = new CustomExplosion(ClientUtil.getClientLevel(), packet.item, null, packet.x, packet.y, packet.z, packet.power, packet.toBlow);
        explosion.finalizeClientExplosion();
        class_1657 player = ClientUtil.getClientPlayer();
        player.method_18799(player.method_18798().method_1031((double)packet.knockbackX, (double)packet.knockbackY, (double)packet.knockbackZ));
    }

    public class_1792 getItem() {
        return this.item;
    }

    public float getKnockbackX() {
        return this.knockbackX;
    }

    public float getKnockbackY() {
        return this.knockbackY;
    }

    public float getKnockbackZ() {
        return this.knockbackZ;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPower() {
        return this.power;
    }

    public List<class_2338> getToBlow() {
        return this.toBlow;
    }
}

