/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import mod.pbj.Config;
import mod.pbj.NetworkService;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.GunClientState;
import mod.pbj.client.GunStatePoseProvider;
import mod.pbj.client.PoseProvider;
import mod.pbj.client.PositionProvider;
import mod.pbj.client.VertexConsumers;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.registry.EffectRegistry;
import mod.pbj.util.ClientUtil;
import mod.pbj.util.SimpleHitResult;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectBroadcastPacket {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    protected int playerEntityId;
    protected UUID gunStateId;
    protected UUID effectId;
    protected class_243 startPosition;
    protected SimpleHitResult hitResult;
    protected boolean hasMuzzlePositionProvider;

    public EffectBroadcastPacket() {
    }

    public EffectBroadcastPacket(int playerEntityId, UUID gunStateId, UUID effectId, class_243 startPosition, SimpleHitResult hitResult, boolean hasMuzzlePositionProvider) {
        this.playerEntityId = playerEntityId;
        this.gunStateId = gunStateId;
        this.effectId = effectId;
        this.startPosition = startPosition;
        this.hitResult = hitResult;
        this.hasMuzzlePositionProvider = hasMuzzlePositionProvider;
    }

    public static <T extends EffectBroadcastPacket> void encode(T packet, class_2540 buffer) {
        buffer.method_53002(packet.playerEntityId);
        buffer.method_52974(packet.gunStateId.getMostSignificantBits());
        buffer.method_52974(packet.gunStateId.getLeastSignificantBits());
        buffer.method_52974(packet.effectId.getMostSignificantBits());
        buffer.method_52974(packet.effectId.getLeastSignificantBits());
        buffer.method_52940(packet.startPosition.field_1352);
        buffer.method_52940(packet.startPosition.field_1351);
        buffer.method_52940(packet.startPosition.field_1350);
        buffer.method_37435(Optional.ofNullable(packet.hitResult), SimpleHitResult.STREAM_CODEC);
        buffer.method_52964(packet.hasMuzzlePositionProvider);
        packet.doEncode(buffer);
    }

    protected void doEncode(class_2540 buffer) {
    }

    protected static EffectBroadcastPacket decode(class_2540 buffer) {
        int playerEntityId = buffer.readInt();
        UUID gunStateId = new UUID(buffer.readLong(), buffer.readLong());
        UUID effectId = new UUID(buffer.readLong(), buffer.readLong());
        class_243 startPosition = new class_243(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        SimpleHitResult hitResult = buffer.method_37436(SimpleHitResult.STREAM_CODEC).orElse(null);
        boolean hasMuzzlePositionProvider = buffer.readBoolean();
        return new EffectBroadcastPacket(playerEntityId, gunStateId, effectId, startPosition, hitResult, hasMuzzlePositionProvider);
    }

    public static <T extends EffectBroadcastPacket> void handle(T packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> ClientEventHandler.runSyncTick(() -> {
            if (Config.particleEffectsEnabled) {
                EffectBroadcastPacket.launchEffect(packet);
            }
        }));
        ctx.setPacketHandled(true);
    }

    private static <T extends EffectBroadcastPacket> void launchEffect(T packet) {
        class_310 mc = class_310.method_1551();
        class_1657 clientPlayer = ClientUtil.getClientPlayer();
        class_1297 effectOwnerEntity = mc.field_1687.method_8469(packet.playerEntityId);
        if (effectOwnerEntity instanceof class_1657) {
            Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>> effectBuilderSupplier;
            class_1657 effectOwnerPlayer = (class_1657)effectOwnerEntity;
            if (effectOwnerPlayer == clientPlayer) {
                // empty if block
            }
            if ((effectBuilderSupplier = EffectRegistry.getEffectBuilderSupplier(packet.effectId)) != null) {
                EffectBuilder<EffectBuilder<?, ?>, ?> effectBuilder = effectBuilderSupplier.get();
                SimpleHitResult hitResult = packet.hitResult;
                double distanceToTarget = hitResult != null ? hitResult.method_17784().method_1022(packet.startPosition) : 400.0;
                GunClientState gunState = GunClientState.getState(packet.gunStateId);
                PositionProvider positionProvider = null;
                PoseProvider poseProvider = null;
                if (packet.hasMuzzlePositionProvider && gunState != null) {
                    positionProvider = () -> GunStatePoseProvider.getInstance().getPositionAndDirection(gunState, GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE);
                    poseProvider = () -> GunStatePoseProvider.getInstance().getPose(gunState, GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE);
                }
                EffectBuilder.Context effectBuilderContext = new EffectBuilder.Context().withGunState(gunState).withStartPosition(packet.startPosition).withDistance((float)distanceToTarget).withRandomization(0.0f).withVertexConsumerTransformer(VertexConsumers.PARTICLE).withPositionProvider(positionProvider).withPoseProvider(poseProvider).withHitResult(packet.hitResult);
                Object effect = effectBuilder.build(effectBuilderContext);
                LOGGER.debug("Launching effect {}", effect);
                effect.launch((class_1297)effectOwnerPlayer);
            }
        }
    }
}

