/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import java.util.UUID;
import mod.pbj.NetworkService;
import mod.pbj.item.FireModeInstance;
import mod.pbj.item.GunItem;
import mod.pbj.network.GunStateRequestPacket;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class HitScanFireRequestPacket
extends GunStateRequestPacket {
    private FireModeInstance fireModeInstance;
    private boolean isAiming;
    private long seed;

    public HitScanFireRequestPacket() {
    }

    public HitScanFireRequestPacket(FireModeInstance fireModeInstance, UUID stateId, int slotIndex, boolean isAiming, long seed) {
        super(stateId, slotIndex);
        this.fireModeInstance = fireModeInstance;
        this.isAiming = isAiming;
        this.seed = seed;
    }

    public static HitScanFireRequestPacket decode(class_2540 buffer) {
        GunStateRequestPacket header = GunStateRequestPacket.decodeHeader(buffer);
        FireModeInstance fireModeInstance = FireModeInstance.readFromBuf(buffer);
        boolean isAiming = buffer.readBoolean();
        long seed = buffer.readLong();
        return new HitScanFireRequestPacket(fireModeInstance, header.stateId, header.slotIndex, isAiming, seed);
    }

    @Override
    protected void doEncode(class_2540 buffer) {
        this.fireModeInstance.writeToBuf(buffer);
        buffer.method_52964(this.isAiming);
        buffer.method_52974(this.seed);
    }

    @Override
    protected <T extends GunStateRequestPacket> void handleEnqueued(NetworkService.MessageContext ctx) {
        class_3222 player = (class_3222)ctx.getSender();
        if (player != null) {
            class_1799 itemStack = player.method_31548().method_5438(this.slotIndex);
            if (itemStack != null && itemStack.method_7909() instanceof GunItem) {
                ((GunItem)itemStack.method_7909()).handleClientHitScanFireRequest(player, this.fireModeInstance, this.stateId, this.slotIndex, this.correlationId, this.isAiming, this.seed);
            } else {
                System.err.println("Mismatching item in slot " + this.slotIndex);
            }
        }
    }
}

