/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mod.pbj.NetworkService;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.GunClientState;
import mod.pbj.item.GunItem;
import mod.pbj.network.GunStateResponsePacket;
import mod.pbj.util.ClientUtil;
import mod.pbj.util.InventoryUtils;
import mod.pbj.util.SimpleHitResult;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3545;

public class HitScanFireResponsePacket
extends GunStateResponsePacket {
    private SimpleHitResult hitResult;
    private int ownerEntityId;
    private float damage;

    public HitScanFireResponsePacket() {
    }

    public HitScanFireResponsePacket(int ownerEntityId, UUID stateId, int slotIndex, int correlationId, SimpleHitResult hitResult, float damage) {
        super(stateId, slotIndex, correlationId, true);
        this.ownerEntityId = ownerEntityId;
        this.hitResult = hitResult;
        this.damage = damage;
    }

    @Override
    protected void doEncode(class_2540 buffer) {
        buffer.method_53002(this.ownerEntityId);
        class_2540.method_56892((ByteBuf)buffer, (Object)((Object)this.hitResult), SimpleHitResult.STREAM_CODEC);
        buffer.method_52941(this.damage);
    }

    public static HitScanFireResponsePacket decode(class_2540 buffer) {
        GunStateResponsePacket header = GunStateResponsePacket.decodeHeader(buffer);
        int ownerEntityId = buffer.readInt();
        SimpleHitResult hitResult = (SimpleHitResult)((Object)class_2540.method_56893((ByteBuf)buffer, SimpleHitResult.STREAM_CODEC));
        float damage = buffer.readFloat();
        return new HitScanFireResponsePacket(ownerEntityId, header.stateId, header.slotIndex, header.correlationId, hitResult, damage);
    }

    public static void handle(HitScanFireResponsePacket packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> ClientEventHandler.runSyncTick(() -> {
            class_1657 player;
            class_3545<class_1799, GunClientState> targetTuple;
            class_1937 level = ClientUtil.getClientLevel();
            class_1297 entity = level.method_8469(packet.ownerEntityId);
            if (entity instanceof class_1657 && (targetTuple = packet.getItemStackAndState(packet, (class_1297)(player = (class_1657)entity))) != null) {
                packet.handleEnqueued(player, (class_1799)targetTuple.method_15442(), (GunClientState)targetTuple.method_15441());
            }
        }));
        ctx.setPacketHandled(true);
    }

    @Override
    protected <T extends GunStateResponsePacket> class_3545<class_1799, GunClientState> getItemStackAndState(T packet, class_1297 entity) {
        class_1657 clientPlayer = ClientUtil.getClientPlayer();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return InventoryUtils.getItemStackByStateId(player, packet.stateId, clientPlayer == player ? packet.slotIndex : 0);
        }
        return null;
    }

    protected <T extends GunStateResponsePacket> void handleEnqueued(class_1657 player, class_1799 itemStack, GunClientState gunClientState) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof GunItem) {
            GunItem gunItem = (GunItem)class_17922;
            gunItem.processServerHitScanFireResponse(player, this.stateId, itemStack, gunClientState, this.hitResult, this.damage);
        }
    }
}

