/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import java.util.UUID;
import mod.pbj.NetworkService;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.GunClientState;
import mod.pbj.util.ClientUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;

public class MainHeldSimplifiedStateBroadcastPacket {
    protected class_1657 owner;
    protected GunClientState.FireState simplifiedState;

    public MainHeldSimplifiedStateBroadcastPacket() {
    }

    public MainHeldSimplifiedStateBroadcastPacket(class_1657 owner, UUID stateId, GunClientState.FireState simplifiedState) {
        this.owner = owner;
        this.simplifiedState = simplifiedState;
    }

    public static <T extends MainHeldSimplifiedStateBroadcastPacket> void encode(T packet, class_2540 buffer) {
        buffer.method_53002(packet.owner.method_5628());
        buffer.method_53002(packet.simplifiedState.ordinal());
    }

    public static MainHeldSimplifiedStateBroadcastPacket decode(class_2540 buffer) {
        class_1297 effectOwnerEntity = ClientUtil.getClientLevel().method_8469(buffer.readInt());
        GunClientState.FireState fireState = GunClientState.FireState.values()[buffer.readInt()];
        return new MainHeldSimplifiedStateBroadcastPacket((class_1657)effectOwnerEntity, null, fireState);
    }

    public static <T extends MainHeldSimplifiedStateBroadcastPacket> void handle(T packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> ClientEventHandler.runSyncTick(() -> {
            if (packet.owner == ClientUtil.getClientPlayer()) {
                return;
            }
            GunClientState otherPlayerClientState = GunClientState.getMainHeldState(packet.owner);
            if (otherPlayerClientState != null) {
                otherPlayerClientState.setSimplifiedState(packet.simplifiedState);
            }
        }));
        ctx.setPacketHandled(true);
    }
}

