/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import mod.pbj.NetworkService;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.Attachments;
import mod.pbj.feature.Feature;
import mod.pbj.registry.FeatureTypeRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class ServerBoundNextAttachmentPacket {
    private AttachmentCategory category;
    private Class<? extends Feature> featureType;

    public ServerBoundNextAttachmentPacket(AttachmentCategory category, Class<? extends Feature> featureType) {
        this.category = category;
        this.featureType = featureType;
    }

    public ServerBoundNextAttachmentPacket() {
    }

    public static void encode(ServerBoundNextAttachmentPacket packet, class_2540 buf) {
        buf.method_53002(packet.category.ordinal());
        buf.method_53002(FeatureTypeRegistry.getFeatureTypeId(packet.featureType));
    }

    public static ServerBoundNextAttachmentPacket decode(class_2540 buf) {
        return new ServerBoundNextAttachmentPacket(AttachmentCategory.fromOrdinal(buf.readInt()), FeatureTypeRegistry.getFeatureType(buf.readInt()));
    }

    public static void handle(ServerBoundNextAttachmentPacket packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> {
            class_3222 player = (class_3222)ctx.getSender();
            class_1799 mainHeldItem = player.method_6047();
            if (mainHeldItem != null) {
                Attachments.selectNextAttachment(mainHeldItem, packet.category, packet.featureType);
            }
        });
        ctx.setPacketHandled(true);
    }
}

