/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.platform.fabric;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mod.pbj.event.CustomEvent;
import mod.pbj.event.EventBus;
import mod.pbj.event.EventListener;
import mod.pbj.event.EventRegistrationUtil;
import net.fabricmc.fabric.api.event.Event;

public class FabricEventBus
implements EventBus {
    private final Map<Class<?>, List<EventListener>> listeners = new HashMap();
    private final EventRegistrationUtil eventRegistrationUtil = new EventRegistrationUtil(this);
    private final Map<Class<? extends CustomEvent>, List<Event<?>>> commonToFabricEventTypeMapper;
    private final Map<Event<?>, Function<EventListener, Object>> fabricEventToListenerFactoryMap;

    public FabricEventBus(Map<Class<? extends CustomEvent>, List<Event<?>>> commonToFabricEventTypeMapper, Map<Event<?>, Function<EventListener, Object>> fabricEventToListenerFactoryMap) {
        this.commonToFabricEventTypeMapper = new HashMap(commonToFabricEventTypeMapper);
        this.fabricEventToListenerFactoryMap = new HashMap(fabricEventToListenerFactoryMap);
    }

    public void addCommonToFabricEventTypeMapping(Class<? extends CustomEvent> customEventClass, List<Event<?>> fabricEvents) {
        this.commonToFabricEventTypeMapper.put(customEventClass, fabricEvents);
    }

    public void addFabricEventToListenerFactoryMapping(Event<?> fabricEvent, Function<EventListener, Object> listenerFactory) {
        this.fabricEventToListenerFactoryMap.put(fabricEvent, listenerFactory);
    }

    private <T> T createListener(Event<T> event, EventListener commonEventListener) {
        Function<EventListener, Object> factory = this.fabricEventToListenerFactoryMap.get(event);
        if (factory != null) {
            return (T)factory.apply(commonEventListener);
        }
        return null;
    }

    @Override
    public <T extends CustomEvent> void addListener(Class<T> eventType, EventListener listener) {
        List eventTypeListeners = this.listeners.computeIfAbsent(eventType, et -> new ArrayList());
        eventTypeListeners.add(listener);
        List<Event<?>> fabricEventTypes = this.toFabricEventTypes(eventType);
        if (fabricEventTypes != null) {
            for (Event<?> fabricEventType : fabricEventTypes) {
                this.register(fabricEventType, listener);
            }
        }
    }

    private <T> void register(Event<T> event, EventListener commonEventListener) {
        event.register(this.createListener(event, commonEventListener));
    }

    @Override
    public <T extends CustomEvent> void removeListener(Class<T> eventType, EventListener listener) {
        List eventTypeListeners = this.listeners.computeIfAbsent(eventType, et -> new ArrayList());
        eventTypeListeners.remove(listener);
    }

    private List<Event<?>> toFabricEventTypes(Class<? extends CustomEvent> eventType) {
        return this.commonToFabricEventTypeMapper.get(eventType);
    }

    @Override
    public void postEvent(CustomEvent event) {
        List<EventListener> eventTypeListeners = this.listeners.get(event.getClass());
        if (eventTypeListeners == null) {
            return;
        }
        for (EventListener listener : eventTypeListeners) {
            listener.handleEvent(event);
        }
    }

    @Override
    public void register(Object instance) {
        this.eventRegistrationUtil.register(instance);
    }

    @Override
    public void unregister(Object instance) {
        throw new UnsupportedOperationException();
    }

    @FunctionalInterface
    public static interface EventListenerFactory {
        public <T> T createListener(Event<T> var1, EventListener var2);
    }
}

