/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.platform.fabric;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.pbj.NetworkService;
import mod.pbj.platform.fabric.FabricPayload;
import mod.pbj.util.MiscUtil;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class FabricNetworkService
implements NetworkService {
    private final LinkedHashMap<Class<?>, PacketInfo<?>> packetRegistrations = new LinkedHashMap();

    @Override
    public <M, B extends class_2540> void registerPacket(Class<M> packetClass, NetworkService.Direction direction, BiConsumer<M, class_9129> encoder, Function<class_9129, M> decoder, BiConsumer<M, NetworkService.MessageContext> handler) {
        class_9139 mCodec = class_9139.method_56438(encoder::accept, decoder::apply);
        class_9139 codec = class_9139.method_56434((class_9139)mCodec, FabricPayload::getData, FabricPayload::new);
        class_8710.class_9154 type = new class_8710.class_9154(class_2960.method_60655((String)"pointblank", (String)packetClass.getSimpleName().toLowerCase()));
        this.packetRegistrations.put(packetClass, new PacketInfo(direction, codec, type, (p, c) -> handler.accept(p.getData(), (NetworkService.MessageContext)c)));
    }

    @Override
    public void onRegisteringPacketsCompleted() {
        for (Map.Entry<Class<?>, PacketInfo<?>> entry : this.packetRegistrations.entrySet()) {
            PacketInfo<?> packetInfo = entry.getValue();
            this.registerPacket(packetInfo);
        }
    }

    @Override
    public void onRegisteringClientPacketsCompleted() {
        for (Map.Entry<Class<?>, PacketInfo<?>> entry : this.packetRegistrations.entrySet()) {
            PacketInfo<?> packetInfo = entry.getValue();
            this.registerClientPacketReceiver(packetInfo);
        }
    }

    private <T> void registerPacket(PacketInfo<T> packetInfo) {
        if (packetInfo.direction == NetworkService.Direction.CLIENT_TO_SERVER) {
            PayloadTypeRegistry.playC2S().register(packetInfo.type, packetInfo.codec);
            ServerPlayNetworking.registerGlobalReceiver(packetInfo.type, (p, c) -> packetInfo.handler.accept((FabricPayload<FabricPayload>)p, new FabricC2SMessageContext(c)));
        } else if (packetInfo.direction == NetworkService.Direction.SERVER_TO_CLIENT) {
            PayloadTypeRegistry.playS2C().register(packetInfo.type, packetInfo.codec);
        }
    }

    private <T> void registerClientPacketReceiver(PacketInfo<T> packetInfo) {
        if (packetInfo.direction == NetworkService.Direction.SERVER_TO_CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver(packetInfo.type, (p, c) -> packetInfo.handler.accept((FabricPayload<FabricPayload>)p, new FabricS2CMessageContext(c)));
        }
    }

    @Override
    public void sendToClient(Object message, class_1657 toPlayer) {
        ServerPlayNetworking.send((class_3222)((class_3222)toPlayer), new FabricPayload<Object>(message));
    }

    @Override
    public void sendToServer(Object message) {
        ClientPlayNetworking.send(new FabricPayload<Object>(message));
    }

    @Override
    public class_8710 createCustomPayload(Object packet) {
        return new FabricPayload<Object>(packet);
    }

    private record PacketInfo<T>(NetworkService.Direction direction, class_9139<? super class_9129, FabricPayload<T>> codec, class_8710.class_9154<FabricPayload<T>> type, BiConsumer<FabricPayload<T>, NetworkService.MessageContext> handler) {
    }

    static class FabricS2CMessageContext
    implements NetworkService.MessageContext {
        private final ClientPlayNetworking.Context delegate;

        FabricS2CMessageContext(ClientPlayNetworking.Context delegate) {
            this.delegate = delegate;
        }

        @Override
        public void enqueueWork(Runnable runnable) {
            class_310 client = this.delegate.client();
            client.execute(runnable);
        }

        @Override
        public void setPacketHandled(boolean isPacketHandled) {
        }

        @Override
        public class_1657 getSender() {
            return this.delegate.player();
        }

        @Override
        public boolean isClientSide() {
            return MiscUtil.isClientSide((class_1297)this.delegate.player());
        }
    }

    static class FabricC2SMessageContext
    implements NetworkService.MessageContext {
        private final ServerPlayNetworking.Context delegate;

        FabricC2SMessageContext(ServerPlayNetworking.Context delegate) {
            this.delegate = delegate;
        }

        @Override
        public void enqueueWork(Runnable runnable) {
            this.delegate.player().method_5682().execute(runnable);
        }

        @Override
        public void setPacketHandled(boolean isPacketHandled) {
        }

        @Override
        public class_1657 getSender() {
            return this.delegate.player();
        }

        @Override
        public boolean isClientSide() {
            return MiscUtil.isClientSide((class_1297)this.delegate.player());
        }
    }
}

