/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.platform.fabric;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mod.pbj.NetworkService;
import mod.pbj.Platform;
import mod.pbj.RegistryService;
import mod.pbj.event.CustomEvent;
import mod.pbj.event.EventBus;
import mod.pbj.event.EventListener;
import mod.pbj.event.InputEvent;
import mod.pbj.event.ModConfigEvent;
import mod.pbj.event.PlayerEvent;
import mod.pbj.event.ServerAboutToStartEvent;
import mod.pbj.event.ServerStartedEvent;
import mod.pbj.event.VillagerTradesEvent;
import mod.pbj.platform.fabric.ContextualBlockModelBakerImpl;
import mod.pbj.platform.fabric.ExtensionPackResources;
import mod.pbj.platform.fabric.FabricConfig;
import mod.pbj.platform.fabric.FabricEventBus;
import mod.pbj.platform.fabric.FabricNetworkService;
import mod.pbj.platform.fabric.FabricRegistryService;
import mod.pbj.platform.fabric.PersistentDataSupport;
import mod.pbj.util.JarFileSystem;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.ModInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_1087;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_3414;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_809;
import net.minecraft.class_811;
import net.minecraft.class_9224;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;

public class FabricPlatform
implements Platform {
    public static final ThreadLocal<Boolean> isClientThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final Map<Class<? extends CustomEvent>, List<Event<?>>> CUSTOM_EVENT_TO_FABRIC_EVENT_MAP = new HashMap();
    private static final Map<Event<?>, Function<EventListener, Object>> FABRIC_EVENT_TO_LISTENER_FACTORY_MAP;
    private static final Map<class_3852, Int2ObjectMap<class_3853.class_1652[]>> VANILLA_TRADES;
    private final FabricRegistryService<class_2591<?>> forgeBlockEntityTypeRegistryservice = new FabricRegistryService(class_7923.field_41181);
    private final FabricRegistryService<class_2248> blockRegistryService = new FabricRegistryService(class_7923.field_41175);
    private final FabricRegistryService<class_3956<?>> recipeTypeRegistryService = new FabricRegistryService(class_7923.field_41188);
    private final FabricRegistryService<class_1865<?>> recipeSerializerService = new FabricRegistryService(class_7923.field_41189);
    private final FabricRegistryService<class_1299<?>> entityTypeRegistryService = new FabricRegistryService(class_7923.field_41177);
    private final FabricRegistryService<class_9331<?>> dataComponentTypeRegistry = new FabricRegistryService(class_7923.field_49658);
    private final FabricRegistryService<class_3917<?>> menuTypeRegistry = new FabricRegistryService(class_7923.field_41187);
    private final FabricRegistryService<class_3414> soundRegistry = new FabricRegistryService(class_7923.field_41172);
    private final FabricRegistryService<class_2396<?>> particleTypeRegistry = new FabricRegistryService(class_7923.field_41180);
    private final FabricRegistryService<class_1792> itemRegistry = new FabricRegistryService(class_7923.field_41178);
    private final FabricRegistryService<class_1761> creativeModeTabRegistry = new FabricRegistryService(class_7923.field_44687);
    private final FabricRegistryService<class_3852> villagerProfessionRegistry = new FabricRegistryService(class_7923.field_41195);
    private final FabricRegistryService<class_4158> poiTypeRegistry = new FabricRegistryService<class_4158>(this, class_7923.field_41128){

        @Override
        protected void onRegisteringDeferred(String name, class_4158 registered) {
            class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_41212, (class_2960)class_2960.method_60655((String)"pointblank", (String)name));
            class_7477.method_43990((class_6880)class_7923.field_41128.method_40290(resourceKey), (Set)registered.comp_815());
        }
    };
    private final FabricNetworkService networkService = new FabricNetworkService();
    private final FabricEventBus eventBus = new FabricEventBus(CUSTOM_EVENT_TO_FABRIC_EVENT_MAP, FABRIC_EVENT_TO_LISTENER_FACTORY_MAP);
    private final FabricEventBus bootstrapEventBus = new FabricEventBus(new HashMap(), new HashMap());

    private static void handleVillagerTrades(EventListener commonEventListener, MinecraftServer server) {
        for (class_3852 prof : class_7923.field_41195) {
            Int2ObjectMap<class_3853.class_1652[]> trades = VANILLA_TRADES.getOrDefault(prof, (Int2ObjectMap<class_3853.class_1652[]>)new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap mutableTrades = new Int2ObjectOpenHashMap();
            for (int i = 1; i < 6; ++i) {
                mutableTrades.put(i, new ArrayList());
            }
            trades.int2ObjectEntrySet().forEach(arg_0 -> FabricPlatform.lambda$handleVillagerTrades$16((Int2ObjectMap)mutableTrades, arg_0));
            VillagerTradesEvent villagerTradesEvent = new VillagerTradesEvent((Int2ObjectMap<List<class_3853.class_1652>>)mutableTrades, prof);
            Platform.getInstance().getEventBus().postEvent(villagerTradesEvent);
            Int2ObjectOpenHashMap newTrades = new Int2ObjectOpenHashMap();
            mutableTrades.int2ObjectEntrySet().forEach(arg_0 -> FabricPlatform.lambda$handleVillagerTrades$17((Int2ObjectMap)newTrades, arg_0));
            class_3853.field_17067.put(prof, newTrades);
        }
    }

    @Override
    public void registerConfig() {
        FabricConfig config = new FabricConfig();
        config.onLoad(new ModConfigEvent());
    }

    @Override
    public boolean isClientSide() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public EventBus getBootstrapEventBus() {
        return this.bootstrapEventBus;
    }

    @Override
    public Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public class_3262 createDelegatingPackResources(class_9224 info, class_3272 packMeta, List<? extends class_3262> packs) {
        return new ExtensionPackResources(info, packMeta, packs);
    }

    @Override
    public class_3288.class_7680 createPackResourceSupplier(class_3262 packResources) {
        return ((ExtensionPackResources)packResources).supplier();
    }

    @Override
    public NetworkService getNetworkService() {
        return this.networkService;
    }

    @Override
    public void onRegistrationCompleted() {
        this.forgeBlockEntityTypeRegistryservice.registerDeferred();
        this.blockRegistryService.registerDeferred();
        this.recipeTypeRegistryService.registerDeferred();
        this.recipeSerializerService.registerDeferred();
        this.entityTypeRegistryService.registerDeferred();
        this.dataComponentTypeRegistry.registerDeferred();
        this.menuTypeRegistry.registerDeferred();
        this.soundRegistry.registerDeferred();
        this.particleTypeRegistry.registerDeferred();
        this.itemRegistry.registerDeferred();
        this.creativeModeTabRegistry.registerDeferred();
        this.villagerProfessionRegistry.registerDeferred();
        this.poiTypeRegistry.registerDeferred();
    }

    @Override
    public RegistryService<class_2591<?>> getBlockEntityTypeRegistry() {
        return this.forgeBlockEntityTypeRegistryservice;
    }

    @Override
    public RegistryService<class_2248> getBlockRegistryService() {
        return this.blockRegistryService;
    }

    @Override
    public RegistryService<class_3956<?>> getRecipeTypeRegistryService() {
        return this.recipeTypeRegistryService;
    }

    @Override
    public RegistryService<class_1865<?>> getRecipeSerializerService() {
        return this.recipeSerializerService;
    }

    @Override
    public RegistryService<class_1299<?>> getEntityTypeRegistryService() {
        return this.entityTypeRegistryService;
    }

    @Override
    public RegistryService<class_9331<?>> getDataComponentTypeRegistry() {
        return this.dataComponentTypeRegistry;
    }

    @Override
    public RegistryService<class_3917<?>> getMenuTypeRegistry() {
        return this.menuTypeRegistry;
    }

    @Override
    public RegistryService<class_3414> getSoundRegistry() {
        return this.soundRegistry;
    }

    @Override
    public RegistryService<class_2396<?>> getParticleTypeRegistry() {
        return this.particleTypeRegistry;
    }

    @Override
    public RegistryService<class_1792> getItemRegistry() {
        return this.itemRegistry;
    }

    @Override
    public RegistryService<class_1761> getCreativeModeTabRegistry() {
        return this.creativeModeTabRegistry;
    }

    @Override
    public RegistryService<class_3852> getVillagerProfessionRegistry() {
        return this.villagerProfessionRegistry;
    }

    @Override
    public RegistryService<class_4158> getPoiTypeRegistry() {
        return this.poiTypeRegistry;
    }

    @Override
    public boolean isClientThread() {
        return "pointblank:state_ticker_thread".equals(Thread.currentThread().getName()) || isClientThread.get() != false;
    }

    @Override
    public ModInfo getModInfo(String modId) {
        ModContainer modContainer = FabricLoader.getInstance().getModContainer(modId).orElse(null);
        if (modContainer == null) {
            return null;
        }
        Version version = modContainer.getMetadata().getVersion();
        return new ModInfo(modId, version.getFriendlyString());
    }

    @Override
    public JarFileSystem getJarFileSystem(Path ... segments) {
        Path rootPath = segments[0];
        for (int i = 1; i < segments.length; ++i) {
            rootPath = rootPath.resolve(segments[i]);
        }
        if (rootPath.toString().endsWith(".zip") || rootPath.toString().endsWith(".jar")) {
            try {
                FileSystem zipfs = FileSystems.newFileSystem(rootPath);
                rootPath = zipfs.getPath("/", new String[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Path rootPathFinal = rootPath;
        return (first, rest) -> {
            Path rel = rootPathFinal.getFileSystem().getPath(first, rest);
            return rootPathFinal.resolve(rel);
        };
    }

    @Override
    public class_2487 getPersistentData(class_1657 player) {
        return ((PersistentDataSupport)player).getPointBlankPersistentData();
    }

    @Override
    public class_2960 parseRecipeResourceLocation(String location) {
        class_2960 resourceLocation = class_2960.method_60654((String)location);
        if (resourceLocation.method_12836().equals("forge")) {
            String path = resourceLocation.method_12832();
            resourceLocation = class_2960.method_60655((String)"c", (String)path);
        }
        return resourceLocation;
    }

    @Override
    public Function<class_811, class_809> getItemTransforms(class_1657 player, class_1799 itemStack) {
        return itemDisplayContext -> {
            class_310 minecraft = class_310.method_1551();
            class_1087 bakedModel = minecraft.method_1480().method_4019(itemStack, MiscUtil.getLevel((class_1297)player), (class_1309)player, player.method_5628() + itemDisplayContext.ordinal());
            if (bakedModel instanceof ContextualBlockModelBakerImpl.Baked) {
                ContextualBlockModelBakerImpl.Baked separateTransformsModel = (ContextualBlockModelBakerImpl.Baked)bakedModel;
                class_1087 baseModel = separateTransformsModel.getBaseModel();
                return baseModel.method_4709();
            }
            return bakedModel.method_4709();
        };
    }

    @Override
    public class_1297 getParentEntity(class_1297 entity) {
        return null;
    }

    private static /* synthetic */ void lambda$handleVillagerTrades$17(Int2ObjectMap newTrades, Int2ObjectMap.Entry e) {
        newTrades.put(e.getIntKey(), (Object)((List)e.getValue()).toArray(new class_3853.class_1652[0]));
    }

    private static /* synthetic */ void lambda$handleVillagerTrades$16(Int2ObjectMap mutableTrades, Int2ObjectMap.Entry e) {
        Arrays.stream((class_3853.class_1652[])e.getValue()).forEach(((List)mutableTrades.get(e.getIntKey()))::add);
    }

    private static /* synthetic */ void lambda$static$14(Int2ObjectMap copy, Int2ObjectMap.Entry ent) {
        copy.put(ent.getIntKey(), (Object)Arrays.copyOf((class_3853.class_1652[])ent.getValue(), ((class_3853.class_1652[])ent.getValue()).length));
    }

    static {
        CUSTOM_EVENT_TO_FABRIC_EVENT_MAP.put(InputEvent.InteractionKeyMappingTriggered.class, List.of(UseEntityCallback.EVENT, UseItemCallback.EVENT, AttackBlockCallback.EVENT, AttackEntityCallback.EVENT));
        CUSTOM_EVENT_TO_FABRIC_EVENT_MAP.put(ServerAboutToStartEvent.class, List.of(ServerLifecycleEvents.SERVER_STARTING));
        CUSTOM_EVENT_TO_FABRIC_EVENT_MAP.put(ServerStartedEvent.class, List.of(ServerLifecycleEvents.SERVER_STARTED));
        CUSTOM_EVENT_TO_FABRIC_EVENT_MAP.put(PlayerEvent.HarvestCheck.class, List.of(PlayerBlockBreakEvents.BEFORE));
        FABRIC_EVENT_TO_LISTENER_FACTORY_MAP = new HashMap();
        FABRIC_EVENT_TO_LISTENER_FACTORY_MAP.put(UseEntityCallback.EVENT, commonEventListener -> (player, world, hand, entity, hitResult) -> {
            InputEvent.InteractionKeyMappingTriggered inputEvent = new InputEvent.InteractionKeyMappingTriggered(player);
            commonEventListener.handleEvent(inputEvent);
            return inputEvent.isCanceled() ? class_1269.field_21466 : class_1269.field_5811;
        });
        FABRIC_EVENT_TO_LISTENER_FACTORY_MAP.put(UseItemCallback.EVENT, commonEventListener -> (player, world, hand) -> {
            InputEvent.InteractionKeyMappingTriggered inputEvent = new InputEvent.InteractionKeyMappingTriggered(player);
            commonEventListener.handleEvent(inputEvent);
            return inputEvent.isCanceled() ? class_1271.method_22428((Object)class_1799.field_8037) : class_1271.method_22430((Object)class_1799.field_8037);
        });
        FABRIC_EVENT_TO_LISTENER_FACTORY_MAP.put(AttackBlockCallback.EVENT, commonEventListener -> (player, world, hand, pos, direction) -> {
            InputEvent.InteractionKeyMappingTriggered inputEvent = new InputEvent.InteractionKeyMappingTriggered(player);
            commonEventListener.handleEvent(inputEvent);
            return inputEvent.isCanceled() ? class_1269.field_5814 : class_1269.field_5811;
        });
        FABRIC_EVENT_TO_LISTENER_FACTORY_MAP.put(AttackEntityCallback.EVENT, commonEventListener -> (player, world, hand, entity, hitResult) -> {
            InputEvent.InteractionKeyMappingTriggered inputEvent = new InputEvent.InteractionKeyMappingTriggered(player);
            commonEventListener.handleEvent(inputEvent);
            return inputEvent.isCanceled() ? class_1269.field_21466 : class_1269.field_5811;
        });
        FABRIC_EVENT_TO_LISTENER_FACTORY_MAP.put(ServerLifecycleEvents.SERVER_STARTING, commonEventListener -> server -> {
            ServerAboutToStartEvent event1 = new ServerAboutToStartEvent(server);
            commonEventListener.handleEvent(event1);
            FabricPlatform.handleVillagerTrades(commonEventListener, server);
        });
        FABRIC_EVENT_TO_LISTENER_FACTORY_MAP.put(ServerLifecycleEvents.SERVER_STARTED, commonEventListener -> server -> {
            ServerStartedEvent event1 = new ServerStartedEvent(server);
            commonEventListener.handleEvent(event1);
        });
        FABRIC_EVENT_TO_LISTENER_FACTORY_MAP.put(PlayerBlockBreakEvents.BEFORE, commonEventListener -> (world, player, pos, state, blockEntity) -> {
            PlayerEvent.HarvestCheck event1 = new PlayerEvent.HarvestCheck(player, state, true);
            commonEventListener.handleEvent(event1);
            return event1.canHarvest();
        });
        VANILLA_TRADES = new HashMap<class_3852, Int2ObjectMap<class_3853.class_1652[]>>();
        class_3853.field_17067.forEach((key, value) -> {
            Int2ObjectOpenHashMap copy = new Int2ObjectOpenHashMap();
            value.int2ObjectEntrySet().forEach(arg_0 -> FabricPlatform.lambda$static$14((Int2ObjectMap)copy, arg_0));
            VANILLA_TRADES.put((class_3852)key, (Int2ObjectMap<class_3853.class_1652[]>)copy);
        });
    }
}

