/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import mod.pbj.Platform;
import mod.pbj.RegistryService;
import mod.pbj.entity.EntityBuilder;
import mod.pbj.entity.ProjectileBulletEntity;
import net.minecraft.class_1299;

public final class EntityRegistry {
    private static RegistryService<class_1299<?>> entityTypeRegistry = Platform.getInstance().getEntityTypeRegistryService();
    private static final Supplier<class_1299<ProjectileBulletEntity>> bulletEntityType = entityTypeRegistry.register("bullet", () -> ProjectileBulletEntity.TYPE);
    private static List<EntityBuilder<?, ?>> entityBuilders = new ArrayList();
    private static Map<EntityKey, Supplier<EntityBuilder<?, ?>>> entityBuildersByNameType = new HashMap();
    private static Map<String, Supplier<class_1299<?>>> typesByName = new HashMap();
    private static Map<Supplier<class_1299<?>>, Supplier<EntityBuilder<?, ?>>> itemEntityBuilders = new HashMap();

    public static Supplier<EntityBuilder<?, ?>> getEntityBuilder(String name, EntityBuilder.EntityTypeExt type) {
        Supplier<EntityBuilder<?, ?>> supplier = entityBuildersByNameType.get(new EntityKey(name, type));
        if (supplier == null) {
            throw new IllegalArgumentException("Entity '" + name + "' of type '" + String.valueOf((Object)type) + "' not found");
        }
        return supplier;
    }

    public static List<EntityBuilder<?, ?>> getEntityBuilders() {
        return Collections.unmodifiableList(entityBuilders);
    }

    public static Supplier<class_1299<?>> getTypeByName(String name) {
        return typesByName.get(name);
    }

    public static Map<Supplier<class_1299<?>>, Supplier<EntityBuilder<?, ?>>> getItemEntityBuilders() {
        return Collections.unmodifiableMap(itemEntityBuilders);
    }

    public static Supplier<class_1299<?>> registerItemEntity(String name, Supplier<EntityBuilder<?, ?>> entityBuilderSupplier) {
        String entityTypeName = name;
        Supplier<class_1299> sup = () -> ((EntityBuilder)entityBuilderSupplier.get()).getEntityTypeBuilder().method_5905(entityTypeName);
        Supplier<class_1299<?>> registeredEntityType = entityTypeRegistry.register(entityTypeName, sup);
        typesByName.put(entityTypeName, registeredEntityType);
        itemEntityBuilders.put(registeredEntityType, entityBuilderSupplier);
        return registeredEntityType;
    }

    public static void init() {
    }

    private static class EntityKey {
        private String name;
        private EntityBuilder.EntityTypeExt type;

        private EntityKey(String name, EntityBuilder.EntityTypeExt type) {
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityKey other = (EntityKey)obj;
            return Objects.equals(this.name, other.name) && this.type == other.type;
        }
    }
}

