/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.pbj.Enableable;
import mod.pbj.Platform;
import mod.pbj.RegistryService;
import mod.pbj.config.ConfigManager;
import mod.pbj.config.Configurable;
import mod.pbj.entity.EntityBuilderProvider;
import mod.pbj.item.AttachmentItem;
import mod.pbj.item.ItemBuilder;
import mod.pbj.registry.AmmoRegistry;
import mod.pbj.registry.BlockRegistry;
import mod.pbj.registry.EntityRegistry;
import mod.pbj.registry.MiscItemRegistry;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;

public final class ItemRegistry {
    public static RegistryService<class_1792> itemRegistry = Platform.getInstance().getItemRegistry();
    private static RegistryService<class_1761> tabRegistry = Platform.getInstance().getCreativeModeTabRegistry();
    private Map<String, Supplier<? extends class_1792>> itemsByName = new LinkedHashMap<String, Supplier<? extends class_1792>>();
    private Map<String, List<Supplier<? extends class_1792>>> itemsByGroup = new LinkedHashMap<String, List<Supplier<? extends class_1792>>>();
    public static final ItemRegistry ITEMS = new ItemRegistry();
    private final ConfigManager.Builder itemConfigBuilder = new ConfigManager.Builder("pointblank-items");
    public static final Supplier<class_1761> POINTBLANK_TAB = tabRegistry.register("pointblank", () -> class_1761.method_47307((class_1761.class_7915)class_1761.class_7915.field_41049, (int)0).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.pointblank.items")).method_47320(() -> new class_1799((class_1935)BlockRegistry.PRINTER.get())).method_47317((enabledFeatures, entries) -> {
        Consumer<class_1935> output = itemLike -> {
            Enableable e;
            if (itemLike != null && (!(itemLike instanceof Enableable) || (e = (Enableable)itemLike).isEnabled())) {
                entries.method_45421(itemLike);
            }
        };
        AmmoRegistry.registerTabItems(output);
        MiscItemRegistry.registerTabItems(output);
    }).method_47324());

    public Map<String, Supplier<? extends class_1792>> getItemsByName() {
        return Collections.unmodifiableMap(this.itemsByName);
    }

    public List<Supplier<? extends class_1792>> getAttachmentsForGroup(String group) {
        List<Supplier<? extends class_1792>> groupAttachments = this.itemsByGroup.get(group);
        return groupAttachments != null ? Collections.unmodifiableList(groupAttachments) : Collections.emptyList();
    }

    public <I extends class_1792, T extends ItemBuilder<T>> Supplier<I> register(ItemBuilder<?> itemBuilder) {
        EntityBuilderProvider entityBuilderProvider;
        String name = itemBuilder.getName();
        if (itemBuilder instanceof Configurable) {
            Configurable configurable = (Configurable)((Object)itemBuilder);
            configurable.configure(this.itemConfigBuilder);
        }
        Supplier<class_1792> ro = itemRegistry.register(name, new ItemSupplier(itemBuilder));
        this.itemsByName.put(name, ro);
        if (itemBuilder instanceof AttachmentItem.Builder) {
            AttachmentItem.Builder attachmentBuilder = (AttachmentItem.Builder)itemBuilder;
            for (String group : attachmentBuilder.getGroups()) {
                List groupMembers = this.itemsByGroup.computeIfAbsent(group, g -> new ArrayList());
                groupMembers.add(ro);
            }
        }
        if ((entityBuilderProvider = itemBuilder.getEntityBuilderProvider()) != null) {
            EntityRegistry.registerItemEntity(name, entityBuilderProvider::getEntityBuilder);
        }
        return ro;
    }

    public <I extends class_1792> Supplier<I> getDeferredRegisteredObject(String name) {
        String normalizedName = name;
        return () -> {
            Supplier<? extends class_1792> registryObject = this.itemsByName.get(normalizedName);
            return registryObject != null ? registryObject.get() : null;
        };
    }

    public static void complete() {
        ItemRegistry.ITEMS.itemConfigBuilder.build();
    }

    public static void init() {
        MiscItemRegistry.init();
        AmmoRegistry.init();
    }

    public void syncEnabledItems(List<Integer> enabledItemIds) {
        class_1792 item;
        HashSet<class_1792> enabledItemSet = new HashSet<class_1792>();
        for (Integer n : enabledItemIds) {
            item = class_1792.method_7875((int)n);
            enabledItemSet.add(item);
        }
        for (Supplier supplier : this.itemsByName.values()) {
            item = (class_1792)supplier.get();
            if (enabledItemSet.contains(item) || !(item instanceof Enableable)) continue;
            Enableable e = (Enableable)item;
            e.setEnabled(false);
        }
    }

    public static class ItemSupplier
    implements Supplier<class_1792> {
        private final ItemBuilder<?> itemBuilder;

        ItemSupplier(ItemBuilder<?> itemBuilder) {
            this.itemBuilder = itemBuilder;
        }

        public boolean isEnabled() {
            Enableable e;
            ItemBuilder<?> itemBuilder = this.itemBuilder;
            return !(itemBuilder instanceof Enableable) || (e = (Enableable)((Object)itemBuilder)).isEnabled();
        }

        @Override
        public class_1792 get() {
            if (this.isEnabled()) {
                return this.itemBuilder.build();
            }
            return null;
        }
    }
}

