/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import mod.pbj.Config;
import mod.pbj.Platform;
import mod.pbj.RegistryService;
import mod.pbj.mixin.StructureTemplatePoolMixin;
import mod.pbj.registry.BlockRegistry;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3852;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class VillagerRegistry {
    private static RegistryService<class_3852> villagerProfessionRegistry = Platform.getInstance().getVillagerProfessionRegistry();
    private static RegistryService<class_4158> poiTypeRegistry = Platform.getInstance().getPoiTypeRegistry();
    public static Supplier<class_4158> ARMS_DEALER_POI = VillagerRegistry.registerPoiType("arms_dealer", () -> BlockRegistry.WORKSTATION.get(), 1, 1);
    public static Supplier<class_3852> ARMS_DEALER_PROFESSION = VillagerRegistry.registerProfession("arms_dealer", ARMS_DEALER_POI);
    private static final class_2960 ARMS_DEALER_BARN_RESOURCE = class_2960.method_60655((String)"pointblank", (String)"village/all_terrain/arms_dealer_barn");
    private static final class_5321<class_5497> EMPTY_PROCESSOR_LIST_KEY = class_5321.method_29179((class_5321)class_7924.field_41247, (class_2960)class_2960.method_60655((String)"minecraft", (String)"empty"));
    private static final class_2960[] HOUSES_RESOURCES = new class_2960[]{class_2960.method_60655((String)"minecraft", (String)"village/plains/houses"), class_2960.method_60655((String)"minecraft", (String)"village/desert/houses"), class_2960.method_60655((String)"minecraft", (String)"village/savanna/houses"), class_2960.method_60655((String)"minecraft", (String)"village/snowy/houses"), class_2960.method_60655((String)"minecraft", (String)"village/taiga/houses")};

    private static Set<class_2680> getBlockStates(class_2248 block) {
        return ImmutableSet.copyOf((Collection)block.method_9595().method_11662());
    }

    private static Supplier<class_4158> registerPoiType(String name, Supplier<class_2248> block, int maxTickets, int validRange) {
        return poiTypeRegistry.register(name, () -> new class_4158(VillagerRegistry.getBlockStates((class_2248)block.get()), maxTickets, validRange));
    }

    private static Supplier<class_3852> registerProfession(String name, Supplier<class_4158> poiHolder) {
        return villagerProfessionRegistry.register(name, () -> new class_3852(name, arg_0 -> VillagerRegistry.lambda$registerProfession$1((Supplier)poiHolder, arg_0), arg_0 -> VillagerRegistry.lambda$registerProfession$2((Supplier)poiHolder, arg_0), ImmutableSet.of(), ImmutableSet.of(), class_3417.field_20671));
    }

    public static void registerStructures(MinecraftServer server) {
        class_2378 templatePoolRegistry = (class_2378)server.method_30611().method_33310(class_7924.field_41249).orElseThrow();
        class_2378 processorListRegistry = (class_2378)server.method_30611().method_33310(class_7924.field_41247).orElseThrow();
        for (class_2960 poolLocation : HOUSES_RESOURCES) {
            VillagerRegistry.registerStructure((class_2378<class_3785>)templatePoolRegistry, (class_2378<class_5497>)processorListRegistry, poolLocation, ARMS_DEALER_BARN_RESOURCE, Config.armsDealerHouseWeight);
        }
    }

    public static void registerStructure(class_2378<class_3785> templatePoolRegistry, class_2378<class_5497> processorListRegistry, class_2960 targetPoolResource, class_2960 structureResource, int weight) {
        if (weight == 0) {
            return;
        }
        class_6880.class_6883 emptyProcessorList = processorListRegistry.method_40290(EMPTY_PROCESSOR_LIST_KEY);
        class_3785 pool = (class_3785)templatePoolRegistry.method_10223(targetPoolResource);
        if (pool == null) {
            return;
        }
        class_3781 structurePoolElement = (class_3781)class_3781.method_30435((String)structureResource.toString(), (class_6880)emptyProcessorList).apply(class_3785.class_3786.field_16687);
        for (int i = 0; i < weight; ++i) {
            ((StructureTemplatePoolMixin)pool).getTemplates().add((Object)structurePoolElement);
        }
        ArrayList<Pair<class_3784, Integer>> rawTemplates = new ArrayList<Pair<class_3784, Integer>>(((StructureTemplatePoolMixin)pool).getRawTemplates());
        rawTemplates.add((Pair<class_3784, Integer>)new Pair((Object)structurePoolElement, (Object)weight));
        ((StructureTemplatePoolMixin)pool).setRawTemplates(rawTemplates);
    }

    public static void init() {
    }

    private static /* synthetic */ boolean lambda$registerProfession$2(Supplier poiHolder, class_6880 holder) {
        return holder.method_40226(class_7923.field_41128.method_10221((Object)((class_4158)poiHolder.get())));
    }

    private static /* synthetic */ boolean lambda$registerProfession$1(Supplier poiHolder, class_6880 holder) {
        return holder.method_40226(class_7923.field_41128.method_10221((Object)((class_4158)poiHolder.get())));
    }
}

