/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import mod.pbj.util.MiscUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HitScan {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");

    public static List<class_239> getObjectsInCrosshair1(class_1309 player, float partialTicks, double maxDistance, int count, double inaccuracy, long seed, Predicate<class_2248> isBreakableBlock, Predicate<class_2248> isPassThroughBlock, List<class_2338> blockPosToBreakOutput) {
        class_243 startPos = player.method_33571();
        class_243 direction = player.method_5828(partialTicks);
        return HitScan.getObjectsInCrosshair(player, startPos, direction, partialTicks, maxDistance, count, inaccuracy, seed, isBreakableBlock, isPassThroughBlock, blockPosToBreakOutput);
    }

    public static List<class_239> getObjectsInCrosshair(class_1309 player, class_243 startPos, class_243 direction, float partialTicks, double maxDistance, int count, double inaccuracy, long seed, Predicate<class_2248> isBreakableBlock, Predicate<class_2248> isPassThroughBlock, List<class_2338> blockPosToBreakOutput) {
        ArrayList<class_239> hitResults = new ArrayList<class_239>();
        Random random = new Random(seed);
        for (int i = 0; i < count; ++i) {
            long startTime = System.currentTimeMillis();
            long iterationSeed = seed ^ random.nextLong();
            class_243 deviatedLookVec = HitScan.getDeviatedDirectionVector(player, direction, partialTicks, inaccuracy, iterationSeed);
            class_239 hitResult = HitScan.getNearestObjectInCrosshair(player, startPos, deviatedLookVec, partialTicks, maxDistance, isBreakableBlock, isPassThroughBlock, blockPosToBreakOutput);
            if (hitResult != null) {
                hitResults.add(hitResult);
            }
            long endTime = System.currentTimeMillis();
            LOGGER.debug("{} - obtained hit result in {}ms", (Object)(System.currentTimeMillis() % 100000L), (Object)(endTime - startTime));
        }
        return hitResults;
    }

    public static class_239 ensureEntityInCrosshair(class_1309 player, class_1297 targetEntity, float partialTicks, double maxDistance, float bbExpansion) {
        class_243 direction = player.method_5828(partialTicks);
        class_243 startPos = player.method_33571();
        return HitScan.ensureEntityInCrosshair(player, targetEntity, startPos, direction, partialTicks, maxDistance, bbExpansion);
    }

    public static class_239 getNearestObjectInCrosshair(class_1309 player, float partialTicks, double maxDistance, double inaccuracy, long seed, Predicate<class_2248> isBreakableBlock, Predicate<class_2248> isPassThroughBlock, List<class_2338> blockPosToBreakOutput) {
        class_243 direction = player.method_5828(partialTicks);
        class_243 deviatedLookVec = HitScan.getDeviatedDirectionVector(player, direction, partialTicks, inaccuracy, seed);
        class_243 startPos = player.method_33571();
        return HitScan.getNearestObjectInCrosshair(player, startPos, deviatedLookVec, partialTicks, maxDistance, isBreakableBlock, isPassThroughBlock, blockPosToBreakOutput);
    }

    public static class_239 getNearestObjectInCrosshair(class_1309 player, float partialTicks, double maxDistance, Predicate<class_2248> isBreakableBlock, Predicate<class_2248> isPassThroughBlock, List<class_2338> blockPosToBreakOutput) {
        class_243 direction = player.method_5828(partialTicks);
        class_243 startPos = player.method_33571();
        return HitScan.getNearestObjectInCrosshair(player, startPos, direction, partialTicks, maxDistance, isBreakableBlock, isPassThroughBlock, blockPosToBreakOutput);
    }

    private static class_243 getDeviatedDirectionVector(class_1309 player, class_243 dirVector, float partialTicks, double inaccuracy, long seed) {
        Random random = new Random(seed);
        double deviationX = (random.nextDouble() - 0.5) * 2.0 * inaccuracy;
        double deviationY = (random.nextDouble() - 0.5) * 2.0 * inaccuracy;
        double deviationZ = (random.nextDouble() - 0.5) * 2.0 * inaccuracy;
        return dirVector.method_1031(deviationX, deviationY, deviationZ).method_1029();
    }

    public static class_239 getNearestObjectInCrosshair(class_1309 player, class_243 startPos, class_243 directionVector, float partialTicks, double maxDistance, Predicate<class_2248> isBreakableBlock, Predicate<class_2248> isPassThroughBlock, List<class_2338> blockPosToBreakOutput) {
        class_243 endVec = startPos.method_1031(directionVector.field_1352 * maxDistance, directionVector.field_1351 * maxDistance, directionVector.field_1350 * maxDistance);
        class_238 playerBox = player.method_5829();
        class_238 expandedBox = playerBox.method_1012(directionVector.field_1352 * maxDistance, directionVector.field_1351 * maxDistance, directionVector.field_1350 * maxDistance);
        class_1297 closestEntity = null;
        double closestEntityDistance = maxDistance;
        class_243 closestEntityHitVec = null;
        boolean isHeadshot = false;
        for (class_1297 entity : MiscUtil.getLevel((class_1297)player).method_8335((class_1297)player, expandedBox)) {
            double distanceToEntity;
            class_238 entityBox;
            Optional hitVec;
            if (entity.method_7325() || !entity.method_5863() || !entity.method_5805() || !(hitVec = (entityBox = entity.method_5829().method_1014(0.3)).method_992(startPos, endVec)).isPresent() || !((distanceToEntity = startPos.method_1022((class_243)hitVec.get())) < closestEntityDistance)) continue;
            closestEntity = entity;
            closestEntityDistance = distanceToEntity;
            closestEntityHitVec = (class_243)hitVec.get();
        }
        class_3965 blockHit = MiscUtil.getLevel((class_1297)player).method_17742(new class_3959(startPos, endVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        while (blockHit.method_17783() != class_239.class_240.field_1333) {
            class_2338 blockPos = blockHit.method_17777();
            class_2680 blockState = MiscUtil.getLevel((class_1297)player).method_8320(blockPos);
            class_2248 block = blockState.method_26204();
            if (isPassThroughBlock.test(block)) {
                blockHit = MiscUtil.getLevel((class_1297)player).method_17742(new class_3959(blockHit.method_17784(), endVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
                continue;
            }
            if (isBreakableBlock.test(block)) {
                blockPosToBreakOutput.add(blockPos);
                blockHit = MiscUtil.getLevel((class_1297)player).method_17742(new class_3959(blockHit.method_17784(), endVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
                continue;
            }
            double blockDistance = startPos.method_1022(blockHit.method_17784());
            if (!(blockDistance < closestEntityDistance)) break;
            return blockHit;
        }
        return closestEntity != null ? new class_3966(closestEntity, closestEntityHitVec) : blockHit;
    }

    public static boolean isHeadshot(class_1309 entity, class_243 hitVec) {
        class_238 entityBox = entity.method_5829();
        double headHeightStart = entityBox.field_1322 + (double)entity.method_5751() - (double)entity.method_17682() * 0.12;
        double hOffset = 0.301;
        double babyVOffset = entity.method_6109() ? 0.5 : 0.0;
        class_238 headBox = new class_238(entityBox.field_1323 - hOffset, headHeightStart, entityBox.field_1321 - hOffset, entityBox.field_1320 + hOffset, entityBox.field_1325 + (double)entity.method_17682() * 0.1 + babyVOffset, entityBox.field_1324 + hOffset);
        return headBox.method_1006(hitVec);
    }

    protected static class_239 ensureEntityInCrosshair(class_1309 player, class_1297 targetEntity, class_243 startPos, class_243 directionVector, float partialTicks, double maxDistance, float bbExpansion) {
        class_243 endVec = startPos.method_1031(directionVector.field_1352 * maxDistance, directionVector.field_1351 * maxDistance, directionVector.field_1350 * maxDistance);
        class_238 playerBox = player.method_5829();
        class_238 expandedBox = playerBox.method_1012(directionVector.field_1352 * maxDistance, directionVector.field_1351 * maxDistance, directionVector.field_1350 * maxDistance);
        class_243 closestEntityHitVec = null;
        for (class_1297 entity : MiscUtil.getLevel((class_1297)player).method_8335((class_1297)player, expandedBox)) {
            class_238 entityBox;
            Optional hitVec;
            if (entity != targetEntity || entity.method_7325() || !entity.method_5863() || !entity.method_5805() || !(hitVec = (entityBox = entity.method_5829().method_1014((double)bbExpansion)).method_992(startPos, endVec)).isPresent()) continue;
            closestEntityHitVec = (class_243)hitVec.get();
        }
        return closestEntityHitVec != null ? new class_3966(targetEntity, closestEntityHitVec) : null;
    }
}

