/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.util;

import java.util.LinkedList;
import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public final class HitboxHelper {
    private static final WeakHashMap<class_1657, LinkedList<class_243>> PLAYER_POSITION = new WeakHashMap();
    private static final WeakHashMap<class_1657, LinkedList<class_238>> PLAYER_HITBOXES = new WeakHashMap();
    private static final WeakHashMap<class_1657, LinkedList<class_243>> PLAYER_VELOCITY = new WeakHashMap();
    private static final int SAVE_TICK = class_3532.method_15357((double)20.5);

    public static void onPlayerTick(class_1657 player) {
        if (player.method_7325()) {
            PLAYER_POSITION.remove(player);
            PLAYER_HITBOXES.remove(player);
            PLAYER_VELOCITY.remove(player);
        } else {
            LinkedList positions = PLAYER_POSITION.computeIfAbsent(player, p -> new LinkedList());
            LinkedList boxes = PLAYER_HITBOXES.computeIfAbsent(player, p -> new LinkedList());
            LinkedList velocities = PLAYER_VELOCITY.computeIfAbsent(player, p -> new LinkedList());
            positions.addFirst(player.method_19538());
            boxes.addFirst(player.method_5829());
            velocities.addFirst(HitboxHelper.getPlayerVelocity(player));
            if (positions.size() > 2) {
                positions.removeLast();
            }
            if (boxes.size() > SAVE_TICK) {
                boxes.removeLast();
                velocities.removeLast();
            }
        }
    }

    public static void onPlayerLoggedOut(class_1657 player) {
        PLAYER_POSITION.remove(player);
        PLAYER_HITBOXES.remove(player);
        PLAYER_VELOCITY.remove(player);
    }

    public static class_243 getPlayerVelocity(class_1657 entity) {
        LinkedList positions = PLAYER_POSITION.computeIfAbsent(entity, player -> new LinkedList());
        if (positions.size() > 1) {
            class_243 currPos = (class_243)positions.getFirst();
            class_243 prevPos = (class_243)positions.getLast();
            return new class_243(currPos.field_1352 - prevPos.field_1352, currPos.field_1351 - prevPos.field_1351, currPos.field_1350 - prevPos.field_1350);
        }
        return new class_243(0.0, 0.0, 0.0);
    }

    public static class_238 getBoundingBox(class_1657 entity, int ping) {
        if (PLAYER_HITBOXES.containsKey(entity)) {
            LinkedList<class_238> boxes = PLAYER_HITBOXES.get(entity);
            int index = class_3532.method_15340((int)ping, (int)0, (int)(boxes.size() - 1));
            return boxes.get(index);
        }
        return entity.method_5829();
    }

    public static class_243 getVelocity(class_1657 entity, int ping) {
        if (PLAYER_VELOCITY.containsKey(entity)) {
            LinkedList<class_243> velocities = PLAYER_VELOCITY.get(entity);
            int index = class_3532.method_15340((int)ping, (int)0, (int)(velocities.size() - 1));
            return velocities.get(index);
        }
        return HitboxHelper.getPlayerVelocity(entity);
    }

    public static class_238 getFixedBoundingBox(class_1297 entity, class_1297 owner) {
        class_238 boundingBox = entity.method_5829();
        class_243 velocity = new class_243(entity.method_23317() - entity.field_6038, entity.method_23318() - entity.field_5971, entity.method_23321() - entity.field_5989);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (owner instanceof class_3222) {
                class_3222 serverPlayerOwner = (class_3222)owner;
                int ping = class_3532.method_15357((double)((double)serverPlayerOwner.field_13987.method_52405() / 1000.0 * 20.0 + 0.5));
                boundingBox = HitboxHelper.getBoundingBox((class_1657)player, ping);
                velocity = HitboxHelper.getVelocity((class_1657)player, ping);
            }
        }
        double expandHeight = entity instanceof class_1657 && !entity.method_18276() ? 0.0625 : 0.0;
        boundingBox = boundingBox.method_1012(0.0, expandHeight, 0.0);
        boundingBox = boundingBox.method_1012(velocity.field_1352, velocity.field_1351, velocity.field_1350);
        double playerHitboxOffset = 3.0;
        if (entity instanceof class_3222) {
            if (entity.method_5854() != null) {
                boundingBox = boundingBox.method_997(velocity.method_18805(playerHitboxOffset / 2.0, playerHitboxOffset / 2.0, playerHitboxOffset / 2.0));
            }
            boundingBox = boundingBox.method_997(velocity.method_18805(playerHitboxOffset, playerHitboxOffset, playerHitboxOffset));
        }
        if (entity.method_5854() != null) {
            boundingBox = boundingBox.method_997(velocity.method_18805(-2.5, -2.5, -2.5));
        }
        boundingBox = boundingBox.method_997(velocity.method_18805(-5.0, -5.0, -5.0));
        return boundingBox;
    }
}

