/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj;

import com.eliotlash.mclib.math.Variable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.pbj.Config;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.GunClientState;
import mod.pbj.crafting.PointBlankRecipeProvider;
import mod.pbj.entity.ItemsAndEmeraldsToItems;
import mod.pbj.event.AttachmentRemovedEvent;
import mod.pbj.item.AmmoItem;
import mod.pbj.item.FireModeInstance;
import mod.pbj.item.GunItem;
import mod.pbj.item.ThrowableItem;
import mod.pbj.network.ClientBoundPlayerDataSyncPacket;
import mod.pbj.network.Network;
import mod.pbj.registry.AmmoRegistry;
import mod.pbj.registry.BlockEntityRegistry;
import mod.pbj.registry.BlockRegistry;
import mod.pbj.registry.EntityRegistry;
import mod.pbj.registry.ExtensionRegistry;
import mod.pbj.registry.FeatureTypeRegistry;
import mod.pbj.registry.ItemRegistry;
import mod.pbj.registry.MenuRegistry;
import mod.pbj.registry.MiscItemRegistry;
import mod.pbj.registry.ParticleRegistry;
import mod.pbj.registry.RecipeTypeRegistry;
import mod.pbj.registry.SoundRegistry;
import mod.pbj.registry.VillagerRegistry;
import mod.pbj.script.ScriptParser;
import mod.pbj.util.InventoryUtils;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.MolangFunctions;
import mod.pbj.util.ServerTaskScheduler;
import mod.pbj.util.Tradeable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingSwapItemsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.core.molang.LazyVariable;
import software.bernie.geckolib.core.molang.MolangParser;

@Mod(value="pointblank")
public class PointBlankJelly {
    public static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    public ExtensionRegistry extensionRegistry;
    private static final ServerTaskScheduler scheduler = new ServerTaskScheduler();
    private final Random random = new Random();
    public static PointBlankJelly instance;
    public static IEventBus modEventBus;
    private static ItemStack currentHeldItem;

    public PointBlankJelly() {
        instance = this;
        modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        LOGGER.info("Loading mod {}", (Object)"pointblank");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        GeckoLib.initialize();
        PointBlankJelly.registerMolang();
        FeatureTypeRegistry.init();
        this.extensionRegistry = new ExtensionRegistry();
        Dist side = FMLLoader.getDist();
        this.extensionRegistry.discoverExtensions(side.isClient() ? PackType.CLIENT_RESOURCES : PackType.SERVER_DATA);
        ExtensionRegistry.registerItemsFromExtensions(this.extensionRegistry, modEventBus);
        ParticleRegistry.PARTICLES.register(modEventBus);
        SoundRegistry.SOUNDS.register(modEventBus);
        ItemRegistry.ITEMS.register(modEventBus);
        ItemRegistry.TABS.register(modEventBus);
        BlockEntityRegistry.BLOCK_ENTITY_TYPES.register(modEventBus);
        BlockRegistry.BLOCKS.register(modEventBus);
        VillagerRegistry.POI_TYPES.register(modEventBus);
        VillagerRegistry.PROFESSIONS.register(modEventBus);
        EntityRegistry.ENTITIES.register(modEventBus);
        MenuRegistry.MENU_TYPES.register(modEventBus);
        RecipeTypeRegistry.RECIPE_TYPES.register(modEventBus);
        RecipeTypeRegistry.RECIPE_SERIALIZERS.register(modEventBus);
        ItemRegistry.ITEMS.complete();
        ScriptParser.runScripts(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::onAddPackFinder);
        modEventBus.addListener(this::onGatherData);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Network.setupNetworkChannel();
    }

    public static void registerMolang() {
        MolangParser.INSTANCE.register((Variable)new LazyVariable("pbj.ammo", 0.0));
        MolangParser.INSTANCE.register((Variable)new LazyVariable("pbj.firemode", 0.0));
        MolangParser.INSTANCE.register((Variable)new LazyVariable("pbj.fireticks", 0.0));
        MolangParser.INSTANCE.register((Variable)new LazyVariable("pbj.totalshots", 0.0));
        MolangParser.INSTANCE.register((Variable)new LazyVariable("pbj.aiming", 0.0));
        MolangParser.INSTANCE.register((Variable)new LazyVariable("pbj.headbob", 0.0));
        MolangParser.INSTANCE.register((Variable)new LazyVariable("pbj.headrotx", 0.0));
        MolangParser.INSTANCE.register((Variable)new LazyVariable("pbj.headroty", 0.0));
        MolangParser.INSTANCE.register((Variable)new LazyVariable("pbj.crouch", 0.0));
        MolangParser.INSTANCE.register((Variable)new LazyVariable("pbj.crawl", 0.0));
        MolangParser.INSTANCE.functions.put("pbj.e_inoutquart", MolangFunctions.InOutQuart.class);
    }

    public static <E extends Event> void registerEvent(Consumer<E> event) {
        modEventBus.addListener(event);
    }

    public static ServerTaskScheduler getTaskScheduler() {
        return scheduler;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        generator.addProvider(event.includeServer(), (DataProvider)new PointBlankRecipeProvider(output));
    }

    @SubscribeEvent
    public void onSwapHands(LivingSwapItemsEvent.Hands event) {
        ItemStack toOffhand = event.getItemSwappedToOffHand();
        if (toOffhand != null && (toOffhand.m_41720_() instanceof GunItem || toOffhand.m_41720_() instanceof ThrowableItem)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start explosionStart) {
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        server.m_129946_((Runnable)scheduler);
    }

    @SubscribeEvent
    public void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        VillagerRegistry.registerStructures(event.getServer());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    private void onAddPackFinder(AddPackFindersEvent event) {
        event.addRepositorySource(this.extensionRegistry.getRepositorySource());
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
    }

    @SubscribeEvent
    public void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType() == VillagerRegistry.ARMS_DEALER_PROFESSION.get()) {
            for (Map.Entry<String, Supplier<? extends Item>> e : ItemRegistry.ITEMS.getItemsByName().entrySet()) {
                int emeraldCount;
                List levelTrades;
                Item item = e.getValue().get();
                if (!(item instanceof Tradeable)) continue;
                Tradeable tradeableItem = (Tradeable)item;
                float price = tradeableItem.getPrice();
                int tradeLevel = tradeableItem.getTradeLevel();
                if (Float.isNaN(price) || tradeLevel < 1 || tradeLevel > 5 || (levelTrades = (List)event.getTrades().get(tradeLevel)) == null || (emeraldCount = (int)Math.round((double)price / Config.emeraldExchangeRate)) <= 0) continue;
                ItemsAndEmeraldsToItems trade = new ItemsAndEmeraldsToItems((ItemLike)Items.f_42616_, emeraldCount, item, tradeableItem.getBundleQuantity(), 16, 1);
                levelTrades.add(trade);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        float dropChance = (float)Config.itemDropChance;
        if (!MiscUtil.isNearlyZero(dropChance)) {
            float randomNumber = this.random.nextFloat();
            if (event.getEntity() instanceof Monster && randomNumber < dropChance) {
                ItemStack itemStackToDrop = new ItemStack((ItemLike)MiscItemRegistry.GUNMETAL_NUGGET.get(), this.random.nextInt(1, Config.maxItemDropCount));
                ItemEntity drop = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), itemStackToDrop);
                event.getDrops().add(drop);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Item item;
        ItemStack itemStack = event.player.m_21205_();
        if (itemStack != null && itemStack.m_41720_() instanceof GunItem && GunItem.isAiming(itemStack)) {
            event.player.m_6858_(false);
        }
        if (itemStack != null && itemStack != currentHeldItem && (item = currentHeldItem.m_41720_()) instanceof GunItem) {
            GunItem gun = (GunItem)item;
            if (GunClientState.getState(GunItem.getItemStackId(currentHeldItem)).isReloading()) {
                gun.cancelReload(currentHeldItem);
            }
        }
    }

    @SubscribeEvent
    public void onHarvestCheck(PlayerEvent.HarvestCheck check) {
        Player player;
        ItemStack heldItem;
        if (check.getTargetBlock().m_60713_((Block)BlockRegistry.PRINTER.get()) && (heldItem = (player = check.getEntity()).m_21205_()) != null && heldItem.m_41720_() instanceof PickaxeItem) {
            check.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity copyEntity;
        if (event.getTo() != null && (event.getTo().m_41720_() instanceof GunItem || event.getTo().m_41720_() instanceof ThrowableItem) && (copyEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)copyEntity;
            if (event.getSlot() == EquipmentSlot.OFFHAND) {
                ItemStack copy = event.getTo().m_41777_();
                player.m_150109_().f_35976_.clear();
                Vec3 playerPos = event.getEntity().m_20318_(0.0f);
                Containers.m_18992_((Level)MiscUtil.getLevel((Entity)event.getEntity()), (double)playerPos.f_82479_, (double)playerPos.f_82480_, (double)playerPos.f_82481_, (ItemStack)copy);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = MiscUtil.getLevel((Entity)player);
        if (!level.f_46443_) {
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientBoundPlayerDataSyncPacket(player.getPersistentData(), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(Objects::nonNull).map(v -> BuiltInRegistries.f_257033_.m_7447_((Object)((Item)v.get()))).collect(Collectors.toList())));
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Level level = MiscUtil.getLevel((Entity)player);
        if (!level.f_46443_) {
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientBoundPlayerDataSyncPacket(player.getPersistentData(), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(Objects::nonNull).map(v -> BuiltInRegistries.f_257033_.m_7447_((Object)((Item)v.get()))).collect(Collectors.toList())));
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        Level level = MiscUtil.getLevel((Entity)player);
        if (!level.f_46443_) {
            Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientBoundPlayerDataSyncPacket(player.getPersistentData(), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(Objects::nonNull).map(v -> BuiltInRegistries.f_257033_.m_7447_((Object)((Item)v.get()))).collect(Collectors.toList())));
        }
    }

    @SubscribeEvent
    public void onAttachmentRemoved(AttachmentRemovedEvent event) {
        ItemStack rootStack = event.getRootStack();
        Item playerItem = rootStack.m_41720_();
        if (playerItem instanceof GunItem) {
            GunItem gunItem = (GunItem)playerItem;
            Player player = event.getPlayer();
            if (player != null && !MiscUtil.isClientSide((Entity)player)) {
                for (FireModeInstance fireModeInstance : gunItem.getMainFireModes()) {
                    int dropCount;
                    int maxAmmoCapacity;
                    int currentFireModeAmmo = GunItem.getAmmo(rootStack, fireModeInstance);
                    int delta = Math.min(currentFireModeAmmo - (maxAmmoCapacity = gunItem.getMaxAmmoCapacity(rootStack, fireModeInstance)), 1728);
                    if (delta <= 0) continue;
                    List<AmmoItem> actualAmmo = fireModeInstance.getActualAmmo();
                    AmmoItem ammoToRemove = null;
                    if (actualAmmo.size() == 1) {
                        ammoToRemove = actualAmmo.get(0);
                    } else if (actualAmmo.size() > 1) {
                        AmmoItem creativeAmmo = AmmoRegistry.AMMOCREATIVE.get();
                        ammoToRemove = actualAmmo.contains(creativeAmmo) && player.m_7500_() ? creativeAmmo : (AmmoItem)actualAmmo.stream().filter(a -> a != creativeAmmo).findAny().orElse(null);
                    }
                    if (ammoToRemove == null) continue;
                    GunItem.setAmmo(rootStack, fireModeInstance, maxAmmoCapacity);
                    for (int remainingCount = InventoryUtils.addItem(player, ammoToRemove, delta); remainingCount > 0; remainingCount -= dropCount) {
                        dropCount = Math.min(ammoToRemove.m_41459_(), remainingCount);
                        Containers.m_18992_((Level)MiscUtil.getLevel((Entity)event.getPlayer()), (double)(player.m_20185_() + 1.25), (double)(player.m_20186_() + 1.25), (double)player.m_20189_(), (ItemStack)new ItemStack((ItemLike)ammoToRemove, dropCount));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
    }

    static {
        currentHeldItem = ItemStack.f_41583_;
    }
}

