/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.controller;

import java.util.Random;
import mod.pbj.client.GunClientState;
import mod.pbj.client.GunStateListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class AdvancedRecoilController
implements GunStateListener {
    private final Random random = new Random();
    private static final double BASELINE_RESET_THRESHOLD = 5.0;
    private final double verticalAmplitude;
    private final double verticalRecovery;
    private final double verticalSmoothness;
    private final double horizontalAmplitude;
    private final double horizontalRecovery;
    private final double horizontalSmoothness;
    private final double horizontalRandomness;
    private final String pattern;
    private double accumulatedRecoilPitch = 0.0;
    private double accumulatedRecoilYaw = 0.0;
    private double remainingPitchToRecover = 0.0;
    private double remainingYawToRecover = 0.0;
    private float burstStartPitch;
    private float burstStartYaw;
    private boolean isInBurst = false;
    private double remainingKickPitch = 0.0;
    private double remainingKickYaw = 0.0;
    private State currentState = State.IDLE;

    public AdvancedRecoilController(double verticalAmplitude, double verticalRecovery, double verticalSmoothness, double horizontalAmplitude, double horizontalRecovery, double horizontalSmoothness, double horizontalRandomness, String pattern) {
        this.verticalAmplitude = verticalAmplitude;
        this.verticalRecovery = verticalRecovery;
        this.verticalSmoothness = Mth.m_14008_((double)verticalSmoothness, (double)0.01, (double)1.0);
        this.horizontalAmplitude = horizontalAmplitude;
        this.horizontalRecovery = horizontalRecovery;
        this.horizontalSmoothness = Mth.m_14008_((double)horizontalSmoothness, (double)0.01, (double)1.0);
        this.horizontalRandomness = horizontalRandomness;
        this.pattern = pattern;
    }

    @Override
    public void onStartFiring(LivingEntity player, GunClientState state, ItemStack itemStack) {
        if (!this.isInBurst) {
            this.burstStartPitch = player.m_146909_();
            this.burstStartYaw = player.m_146908_();
            this.isInBurst = true;
        } else if ((double)player.m_146909_() > (double)this.burstStartPitch + 5.0) {
            this.burstStartPitch = player.m_146909_();
            this.accumulatedRecoilPitch = 0.0;
            if ((double)Math.abs(player.m_146908_() - this.burstStartYaw) > 5.0) {
                this.burstStartYaw = player.m_146908_();
                this.accumulatedRecoilYaw = 0.0;
            }
        }
        double verticalKick = -this.verticalAmplitude;
        double horizontalKick = this.calculateHorizontalRecoil();
        this.remainingKickPitch += verticalKick;
        this.remainingKickYaw += horizontalKick;
        this.accumulatedRecoilPitch += verticalKick;
        this.accumulatedRecoilYaw += horizontalKick;
    }

    @Override
    public void onUpdateState(LivingEntity player, GunClientState state) {
        if (!state.isFiring() && this.isInBurst) {
            this.startReset(player);
            this.isInBurst = false;
        }
    }

    @Override
    public void onRenderTick(LivingEntity player, GunClientState state, ItemStack itemStack, ItemDisplayContext itemDisplayContext, float partialTicks) {
        if (this.remainingKickPitch != 0.0 || this.remainingKickYaw != 0.0) {
            double pitchToApply = this.remainingKickPitch * 0.15;
            double yawToApply = this.remainingKickYaw * 0.15;
            player.m_146926_(player.m_146909_() + (float)pitchToApply);
            player.m_146922_(player.m_146908_() + (float)yawToApply);
            this.remainingKickPitch -= pitchToApply;
            this.remainingKickYaw -= yawToApply;
            if (Math.abs(this.remainingKickPitch) < 0.001) {
                this.remainingKickPitch = 0.0;
            }
            if (Math.abs(this.remainingKickYaw) < 0.001) {
                this.remainingKickYaw = 0.0;
            }
        }
        if (this.currentState != State.RESETTING) {
            return;
        }
        double pitchRecoveryThisFrame = this.remainingPitchToRecover * this.verticalSmoothness;
        double yawRecoveryThisFrame = this.remainingYawToRecover * this.horizontalSmoothness;
        player.m_146926_(player.m_146909_() + (float)pitchRecoveryThisFrame);
        player.m_146922_(player.m_146908_() + (float)yawRecoveryThisFrame);
        this.remainingPitchToRecover -= pitchRecoveryThisFrame;
        this.remainingYawToRecover -= yawRecoveryThisFrame;
        if (Math.abs(this.remainingPitchToRecover) < 0.01 && Math.abs(this.remainingYawToRecover) < 0.01) {
            this.reset();
        }
    }

    private void startReset(LivingEntity player) {
        double maxTheoreticalPitchRecovery = -this.accumulatedRecoilPitch * this.verticalRecovery;
        double maxTheoreticalYawRecovery = -this.accumulatedRecoilYaw * this.horizontalRecovery;
        double currentPitchDisplacement = player.m_146909_() - this.burstStartPitch;
        double currentYawDisplacement = player.m_146908_() - this.burstStartYaw;
        double actualPitchToApply = maxTheoreticalPitchRecovery > 0.0 ? Math.min(maxTheoreticalPitchRecovery, -currentPitchDisplacement) : Math.max(maxTheoreticalPitchRecovery, -currentPitchDisplacement);
        double actualYawToApply = maxTheoreticalYawRecovery > 0.0 ? Math.min(maxTheoreticalYawRecovery, -currentYawDisplacement) : Math.max(maxTheoreticalYawRecovery, -currentYawDisplacement);
        if (Math.signum(actualPitchToApply) != Math.signum(maxTheoreticalPitchRecovery) && maxTheoreticalPitchRecovery != 0.0) {
            actualPitchToApply = 0.0;
        }
        if (Math.signum(actualYawToApply) != Math.signum(maxTheoreticalYawRecovery) && maxTheoreticalYawRecovery != 0.0) {
            actualYawToApply = 0.0;
        }
        this.remainingPitchToRecover = actualPitchToApply;
        this.remainingYawToRecover = actualYawToApply;
        this.accumulatedRecoilPitch = 0.0;
        this.accumulatedRecoilYaw = 0.0;
        if (this.remainingPitchToRecover != 0.0 || this.remainingYawToRecover != 0.0) {
            this.currentState = State.RESETTING;
        }
    }

    private void reset() {
        this.currentState = State.IDLE;
        this.remainingPitchToRecover = 0.0;
        this.remainingYawToRecover = 0.0;
        this.isInBurst = false;
    }

    private double calculateHorizontalRecoil() {
        double base = this.horizontalAmplitude;
        double randomFactor = (this.random.nextDouble() - 0.5) * 2.0 * this.horizontalRandomness;
        switch (this.pattern.toLowerCase()) {
            case "pull_right": {
                return base + randomFactor;
            }
            case "pull_left": {
                return -base + randomFactor;
            }
        }
        return (double)(this.random.nextBoolean() ? 1 : -1) * base + randomFactor;
    }

    private static enum State {
        IDLE,
        RESETTING;

    }
}

