/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.controller;

import java.util.Objects;
import mod.pbj.client.GunClientState;
import mod.pbj.client.GunStateListener;
import mod.pbj.client.RealtimeLinearEaser;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class InertiaController
implements GunStateListener {
    private double previousYaw;
    private double targetYawTiltAngle;
    private double previousPitch;
    private double targetPitchTiltAngle;
    private double maxTiltAngle;
    private double tiltFactor;
    private double smoothingFactor;
    private final double dampingFactor = 0.01;
    private final float threshold = 0.01f;
    private long lastUpdateTime = System.nanoTime();
    private double roll;
    private double pitch;
    private double yaw;
    private float dynamicModifier;
    private final RealtimeLinearEaser dynamicModifierEaser = new RealtimeLinearEaser(1000L);

    public InertiaController(double tiltFactor, double smoothingFactor, double maxTiltAngle) {
        this.tiltFactor = tiltFactor;
        this.smoothingFactor = smoothingFactor;
        this.maxTiltAngle = maxTiltAngle;
        this.reset();
    }

    @Override
    public void onUpdateState(LivingEntity player, GunClientState state) {
        long currentTime = System.nanoTime();
        double deltaTime = (double)(currentTime - this.lastUpdateTime) / 1.0E9;
        this.lastUpdateTime = currentTime;
        float currentYaw = player.m_146908_();
        double deltaYaw = (double)currentYaw - this.previousYaw;
        double yawTurnSpeed = deltaYaw / deltaTime;
        float currentPitch = player.m_146909_();
        double deltaPitch = (double)currentPitch - this.previousPitch;
        double pitchTurnSpeed = deltaPitch / deltaTime;
        double scaledTiltFactor = this.tiltFactor * (double)this.dynamicModifierEaser.update(this.dynamicModifier);
        double yawInterpolationSpeed = this.smoothingFactor * deltaTime;
        double d = Math.abs(yawTurnSpeed);
        Objects.requireNonNull(this);
        if (d >= (double)0.01f) {
            this.targetYawTiltAngle = yawTurnSpeed * (state.isAiming() ? 0.2 : 1.0) * scaledTiltFactor;
        } else {
            this.targetYawTiltAngle *= this.dampingFactor;
            yawInterpolationSpeed *= 30.0;
        }
        double pitchInterpolationSpeed = this.smoothingFactor * deltaTime;
        double d2 = Math.abs(pitchTurnSpeed);
        Objects.requireNonNull(this);
        if (d2 >= (double)0.01f) {
            this.targetPitchTiltAngle = pitchTurnSpeed * (state.isAiming() ? 0.2 : 1.0) * scaledTiltFactor;
        } else {
            this.targetPitchTiltAngle *= this.dampingFactor;
            pitchInterpolationSpeed *= 30.0;
        }
        this.targetYawTiltAngle = Mth.m_14008_((double)this.targetYawTiltAngle, (double)(-this.maxTiltAngle), (double)this.maxTiltAngle);
        this.targetPitchTiltAngle = Mth.m_14008_((double)this.targetPitchTiltAngle, (double)(-this.maxTiltAngle), (double)this.maxTiltAngle);
        this.yaw += (this.targetYawTiltAngle - this.yaw) * yawInterpolationSpeed;
        this.pitch += (this.targetPitchTiltAngle - this.pitch) * pitchInterpolationSpeed;
        this.roll += (this.targetYawTiltAngle - this.roll) * yawInterpolationSpeed;
        this.previousYaw = currentYaw;
        this.previousPitch = currentPitch;
    }

    @Override
    public void onRenderTick(LivingEntity player, GunClientState state, ItemStack itemStack, ItemDisplayContext itemDisplayContext, float partialTicks) {
    }

    public void reset() {
        this.yaw = 0.0;
        this.pitch = 0.0;
        this.roll = 0.0;
        this.previousYaw = 0.0;
        this.previousPitch = 0.0;
        this.dynamicModifier = 1.0f;
        this.lastUpdateTime = System.nanoTime();
    }

    public void reset(Player player) {
        this.yaw = 0.0;
        this.pitch = 0.0;
        this.roll = 0.0;
        this.previousYaw = player.m_146908_();
        this.previousPitch = player.m_146909_();
        this.dynamicModifier = 1.0f;
        this.lastUpdateTime = System.nanoTime();
    }

    public double getRoll() {
        return this.roll;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    void setTiltFactor(double tiltFactor) {
        this.tiltFactor = tiltFactor;
    }

    void setSmoothingFactor(double smoothingFactor) {
        this.smoothingFactor = smoothingFactor;
    }

    void setMaxTiltAngle(double maxTiltAngle) {
        this.maxTiltAngle = maxTiltAngle;
    }

    public void setDynamicModifier(float dynamicModifier) {
        if (dynamicModifier < this.dynamicModifier) {
            this.dynamicModifierEaser.update(dynamicModifier, true);
        }
        this.dynamicModifier = dynamicModifier;
    }
}

