/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.client.gui.MouseInteractionHandler;
import mod.pbj.event.AttachmentAddedEvent;
import mod.pbj.event.AttachmentRemovedEvent;
import mod.pbj.inventory.AttachmentContainerMenu;
import mod.pbj.inventory.AttachmentSlot;
import mod.pbj.inventory.HierarchicalSlot;
import mod.pbj.inventory.SimpleAttachmentContainer;
import mod.pbj.registry.SoundRegistry;
import mod.pbj.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector4f;
import software.bernie.geckolib.util.ClientUtils;

public class AttachmentManagerScreen
extends AbstractContainerScreen<AttachmentContainerMenu> {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("pointblank", "textures/gui/attachments4.png");
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("pointblank", "textures/gui/blueprint-background-2.png");
    protected static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/widgets.png");
    private static final Vector4f COLOR_GREEN = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
    private final Inventory playerInventory;
    private final MouseInteractionHandler mouseInteractionHandler;
    private final int inventoryWidth = 176;
    private final int inventoryHeight = 90;
    private final int slotWidth = 18;
    private final int slotHeight = 18;
    private final int slotRightPadding = 4;
    private final int headerBottomPadding = 2;
    private final AttachmentContainerMenu menu;
    private String selectedAttachmentPath;
    private final Queue<AttachmentHighlightEvent> attachmentEventQueue = new ArrayDeque<AttachmentHighlightEvent>();

    public AttachmentManagerScreen(AttachmentContainerMenu menu, Inventory playerInventory, Component titleIn) {
        super((AbstractContainerMenu)menu, playerInventory, titleIn);
        this.menu = menu;
        this.playerInventory = playerInventory;
        this.f_97727_ = 250;
        this.f_97726_ = 370;
        this.mouseInteractionHandler = new MouseInteractionHandler(this::isMouseInScreen, 0.5f, 2.0f, 0.1f);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            ItemStack selectedStack = this.playerInventory.m_36056_();
            if (!(selectedStack.m_41720_() instanceof AttachmentHost)) {
                Minecraft.m_91087_().m_91152_(null);
            } else {
                AttachmentHighlightEvent event = this.attachmentEventQueue.peek();
                if (event != null && event.isExpired()) {
                    this.attachmentEventQueue.poll();
                }
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        this.m_280273_(guiGraphics);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        guiGraphics.m_280398_(BACKGROUND_TEXTURE, 0, 0, 1, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
        RenderSystem.disableBlend();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        poseStack.m_85849_();
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack selectedItem = this.f_96541_.f_91074_.m_21205_();
        if (selectedItem != null && selectedItem.m_41720_() instanceof AttachmentHost) {
            Component label = selectedItem.m_41720_().m_7626_(selectedItem);
            guiGraphics.m_280653_(this.f_96547_, label, 180, 15, 0xFFFF00);
        }
    }

    private void renderItemInHand(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(this.f_96543_ / 2 + 5), (float)(this.f_96544_ / 2 - 30), 180.0f);
        this.applyMouseInteractionTransforms(poseStack, mouseX, mouseY);
        float zoom = this.mouseInteractionHandler.getZoom();
        poseStack.m_85841_(zoom, zoom, zoom);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.m_85841_(100.0f, 100.0f, 100.0f);
        PoseStack modelStack = RenderSystem.getModelViewStack();
        modelStack.m_85836_();
        modelStack.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource buffer = this.f_96541_.m_91269_().m_110104_();
        ItemStack itemStack = minecraft.f_91074_.m_21205_();
        BakedModel model = minecraft.m_91291_().m_174264_(itemStack, MiscUtil.getLevel((Entity)minecraft.f_91074_), (LivingEntity)minecraft.f_91074_, minecraft.f_91074_.m_19879_() + ItemDisplayContext.GROUND.ordinal());
        minecraft.m_91291_().m_115143_(itemStack, ItemDisplayContext.GROUND, false, new PoseStack(), (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        modelStack.m_85849_();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private void applyMouseInteractionTransforms(PoseStack poseStack, int mouseX, int mouseY) {
        float interactionOffsetX = (float)this.mouseInteractionHandler.getX() + (this.mouseInteractionHandler.isInteracting() && this.mouseInteractionHandler.isTranslating() ? (float)mouseX - this.mouseInteractionHandler.getMouseClickedX() : 0.0f);
        float interactionOffsetY = (float)this.mouseInteractionHandler.getY() + (this.mouseInteractionHandler.isInteracting() && this.mouseInteractionHandler.isTranslating() ? (float)mouseY - this.mouseInteractionHandler.getMouseClickedY() : 0.0f);
        poseStack.m_252880_(interactionOffsetX, interactionOffsetY, 0.0f);
        float interactionPitch = this.mouseInteractionHandler.getRotationPitch() - (this.mouseInteractionHandler.isInteracting() && this.mouseInteractionHandler.isRotating() ? (float)mouseY - this.mouseInteractionHandler.getMouseClickedY() : 0.0f) - 30.0f;
        float interactionYaw = this.mouseInteractionHandler.getRotationYaw() + (this.mouseInteractionHandler.isInteracting() && this.mouseInteractionHandler.isRotating() ? (float)mouseX - this.mouseInteractionHandler.getMouseClickedX() : 0.0f) + 150.0f;
        poseStack.m_252781_(new Quaternionf().rotationXYZ(interactionPitch * ((float)Math.PI / 180), interactionYaw * ((float)Math.PI / 180), 0.0f));
    }

    public String getSelectedAttachmentPath() {
        return this.selectedAttachmentPath;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        AttachmentSlot attachmentSlot;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 250.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = this.getLeft();
        int top = this.getTop();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280398_(GUI_TEXTURES, left, top, 1000, 0.0f, 0.0f, 176, 90, 256, 256);
        int attLeft = this.f_97735_ + 5;
        int attTop = this.f_97736_ + 8;
        int slotTextureLeftOffset = 176;
        int unavailableSlotTextureTopOffset = 36;
        SimpleAttachmentContainer childContainer = null;
        Slot i = this.f_97734_;
        if (i instanceof HierarchicalSlot) {
            HierarchicalSlot hSlot = (HierarchicalSlot)i;
            this.selectedAttachmentPath = hSlot.getPath();
        }
        if ((i = this.f_97734_) instanceof AttachmentSlot && (childContainer = (attachmentSlot = (AttachmentSlot)i).getChildContainer()) != null) {
            int childContainerIndex = childContainer.getContainerIndex();
            poseStack.m_85836_();
            int elementsCount = childContainer.getVirtualInventory().getElements().size();
            guiGraphics.m_280637_(attLeft + childContainerIndex * 22 - 2, attTop - 2, 22, 24 + 18 * elementsCount, -1061093377);
            poseStack.m_85849_();
        }
        SimpleAttachmentContainer[] attachmentContainers = this.menu.getAttachmentContainers();
        for (int j = 0; j < attachmentContainers.length; ++j) {
            SimpleAttachmentContainer attachmentContainer = attachmentContainers[j];
            int availableSlotTextureTopOffset = j == 0 ? 0 : 18;
            int containerStartIndex = SimpleAttachmentContainer.getContainerStartIndex(attachmentContainers, j);
            if (attachmentContainer.getVirtualInventory() == null || attachmentContainer.getVirtualInventory().getElements().isEmpty()) continue;
            if (this.menu.m_38853_(containerStartIndex).m_6659_()) {
                guiGraphics.m_280398_(GUI_TEXTURES, attLeft + j * 22, attTop, 1000, (float)slotTextureLeftOffset, 54.0f, 18, 18, 256, 256);
            }
            for (int k = 1; k < attachmentContainer.m_6643_(); ++k) {
                int adjustedSlotIndex = containerStartIndex + k;
                AttachmentSlot slot = (AttachmentSlot)this.menu.m_38853_(adjustedSlotIndex);
                if (!slot.m_6659_()) continue;
                int textureTopOffset = this.menu.m_142621_() != null && !this.menu.m_142621_().m_41619_() && !slot.m_5857_(this.menu.m_142621_()) ? unavailableSlotTextureTopOffset : availableSlotTextureTopOffset;
                guiGraphics.m_280398_(GUI_TEXTURES, attLeft + j * 22, attTop + this.headerBottomPadding + k * 18, 1000, (float)slotTextureLeftOffset, (float)textureTopOffset, 18, 18, 256, 256);
            }
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        this.renderItemInHand(guiGraphics, mouseX, mouseY);
        this.selectedAttachmentPath = null;
        poseStack.m_85849_();
        RenderSystem.disableBlend();
        poseStack.m_252880_(0.0f, 0.0f, 2000.0f);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.mouseInteractionHandler.onMouseScrolled(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.mouseInteractionHandler.onMouseButtonClicked(mouseX, mouseY, button) || super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.mouseInteractionHandler.onMouseButtonReleased(mouseX, mouseY, button) || super.m_6348_(mouseX, mouseY, button);
    }

    private int getLeft() {
        return (this.f_96543_ - 176) / 2;
    }

    private int getTop() {
        return (this.f_96544_ - 90) / 2 + 74;
    }

    private boolean isMouseInScreen(double mouseX, double mouseY) {
        boolean isMouseInInventory;
        int width = 176;
        int left = this.getLeft();
        int top = this.getTop();
        boolean bl = isMouseInInventory = mouseX >= (double)left && mouseX <= (double)(left + width) && mouseY >= (double)top && mouseY <= (double)(top + 90);
        if (isMouseInInventory) {
            return false;
        }
        int attLeft = this.f_97735_ + 5;
        int attTop = this.f_97736_ + 8;
        boolean isMouseInAttachmentContainer = false;
        SimpleAttachmentContainer[] attachmentContainers = this.menu.getAttachmentContainers();
        for (int i = 0; i < attachmentContainers.length; ++i) {
            SimpleAttachmentContainer attachmentContainer = attachmentContainers[i];
            int containerStartIndex = SimpleAttachmentContainer.getContainerStartIndex(attachmentContainers, i);
            if (attachmentContainer.getVirtualInventory() == null || attachmentContainer.getVirtualInventory().getElements().isEmpty()) continue;
            int slotLeft = attLeft + i * 22;
            int slotRight = slotLeft + 18 + 4;
            if (mouseX < (double)slotLeft || mouseX > (double)slotRight || mouseY < (double)attTop) continue;
            int yBottom = 0;
            for (int j = 1; j < attachmentContainer.m_6643_(); ++j) {
                int adjustedSlotIndex = containerStartIndex + j;
                AttachmentSlot slot = (AttachmentSlot)this.menu.m_38853_(adjustedSlotIndex);
                if (slot.m_6659_()) continue;
                yBottom = attTop + this.headerBottomPadding + j * 18;
                break;
            }
            if (!(mouseY < (double)yBottom)) continue;
            isMouseInAttachmentContainer = true;
            break;
        }
        return !isMouseInAttachmentContainer;
    }

    public void m_7379_() {
        this.selectedAttachmentPath = null;
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        super.m_7379_();
    }

    public void beforeRenderingSlot(GuiGraphics guiGraphics, Slot slot) {
        if (!(slot instanceof AttachmentSlot)) {
            if (this.menu.getPlayerInventory().f_35977_ == 9 - (this.menu.f_38839_.size() - slot.f_40219_)) {
                guiGraphics.m_280509_(slot.f_40220_, slot.f_40221_, slot.f_40220_ + 16, slot.f_40221_ + 16, 1348235500);
            }
            if (slot.f_40219_ >= this.menu.getTotalAttachmentSlots() && this.mayPlaceAttachment(slot.m_7993_())) {
                guiGraphics.m_280509_(slot.f_40220_, slot.f_40221_, slot.f_40220_ + 16, slot.f_40221_ + 16, -1605328816);
            }
        }
    }

    private boolean mayPlaceAttachment(ItemStack attachmentStack) {
        if (!attachmentStack.m_41619_() && attachmentStack.m_41720_() instanceof Attachment) {
            SimpleAttachmentContainer[] attachmentContainers = this.menu.getAttachmentContainers();
            for (int i = 0; i < attachmentContainers.length; ++i) {
                SimpleAttachmentContainer attachmentContainer = attachmentContainers[i];
                int containerStartIndex = SimpleAttachmentContainer.getContainerStartIndex(attachmentContainers, i);
                if (attachmentContainer.getVirtualInventory() == null || attachmentContainer.getVirtualInventory().getElements().isEmpty()) continue;
                for (int j = 1; j < attachmentContainer.m_6643_(); ++j) {
                    int adjustedSlotIndex = containerStartIndex + j;
                    AttachmentSlot slot = (AttachmentSlot)this.menu.m_38853_(adjustedSlotIndex);
                    if (!slot.m_6659_() || !slot.m_5857_(attachmentStack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Pair<RenderType, Vector4f> getRenderTypeOverride(ItemStack baseItemStack, ItemStack attachmentItemStack, String attachmentName, String attachmentPath) {
        ResourceLocation texture = new ResourceLocation("pointblank", "textures/item/" + attachmentName + ".png");
        AttachmentHighlightEvent attachmentHighlight = this.attachmentEventQueue.peek();
        if (attachmentHighlight != null && ItemStack.m_41656_((ItemStack)attachmentItemStack, (ItemStack)attachmentHighlight.attachmentStack)) {
            if (attachmentHighlight.isHighlighted()) {
                RenderType renderType = RenderType.m_110488_((ResourceLocation)texture);
                return Pair.of((Object)renderType, (Object)COLOR_GREEN);
            }
            return null;
        }
        String selectedAttachmentPath = this.getSelectedAttachmentPath();
        if (Objects.equals(attachmentPath, selectedAttachmentPath)) {
            RenderType renderType = RenderType.m_110488_((ResourceLocation)texture);
            return Pair.of((Object)renderType, (Object)COLOR_GREEN);
        }
        if (selectedAttachmentPath != null && selectedAttachmentPath.endsWith("/") && attachmentPath.startsWith(selectedAttachmentPath.substring(0, selectedAttachmentPath.length() - 1))) {
            RenderType renderType = RenderType.m_110488_((ResourceLocation)texture);
            return Pair.of((Object)renderType, (Object)COLOR_GREEN);
        }
        return null;
    }

    @SubscribeEvent
    public void onAttachmentAdded(AttachmentAddedEvent event) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            if (this.f_96541_.f_91080_ != this) {
                return;
            }
            ClientUtils.getClientPlayer().m_5496_(SoundRegistry.ATTACHMENT_ADDED.get(), 1.0f, 1.0f);
            this.attachmentEventQueue.add(new AttachmentHighlightEvent(System.currentTimeMillis(), 750L, event.getParentStack(), event.getAttachmentStack()));
        }
    }

    @SubscribeEvent
    public void onAttachmentRemoved(AttachmentRemovedEvent event) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            if (this.f_96541_.f_91080_ != this) {
                return;
            }
            ClientUtils.getClientPlayer().m_5496_(SoundRegistry.ATTACHMENT_REMOVED.get(), 1.0f, 1.0f);
            this.attachmentEventQueue.add(new AttachmentHighlightEvent(System.currentTimeMillis(), 750L, event.getParentStack(), event.getAttachmentStack()));
        }
    }

    private static class AttachmentHighlightEvent {
        private final long startTime;
        private final long duration;
        private final ItemStack parentStack;
        private final ItemStack attachmentStack;
        private final long blinkInterval;

        public AttachmentHighlightEvent(long startTime, long duration, ItemStack parentStack, ItemStack attachmentStack) {
            this.startTime = startTime;
            this.duration = duration;
            this.parentStack = parentStack;
            this.attachmentStack = attachmentStack;
            this.blinkInterval = 150L;
        }

        public boolean isHighlighted() {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            if (elapsedTime >= this.duration) {
                return false;
            }
            long k = elapsedTime / this.blinkInterval;
            return k % 2L == 0L;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() >= this.startTime + this.duration;
        }
    }
}

