/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.model;

import java.util.ArrayList;
import java.util.List;
import mod.pbj.client.BiDirectionalInterpolator;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.GunClientState;
import mod.pbj.client.controller.BlendingAnimationProcessor;
import mod.pbj.item.FireModeInstance;
import mod.pbj.item.GunItem;
import mod.pbj.util.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibException;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreBakedGeoModel;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.molang.MolangParser;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.util.RenderUtils;

public class GunGeoModel
extends DefaultedItemGeoModel<GunItem> {
    private BakedGeoModel currentModel = null;
    private final List<ResourceLocation> fallbackAnimations = new ArrayList<ResourceLocation>();
    private final BlendingAnimationProcessor<GunItem> anotherAnimationProcessor = new BlendingAnimationProcessor(this);
    @Nullable
    public static GeoBone mainBone;

    public GunGeoModel(ResourceLocation assetSubpath, List<ResourceLocation> fallbackAnimations) {
        super(assetSubpath);
        for (ResourceLocation fallbackAnimation : fallbackAnimations) {
            this.fallbackAnimations.add(this.buildFormattedAnimationPath(fallbackAnimation));
        }
    }

    public void applyMolangQueries(GunItem animatable, double animTime) {
        super.applyMolangQueries((GeoAnimatable)animatable, animTime);
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        GunClientState state = GunClientState.getMainHeldState();
        if (state == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        MolangParser.INSTANCE.setValue("pbj.ammo", () -> ((Integer)GunItem.getClientSideAmmo(ClientUtil.getClientPlayer(), ClientUtil.getClientPlayer().m_21205_(), ClientUtil.getClientPlayer().m_150109_().f_35977_).orElse((Object)0)).intValue());
        MolangParser.INSTANCE.setValue("pbj.firemode", GunGeoModel::getFireModeIndex);
        MolangParser.INSTANCE.setValue("pbj.fireticks", state::getTotalUninterruptedFireTime);
        MolangParser.INSTANCE.setValue("pbj.totalshots", state::getTotalUninterruptedShots);
        MolangParser.INSTANCE.setValue("pbj.aiming", () -> state.isAiming() ? 0.0 : 1.0);
        BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)state.getAnimationController("aiming");
        double aimprog = aimingController == null ? 0.0 : aimingController.getValue();
        MolangParser.INSTANCE.setValue("pbj.aimprog", () -> aimprog);
        MolangParser.INSTANCE.setValue("pbj.headbob", () -> player.f_36100_);
        MolangParser.INSTANCE.setValue("pbj.headrotx", () -> ((LocalPlayer)player).m_146909_());
        MolangParser.INSTANCE.setValue("pbj.headroty", () -> ((LocalPlayer)player).m_146908_());
        MolangParser.INSTANCE.setValue("pbj.crawl", () -> player.m_20143_() ? 0.0 : 1.0);
        MolangParser.INSTANCE.setValue("pbj.crouch", () -> ClientEventHandler.getInstance().crouchProg.update(player.m_6047_() && !state.isAiming() ? 1.0f : 0.0f));
        MolangParser.INSTANCE.setMemoizedValue("query.health", () -> ((LocalPlayer)player).m_21223_());
        MolangParser.INSTANCE.setMemoizedValue("query.max_health", () -> ((LocalPlayer)player).m_21233_());
        MolangParser.INSTANCE.setMemoizedValue("query.is_on_fire", () -> RenderUtils.booleanToFloat((boolean)player.m_6060_()));
        MolangParser.INSTANCE.setMemoizedValue("query.ground_speed", () -> {
            Vec3 velocity = player.m_272267_(Minecraft.m_91087_().getPartialTick());
            return Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        });
        MolangParser.INSTANCE.setMemoizedValue("query.yaw_speed", () -> player.m_5675_((float)animTime - player.m_5675_((float)animTime - 0.1f)));
    }

    public static int getFireModeIndex() {
        ItemStack stack;
        Player player = ClientUtil.getClientPlayer();
        ItemStack itemStack = stack = player != null ? player.m_21205_() : null;
        if (player != null && player.m_21205_().m_41720_() instanceof GunItem) {
            int i = 0;
            for (FireModeInstance fireMode : GunItem.getFireModes(stack)) {
                if (GunItem.getFireModeInstance(stack) == fireMode) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public AnimationProcessor<GunItem> getAnimationProcessor() {
        return this.anotherAnimationProcessor;
    }

    public BakedGeoModel getBakedModel(ResourceLocation location) {
        BakedGeoModel model = (BakedGeoModel)GeckoLibCache.getBakedModels().get(location);
        if (model == null) {
            throw new GeckoLibException(location, "Unable to find model");
        }
        if (model != this.currentModel) {
            this.anotherAnimationProcessor.setActiveModel((CoreBakedGeoModel)model);
            this.currentModel = model;
        }
        mainBone = model.getBone("main").orElse(null);
        return this.currentModel;
    }

    public Animation getAnimation(GunItem animatable, String name) {
        ResourceLocation location = this.getAnimationResource((GeoAnimatable)animatable);
        BakedAnimations bakedAnimations = (BakedAnimations)GeckoLibCache.getBakedAnimations().get(location);
        Animation bakedAnimation = null;
        if (bakedAnimations != null) {
            bakedAnimation = bakedAnimations.getAnimation(name);
        }
        if (bakedAnimation == null) {
            for (ResourceLocation animationLocation : this.fallbackAnimations) {
                BakedAnimations altAnimations = (BakedAnimations)GeckoLibCache.getBakedAnimations().get(animationLocation);
                if (altAnimations == null || (bakedAnimation = altAnimations.getAnimation(name)) == null) continue;
                break;
            }
        }
        return bakedAnimation;
    }
}

