/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import mod.pbj.client.render.ArmorInHandRenderer;
import mod.pbj.client.render.HierarchicalRenderContext;
import mod.pbj.client.render.RenderPass;
import mod.pbj.client.render.RenderPassGeoRenderer;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.Feature;
import mod.pbj.feature.PartVisibilityFeature;
import mod.pbj.feature.SkinFeature;
import mod.pbj.item.ArmorItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class ArmorItemRenderer
extends GeoArmorRenderer<ArmorItem>
implements RenderPassGeoRenderer<ArmorItem> {
    public ArmorInHandRenderer internal;

    public ArmorItemRenderer(ResourceLocation assetSubpath, ArmorInHandRenderer internal) {
        super((GeoModel)new DefaultedItemGeoModel(assetSubpath));
        this.internal = internal;
    }

    public boolean approveRendering(String boneName, ItemStack rootStack) {
        if (boneName.charAt(0) == '_') {
            return false;
        }
        Collection<Feature> features = ((ArmorItem)rootStack.m_41720_()).getFeatures();
        ConditionContext conditionContext = new ConditionContext(null, rootStack, this.currentStack, null, null);
        for (Feature feature : features) {
            PartVisibilityFeature visibilityFeature;
            if (!(feature instanceof PartVisibilityFeature) || !(visibilityFeature = (PartVisibilityFeature)feature).isEnabled(rootStack) || visibilityFeature.isPartVisible((ItemLike)rootStack.m_41720_(), boneName, conditionContext)) continue;
            return false;
        }
        return true;
    }

    public void defaultRender(PoseStack poseStack, ArmorItem animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        try (HierarchicalRenderContext hrc = HierarchicalRenderContext.push(this.getCurrentStack(), ItemDisplayContext.FIXED);){
            poseStack.m_85836_();
            Color renderColor = this.getRenderColor((GeoAnimatable)animatable, partialTick, packedLight);
            float red = renderColor.getRedFloat();
            float green = renderColor.getGreenFloat();
            float blue = renderColor.getBlueFloat();
            float alpha = renderColor.getAlphaFloat();
            int packedOverlay = this.getPackedOverlay((GeoAnimatable)animatable, 0.0f, partialTick);
            BakedGeoModel model = this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)animatable, (GeoRenderer)this));
            if (renderType == null) {
                renderType = this.getRenderType((Item)animatable, this.getTextureLocation(animatable), bufferSource, partialTick);
            }
            if (buffer == null) {
                buffer = bufferSource.m_6299_(renderType);
            }
            this.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            if (this.firePreRenderEvent(poseStack, model, bufferSource, partialTick, packedLight)) {
                poseStack.m_85836_();
                poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
                poseStack.m_85837_(-0.5, -2.0, -0.5);
                this.internal.m_108829_(this.currentStack, ItemDisplayContext.HEAD, poseStack, bufferSource, packedLight, packedOverlay);
                poseStack.m_85849_();
                this.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                this.firePostRenderEvent(poseStack, model, bufferSource, partialTick, packedLight);
            }
            poseStack.m_85849_();
            this.renderFinal(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            this.doPostRenderCleanup();
        }
    }

    public ResourceLocation getTextureLocation(ArmorItem animatable) {
        ResourceLocation texture = null;
        HierarchicalRenderContext hrc = HierarchicalRenderContext.getRoot();
        if (hrc != null) {
            ItemStack itemStack = hrc.getItemStack();
            texture = SkinFeature.getTexture(itemStack);
        }
        if (texture == null) {
            texture = super.getTextureLocation((GeoAnimatable)animatable);
        }
        return texture;
    }

    @Override
    public GeoRenderer<ArmorItem> getRenderer() {
        return this;
    }

    @Override
    public boolean isEffectLayer() {
        return false;
    }

    @Override
    public RenderType getRenderType() {
        return null;
    }

    @Override
    public boolean isSupportedItemDisplayContext(ItemDisplayContext var1) {
        return false;
    }

    @Override
    public RenderPass getRenderPass() {
        return RenderPass.MAIN_ITEM;
    }
}

