/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mod.pbj.client.render.RenderUtil;
import mod.pbj.item.GunItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CrosshairRenderer {
    public static void renderCrosshairOverlay3(GuiGraphics guiGraphics, float partialTick, ResourceLocation targetLockonOverlay, float expansionRatio, float posX, float posY, int renderWidth, int renderHeight) {
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        float halfLockWidth = 8.0f;
        float halfLockHeight = 8.0f;
        float centerX = posX + (float)renderWidth * 0.5f;
        float centerY = posY + (float)renderHeight * 0.5f;
        float xOffset = halfLockWidth * 0.4f * expansionRatio;
        float yOffset = halfLockHeight * 0.4f * expansionRatio;
        float ratio = 0.17948718f;
        float uvOffset = (1.0f - ratio) * 0.5f;
        float sq = 30.0f;
        float innerSide = sq * ratio;
        float halfSq = sq * 0.5f;
        float halfInnerSide = innerSide * 0.5f;
        float hairLength = (sq - innerSide) * 0.5f;
        float hairWidth = 0.5f;
        float maxU = 1.0f - uvOffset;
        float maxV = 1.0f - uvOffset;
        float posXStart = centerX - halfInnerSide;
        float posXEnd = centerX + halfInnerSide;
        float posYStart = centerY - halfInnerSide;
        float posYEnd = centerY + halfInnerSide;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, uvOffset, maxU, uvOffset, maxV);
        ItemStack itemStack = Minecraft.m_91087_().f_91074_.m_21205_();
        Item item = itemStack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gun = (GunItem)item;
            if (GunItem.getFireModeInstance(itemStack).isMelee()) {
                guiGraphics.m_280509_((int)centerX - 10, (int)(centerY + 4.0f) + 20, (int)((float)((int)centerX) + Minecraft.m_91087_().f_91074_.m_36403_(0.0f) * 20.0f - 10.0f), (int)centerY + 20, -1);
            }
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float minU = 0.0f;
        float minV = 0.0f;
        maxV = 1.0f - minV;
        posXStart = centerX - halfInnerSide - hairLength - xOffset;
        posXEnd = centerX - halfInnerSide + hairWidth - xOffset;
        posYStart = centerY - halfSq;
        posYEnd = centerY + halfSq;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, uvOffset, minV, maxV);
        minU = 1.0f - uvOffset;
        maxU = 1.0f;
        minV = 0.0f;
        maxV = 1.0f - minV;
        posXStart = centerX + halfInnerSide - hairWidth + xOffset;
        posXEnd = centerX + halfInnerSide + hairLength - hairWidth + xOffset;
        posYStart = centerY - halfSq;
        posYEnd = centerY + halfSq;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
        minU = 0.0f;
        maxU = 1.0f;
        minV = 1.0f - uvOffset;
        maxV = 1.0f;
        posXStart = centerX - halfSq;
        posXEnd = centerX + halfSq;
        posYStart = centerY + halfInnerSide - hairWidth + yOffset;
        posYEnd = posYStart + hairLength - hairWidth;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
    }

    private void renderCrosshairOverlay(GuiGraphics guiGraphics, float partialTick, ResourceLocation targetLockonOverlay, float expansionRatio, float posX, float posY, int renderWidth, int renderHeight) {
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float lockRatio = 0.2f;
        int halfLockWidth = 4;
        int halfLockHeight = 4;
        float centerX = posX + (float)renderWidth * 0.5f;
        float centerY = posY + (float)renderHeight * 0.5f;
        float xOffset = (float)halfLockWidth * 0.4f * expansionRatio;
        float yOffset = (float)halfLockHeight * 0.4f * expansionRatio;
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 1.0f;
        float maxV = 0.4f;
        float posXStart = centerX - (float)halfLockWidth;
        float posXEnd = centerX + (float)halfLockWidth;
        float posYStart = centerY - (float)halfLockHeight - yOffset;
        float posYEnd = centerY - yOffset;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
        minU = 0.6f;
        minV = 0.0f;
        maxU = 1.0f;
        maxV = 1.0f;
        posXStart = centerX + xOffset;
        posXEnd = centerX + (float)halfLockWidth + xOffset;
        posYStart = centerY - (float)halfLockHeight;
        posYEnd = centerY + (float)halfLockHeight;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
        minU = 0.0f;
        minV = 0.0f;
        maxU = 1.0f;
        maxV = 0.4f;
        posXStart = centerX - (float)halfLockWidth;
        posXEnd = centerX + (float)halfLockWidth;
        posYStart = centerY + yOffset;
        posYEnd = centerY + (float)halfLockHeight + yOffset;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
        minU = 0.0f;
        minV = 0.0f;
        maxU = 0.4f;
        maxV = 1.0f;
        posXStart = centerX - (float)halfLockWidth - xOffset;
        posXEnd = centerX - xOffset;
        posYStart = centerY - (float)halfLockHeight;
        posYEnd = centerY + (float)halfLockHeight;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
    }

    private void renderCrosshairOverlay2(GuiGraphics guiGraphics, float partialTick, ResourceLocation targetLockonOverlay, float expansionRatio, float posX, float posY, int renderWidth, int renderHeight) {
        expansionRatio += 0.2f;
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float halfLockWidth = 5.0f;
        float halfLockHeight = 5.0f;
        float centerX = posX + (float)renderWidth * 0.5f;
        float centerY = posY + (float)renderHeight * 0.5f;
        float xOffset = (float)((int)halfLockWidth) * 0.4f * expansionRatio;
        float yOffset = (float)((int)halfLockHeight) * 0.4f * expansionRatio;
        float posXStart = 0.0f;
        float posXEnd = 0.0f;
        float posYStart = 0.5f;
        float posYEnd = 0.5f;
        float minU = centerX - halfLockWidth - xOffset;
        float minV = centerX - xOffset;
        float maxU = centerY - halfLockHeight - yOffset;
        float maxV = centerY - yOffset;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, minU, minV, maxU, maxV, -90.0f, posXStart, posYStart, posXEnd, posYEnd);
        posXStart = centerX + xOffset;
        posXEnd = centerX + halfLockWidth + xOffset;
        posYStart = centerY - halfLockHeight - yOffset;
        posYEnd = centerY - yOffset;
        minU = 0.5f;
        minV = 0.0f;
        maxU = 1.0f;
        maxV = 0.5f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
        posXStart = centerX + xOffset;
        posXEnd = centerX + halfLockWidth + xOffset;
        posYStart = centerY + yOffset;
        posYEnd = centerY + halfLockHeight + yOffset;
        minU = 0.5f;
        minV = 0.5f;
        maxU = 1.0f;
        maxV = 1.0f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
        posXStart = centerX - halfLockWidth - xOffset;
        posXEnd = centerX - xOffset;
        posYStart = centerY + yOffset;
        posYEnd = centerY + halfLockHeight + yOffset;
        minU = 0.0f;
        minV = 0.5f;
        maxU = 0.5f;
        maxV = 1.0f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
    }
}

