/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render;

import com.google.common.base.Objects;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import mod.pbj.Config;
import mod.pbj.client.BiDirectionalInterpolator;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.ClientSystem;
import mod.pbj.client.GunClientState;
import mod.pbj.client.GunStatePoseProvider;
import mod.pbj.client.controller.GlowAnimationController;
import mod.pbj.client.controller.RotationAnimationController;
import mod.pbj.client.effect.EffectRenderContext;
import mod.pbj.client.effect.MuzzleFlashEffect;
import mod.pbj.client.gui.AttachmentManagerScreen;
import mod.pbj.client.model.GunGeoModel;
import mod.pbj.client.render.HierarchicalRenderContext;
import mod.pbj.client.render.RenderApprover;
import mod.pbj.client.render.RenderPass;
import mod.pbj.client.render.RenderPassGeoRenderer;
import mod.pbj.client.render.RenderPassProvider;
import mod.pbj.client.render.RenderTypeProvider;
import mod.pbj.client.render.RenderUtil;
import mod.pbj.client.render.layer.AttachmentLayer;
import mod.pbj.client.render.layer.GlowingItemLayer;
import mod.pbj.client.render.layer.GunHandsItemLayer;
import mod.pbj.client.render.layer.MuzzleFlashItemLayer;
import mod.pbj.client.render.layer.PipItemLayer;
import mod.pbj.client.render.layer.ReticleItemLayer;
import mod.pbj.client.uv.SpriteUVProvider;
import mod.pbj.compat.iris.IrisCompat;
import mod.pbj.compat.vivecraft.VivecraftCompat;
import mod.pbj.feature.ActiveMuzzleFeature;
import mod.pbj.feature.AimingFeature;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.Feature;
import mod.pbj.feature.Features;
import mod.pbj.feature.PartVisibilityFeature;
import mod.pbj.feature.SkinFeature;
import mod.pbj.item.GunItem;
import mod.pbj.mixin.BakedModelMixin;
import mod.pbj.registry.EffectRegistry;
import mod.pbj.util.MiscUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.SeparateTransformsModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL30;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.RenderUtils;

@OnlyIn(value=Dist.CLIENT)
public class GunItemRenderer
extends GeoItemRenderer<GunItem>
implements RenderPassGeoRenderer<GunItem>,
RenderApprover {
    public static final String BONE_SCOPE = "scope";
    public static final String BONE_RETICLE = "reticle";
    public static final String BONE_SCOPE_PIP = "scopepip";
    public static final String BONE_RIGHTARM = "rightarm";
    public static final String BONE_LEFTARM = "leftarm";
    public static final String BONE_MUZZLE = "muzzle";
    public static final String BONE_MUZZLE2 = "muzzle2";
    public static final String BONE_MUZZLE3 = "muzzle3";
    public static final String BONE_MUZZLEFLASH = "muzzleflash";
    public static final String BONE_MUZZLEFLASH2 = "muzzleflash2";
    public static final String BONE_MUZZLEFLASH3 = "muzzleflash3";
    public static final String BONE_CAMERA = "_camera_";
    public static final float DEFAULT_MAX_ANGULAR_RETICLE_OFFSET = Mth.m_14089_((float)0.08726646f);
    public static final float DEFAULT_MAX_ANGULAR_RETICLE_OFFSET_NOT_AIMED = Mth.m_14089_((float)((float)Math.PI / 90));
    private GunClientState gunClientState;
    private boolean hasScopeOverlay;
    private ItemTransforms transforms;
    private final ResourceLocation leftHandModelResource = new ResourceLocation("pointblank", "geo/item/left_arm.geo.json");
    private final ResourceLocation rightHandModelResource = new ResourceLocation("pointblank", "geo/item/right_arm.geo.json");
    private final ResourceLocation reticleModelResource = new ResourceLocation("pointblank", "geo/item/reticle.geo.json");
    private boolean useCustomGlowingTexture;
    private Set<Direction> glowDirections;
    private Supplier<SpriteUVProvider> glowingSpriteUVProviderSupplier;
    private float glowingProgress;
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final VivecraftCompat vivecraft = VivecraftCompat.getInstance();

    public GunItemRenderer(ResourceLocation modelResource, List<ResourceLocation> fallbackAnimations, List<GlowAnimationController.Builder> glowEffectBuilders) {
        super((GeoModel)new GunGeoModel(modelResource, fallbackAnimations));
        this.addRenderLayer(new AttachmentLayer<GunItem>(this));
        for (GlowAnimationController.Builder glowEffectBuilder : glowEffectBuilders) {
            ResourceLocation glowTexture = glowEffectBuilder.getTexture();
            if (glowTexture == null) {
                glowTexture = this.getGeoModel().getTextureResource((GeoAnimatable)((GunItem)this.animatable));
            }
            this.addRenderLayer(new GlowingItemLayer<GunItem>(this, glowEffectBuilder.getEffectId(), glowTexture));
        }
        this.addRenderLayer(new GunHandsItemLayer<GunItem>(this));
        this.addRenderLayer(new PipItemLayer(this));
        this.addRenderLayer(new ReticleItemLayer(this));
        this.addRenderLayer(new MuzzleFlashItemLayer(this));
    }

    public ResourceLocation getTextureLocation(GunItem animatable) {
        ResourceLocation texture = null;
        HierarchicalRenderContext hrc = HierarchicalRenderContext.getRoot();
        if (hrc != null) {
            ItemStack itemStack = hrc.getItemStack();
            texture = SkinFeature.getTexture(itemStack);
        }
        if (texture == null) {
            texture = super.getTextureLocation((Item)animatable);
        }
        return texture;
    }

    @Override
    public GeoRenderer<GunItem> getRenderer() {
        return this;
    }

    public GunClientState getGunClientState() {
        return this.gunClientState;
    }

    private BakedGeoModel getLeftHandModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.leftHandModelResource);
    }

    private BakedGeoModel getRightHandModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.rightHandModelResource);
    }

    private BakedGeoModel getReticleModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.reticleModelResource);
    }

    private Player getPlayer(ItemDisplayContext itemDisplayContext) {
        if (itemDisplayContext != ItemDisplayContext.FIRST_PERSON_LEFT_HAND && itemDisplayContext != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && itemDisplayContext != ItemDisplayContext.GROUND) {
            LivingEntity renderedEntity = ClientEventHandler.getCurrentEntityLiving();
            return renderedEntity instanceof Player ? (Player)renderedEntity : null;
        }
        return ClientUtils.getClientPlayer();
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!IrisCompat.getInstance().isRenderingShadows()) {
            Player player;
            Minecraft mc = Minecraft.m_91087_();
            if (!(mc.f_91080_ instanceof AttachmentManagerScreen && itemDisplayContext != ItemDisplayContext.GROUND || (player = this.getPlayer(itemDisplayContext)) == null)) {
                Minecraft.m_91087_().m_91385_().enableStencil();
                int depthTextureId = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36096, (int)36049);
                int stencilTextureId = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36128, (int)36048);
                if (depthTextureId != 0 && stencilTextureId == 0) {
                    GL30.glBindTexture((int)3553, (int)depthTextureId);
                    int dataType = GL30.glGetTexLevelParameteri((int)3553, (int)0, (int)35862);
                    if (dataType == 35863) {
                        int width = GL30.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                        int height = GL30.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                        GlStateManager._texImage2D((int)3553, (int)0, (int)35056, (int)width, (int)height, (int)0, (int)34041, (int)34042, null);
                        GlStateManager._glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)depthTextureId, (int)0);
                    }
                }
                MultiBufferSource wrappedBufferSource = RenderTypeProvider.getInstance().wrapBufferSource(bufferSource);
                try (HierarchicalRenderContext hrc = HierarchicalRenderContext.push(stack, itemDisplayContext);){
                    this.renderPass(() -> {
                        boolean isOffhand;
                        int slotIndex = player.m_150109_().m_36030_(stack);
                        GunClientState state = GunClientState.getState(player, stack, slotIndex, isOffhand = player != null && player.m_21206_() == stack);
                        if (state != null) {
                            GunStatePoseProvider.getInstance().clear(state.getId());
                        }
                        boolean isFirstPerson = itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                        poseStack.m_85836_();
                        GunItem gunItem = (GunItem)stack.m_41720_();
                        this.hasScopeOverlay = gunItem.getScopeOverlay() != null;
                        GeoModel geoModel = this.getGeoModel();
                        if (isFirstPerson) {
                            GeoBone scopeBone = geoModel.getBone(BONE_SCOPE).orElse(null);
                            this.initTransforms(player, stack, itemDisplayContext);
                            this.adjustFirstPersonPose(stack, gunItem, state, poseStack, (GeoModel<GunItem>)geoModel, scopeBone);
                        }
                        this.gunClientState = state;
                        super.m_108829_(stack, itemDisplayContext, poseStack, wrappedBufferSource, packedLight, packedOverlay);
                        poseStack.m_85849_();
                    });
                }
            }
        }
    }

    @Override
    public void renderPass(Runnable runnablePass) {
        RenderPass.push(this.getRenderPass());
        try {
            runnablePass.run();
        }
        finally {
            RenderPass.pop();
        }
    }

    private void adjustFirstPersonPose(ItemStack itemStack, GunItem gunItem, GunClientState state, PoseStack poseStack, GeoModel<GunItem> geoModel, GeoBone scopeBone) {
        ItemTransform fprt;
        if (this.transforms != null && (fprt = this.transforms.f_111790_) != null) {
            float aimingProgress = 0.0f;
            if (state != null) {
                BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)state.getAnimationController("aiming");
                aimingProgress = (float)aimingController.getValue();
            }
            float v = 1.0f - aimingProgress;
            float rescale = gunItem.getModelScale();
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(new Quaternionf().rotationXYZ(-fprt.f_111755_.x * ((float)Math.PI / 180), -fprt.f_111755_.y * ((float)Math.PI / 180), -fprt.f_111755_.z * ((float)Math.PI / 180)));
            poseStack.m_252880_(-fprt.f_111756_.x, -fprt.f_111756_.y, -fprt.f_111756_.z);
            poseStack.m_252880_(fprt.f_111756_.x * rescale, fprt.f_111756_.y * rescale, fprt.f_111756_.z * rescale);
            poseStack.m_252781_(new Quaternionf().rotationXYZ(v * fprt.f_111755_.x * ((float)Math.PI / 180), v * fprt.f_111755_.y * ((float)Math.PI / 180), v * fprt.f_111755_.z * ((float)Math.PI / 180)));
            poseStack.m_252880_(aimingProgress * -fprt.f_111756_.x * rescale, aimingProgress * -fprt.f_111756_.y * rescale, aimingProgress * -fprt.f_111756_.z * rescale);
            AimingFeature.applyAimingPosition(itemStack, poseStack, rescale, aimingProgress);
            poseStack.m_85841_(rescale, rescale, rescale);
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            float curve = Mth.m_14031_((float)((float)Math.PI * aimingProgress));
            double aimingCurveX = gunItem.getAimingCurveX();
            double aimingCurveY = gunItem.getAimingCurveY();
            double aimingCurveZ = gunItem.getAimingCurveZ();
            double aimingCurvePitch = gunItem.getAimingCurvePitch();
            double aimingCurveYaw = gunItem.getAimingCurveYaw();
            double aimingCurveRoll = gunItem.getAimingCurveRoll();
            poseStack.m_85837_((double)curve * aimingCurveX, (double)curve * aimingCurveY, (double)curve * aimingCurveZ);
            poseStack.m_252781_(new Quaternionf((double)curve * aimingCurvePitch * 0.01745329238474369, (double)curve * aimingCurveYaw * 0.01745329238474369, (double)curve * aimingCurveRoll * 0.01745329238474369, 1.0));
            poseStack.m_252880_(0.48f * v, -1.12f * v, -0.72f * v);
            poseStack.m_252880_(-0.006f, 0.6f, 0.0f);
        }
    }

    private void initTransforms(Player player, ItemStack stack, ItemDisplayContext itemDisplayContext) {
        if (this.transforms == null) {
            Minecraft minecraft = Minecraft.m_91087_();
            BakedModel bakedModel = minecraft.m_91291_().m_174264_(stack, MiscUtil.getLevel((Entity)player), (LivingEntity)player, player.m_19879_() + itemDisplayContext.ordinal());
            if (bakedModel instanceof SeparateTransformsModel.Baked) {
                BakedModel baseModel = ((BakedModelMixin)bakedModel).getBaseModel();
                this.transforms = baseModel.m_7442_();
            } else {
                this.transforms = bakedModel.m_7442_();
            }
        }
    }

    public void createVerticesOfQuad(GeoQuad quad, Matrix4f poseState, Vector3f normal, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (RenderPass.current() != RenderPass.RETICLE || quad.direction() == Direction.SOUTH) {
            float[][] texUV;
            GeoVertex[] vertices = quad.vertices();
            if (this.glowingSpriteUVProviderSupplier != null) {
                SpriteUVProvider spriteUVProvider = this.glowingSpriteUVProviderSupplier.get();
                float[] uv = spriteUVProvider.getSpriteUV(this.glowingProgress);
                float minU = uv[0];
                float minV = uv[1];
                float maxU = uv[2];
                float maxV = uv[3];
                texUV = new float[][]{{minU, minV}, {maxU, minV}, {maxU, maxV}, {minU, maxV}};
            } else {
                texUV = new float[][]{{0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}};
            }
            for (int i = 0; i < vertices.length; ++i) {
                float texV;
                float texU;
                GeoVertex vertex = vertices[i];
                Vector3f position = vertex.position();
                Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
                RenderPass renderPass = RenderPass.current();
                if (renderPass == RenderPass.GLOW && this.useCustomGlowingTexture) {
                    texU = texUV[i][0];
                    texV = texUV[i][1];
                } else {
                    texU = vertex.texU();
                    texV = vertex.texV();
                }
                int MAX_ATTEMPTS = 30;
                int attempts = 0;
                while (attempts < 30) {
                    try {
                        buffer.m_5954_(vector4f.x(), vector4f.y(), vector4f.z(), red, green, blue, alpha, texU, texV, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
                        break;
                    }
                    catch (IllegalStateException e) {
                        LOGGER.warn("[GunItemRenderer.createVerticesOfQuad] failed to add vertex to buffer, retrying {}/{}", (Object)(++attempts), (Object)30);
                    }
                }
                if (attempts < 30) continue;
                LOGGER.error("[GunItemRenderer.createVerticesOfQuad] failed to add vertex to buffer after {} attempts!", (Object)30);
            }
        }
    }

    private boolean shouldRenderBone(String boneName) {
        if (boneName.charAt(0) == '_') {
            return false;
        }
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        ItemStack rootStack = HierarchicalRenderContext.getRoot().getItemStack();
        boolean shouldRender = true;
        for (GeoRenderLayer layer : this.getRenderLayers()) {
            RenderPass renderPass;
            RenderPass var10000;
            if (!(layer instanceof RenderApprover)) continue;
            RenderApprover renderApprover = (RenderApprover)layer;
            if (layer instanceof RenderPassProvider) {
                RenderPassProvider rp = (RenderPassProvider)layer;
                var10000 = rp.getRenderPass();
            } else {
                var10000 = null;
            }
            if (renderApprover.approveRendering(renderPass = var10000, boneName, rootStack, current.getItemStack(), current.getPath(), current.getItemDisplayContext())) continue;
            shouldRender = false;
            break;
        }
        return shouldRender;
    }

    public void renderRecursively(PoseStack poseStack, GunItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        ItemStack rootStack = HierarchicalRenderContext.getRoot().getItemStack();
        boolean shouldRender = this.approveRendering(this.getRenderPass(), bone.getName(), rootStack, current.getItemStack(), current.getPath(), current.getItemDisplayContext());
        if (shouldRender) {
            boolean isGlowEnabled;
            GlowAnimationController glowEffect = this.gunClientState != null ? (GlowAnimationController)this.gunClientState.getAnimationController("glowEffect" + String.valueOf(RenderPass.getEffectId())) : null;
            Runnable r = () -> {
                RotationAnimationController spinner;
                RotationAnimationController rotationAnimationController = spinner = this.gunClientState != null ? (RotationAnimationController)this.gunClientState.getAnimationController("rotation" + bone.getName()) : null;
                if (spinner != null) {
                    spinner.renderRecursively(this, poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                } else {
                    super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
                }
            };
            boolean bl = isGlowEnabled = glowEffect != null && glowEffect.getGlowingPartNames().contains(bone.getName());
            if (isGlowEnabled) {
                try (HierarchicalRenderContext subHrc = HierarchicalRenderContext.push(current.getItemStack(), current.getItemDisplayContext());){
                    GlowingItemLayer.setGlowEnabled(isGlowEnabled);
                    r.run();
                }
            } else {
                r.run();
            }
        }
    }

    public void renderRecursivelySuper(PoseStack poseStack, GunItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderCubesOfBone(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (ClientSystem.getInstance().getAuxLevelRenderer().isRenderingPip()) {
            return;
        }
        boolean vrActive = vivecraft != null && vivecraft.isVrActive();
        RenderPass renderPass = RenderPass.current();
        if (this.shouldRenderBone(bone.getName())) {
            HierarchicalRenderContext hrc = HierarchicalRenderContext.current();
            ItemDisplayContext itemDisplayContext = hrc.getItemDisplayContext();
            boolean isFirstPerson = itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
            double aimingProgress = 0.0;
            if (this.gunClientState != null) {
                Object aimingController = (BiDirectionalInterpolator)this.gunClientState.getAnimationController("aiming");
                aimingProgress = ((BiDirectionalInterpolator)aimingController).getValue();
                if ((!MiscUtil.isGreaterThanZero(this.gunClientState.getGunItem().getPipScopeZoom()) || !Config.pipScopesEnabled) && this.hasScopeOverlay && !this.gunClientState.isReloading() && isFirstPerson && aimingProgress > 0.4) {
                    return;
                }
            }
            switch (renderPass) {
                case GLOW: {
                    this.renderGlow(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    break;
                }
                case HANDS: {
                    if (vrActive) break;
                    switch (bone.getName()) {
                        case "rightarm": {
                            this.renderRightArm(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                            break;
                        }
                        case "leftarm": {
                            this.renderLeftArm(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                        }
                    }
                    break;
                }
                case PIP: {
                    if (!bone.getName().equals(BONE_SCOPE_PIP)) break;
                    this.renderPip(poseStack, bone, buffer, packedLight, red, green, blue, aimingProgress);
                    break;
                }
                case PIP_OVERLAY: {
                    if (!bone.getName().equals(BONE_SCOPE_PIP)) break;
                    this.renderPipOverlay(poseStack, bone, buffer, packedLight, red, green, blue, aimingProgress, PipItemLayer.isParallaxEnabled() && !vrActive);
                    break;
                }
                case PIP_MASK: {
                    if (!bone.getName().equals(BONE_SCOPE_PIP)) break;
                    this.renderPipMask(poseStack, bone, buffer, packedLight, red, green, blue, aimingProgress);
                    break;
                }
                case RETICLE: {
                    boolean isParallaxEnabled = ReticleItemLayer.isParallaxEnabled();
                    if (isParallaxEnabled && bone.getName().equals(BONE_RETICLE) && !vrActive) {
                        this.renderReticleWithParallax(poseStack, bone, buffer, packedLight, red, green, blue, aimingProgress, hrc.getAttribute("max_angular_offset_cos", Float.valueOf(DEFAULT_MAX_ANGULAR_RETICLE_OFFSET)).floatValue());
                        break;
                    }
                    if (isParallaxEnabled || !bone.getName().equals(BONE_SCOPE)) break;
                    this.renderReticle(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, aimingProgress);
                    break;
                }
                case MUZZLE_FLASH: {
                    if (!bone.getName().equals(BONE_MUZZLEFLASH) && !bone.getName().equals(BONE_MUZZLEFLASH2) && !bone.getName().equals(BONE_MUZZLEFLASH3)) break;
                    this.renderMuzzleFlash(poseStack, bone, buffer, packedLight);
                    break;
                }
                case MAIN_ITEM: 
                case ATTACHMENTS: {
                    if (!(bone.getName().equals(BONE_MUZZLEFLASH) || bone.getName().equals(BONE_MUZZLEFLASH2) || bone.getName().equals(BONE_MUZZLEFLASH3) || bone.getName().equals(BONE_MUZZLE) || bone.getName().equals(BONE_MUZZLE2) || bone.getName().equals(BONE_MUZZLE3))) {
                        if (!this.canRenderPart(bone.getName())) break;
                        super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                        break;
                    }
                    if (!ActiveMuzzleFeature.isActiveMuzzle(HierarchicalRenderContext.getRootItemStack(), hrc.getItemStack(), itemDisplayContext, bone.getName())) break;
                    this.captureMuzzlePose(bone, poseStack, itemDisplayContext);
                }
            }
        }
    }

    private void renderGlow(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        GlowAnimationController glowEffect;
        if (this.gunClientState != null && GlowingItemLayer.isGlowEnabled() && (glowEffect = (GlowAnimationController)this.gunClientState.getAnimationController("glowEffect" + String.valueOf(RenderPass.getEffectId()))) != null) {
            glowEffect.renderCubesOfBone(this, poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    private void renderMuzzleFlash(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight) {
        List cubes;
        if (!(this.gunClientState == null || this.gunClientState.isReloading() || this.gunClientState.isInspecting() || (cubes = bone.getCubes()) == null || cubes.isEmpty())) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad quad1 = cube.quads()[0];
            Vector3f v1Position = quad1.vertices()[0].position();
            GeoQuad quad2 = cube.quads()[2];
            Vector3f v3Position = quad2.vertices()[2].position();
            Vector3f position = new Vector3f();
            position = v3Position.sub((Vector3fc)v1Position, position);
            position = position.mul(0.5f);
            position = position.add((Vector3fc)v1Position);
            EffectRenderContext context = new EffectRenderContext().withPoseStack(poseStack).withPosition(new Vec3((double)position.x, (double)position.y, (double)position.z)).withVertexBuffer(buffer).withLightColor(packedLight);
            List<MuzzleFlashEffect> muzzleFlashEffects = this.gunClientState.getMuzzleFlashEffects();
            for (int i = 0; i < muzzleFlashEffects.size(); ++i) {
                MuzzleFlashEffect effect = muzzleFlashEffects.get(i);
                UUID effectId = EffectRegistry.getEffectId(effect.getName());
                if (!Objects.equal((Object)effectId, (Object)RenderPass.getEffectId())) continue;
                effect.render(context);
            }
        }
    }

    private void renderReticleWithParallax(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, float red, float green, float blue, double aimingProgress, float maxAngularOffsetCos) {
        List cubes;
        if (bone != null && this.gunClientState != null && !(aimingProgress < 0.8) && (cubes = bone.getCubes()) != null && !cubes.isEmpty()) {
            float threshold;
            Vector4f n;
            Vector4f p0;
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            Matrix4f modelMatrix = this.captureCubeMatrix(poseStack, cube, 3);
            Pair<Vector4f, Float> intersection = GunItemRenderer.getPlayerViewIntersection(modelMatrix, p0 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), n = new Vector4f(0.0f, 0.0f, -1.0f, 1.0f));
            Vector4f intersectionPoint = (Vector4f)intersection.getFirst();
            if (intersectionPoint == null) {
                return;
            }
            float angularOffsetCos = ((Float)intersection.getSecond()).floatValue();
            float f = threshold = !(aimingProgress < 1.0) && !this.gunClientState.isReloading() && !this.gunClientState.isInspecting() ? maxAngularOffsetCos : DEFAULT_MAX_ANGULAR_RETICLE_OFFSET_NOT_AIMED;
            if (angularOffsetCos > threshold) {
                poseStack.m_85836_();
                float maxOffsetFromTheCenter = 1.0f;
                Player player = ClientUtils.getClientPlayer();
                float smoothFactor = 1.0f;
                Vec3 mv = player.m_20184_();
                if (mv.f_82479_ != 0.0 && mv.f_82481_ != 0.0) {
                    smoothFactor = 0.8f;
                }
                poseStack.m_252880_(Mth.m_14036_((float)(intersectionPoint.x() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), Mth.m_14036_((float)(intersectionPoint.y() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), Mth.m_14036_((float)(intersectionPoint.z() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter));
                float alpha = (float)aimingProgress;
                RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, red, green, blue, alpha);
                poseStack.m_85849_();
            }
        }
    }

    private void renderReticle(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, double aimingProgress) {
        BakedGeoModel reticleBakedGeoModel;
        GeoBone reticleBone;
        if (this.gunClientState != null && !this.gunClientState.isReloading() && !this.gunClientState.isInspecting() && (reticleBone = (GeoBone)(reticleBakedGeoModel = this.getReticleModel()).getBone(BONE_SCOPE).get()) != null) {
            poseStack.m_85836_();
            if (aimingProgress > 0.9 && !this.gunClientState.isReloading()) {
                float alpha = 0.7f;
                this.applyRefTransforms(poseStack, bone, reticleBone);
                double yaw = ClientEventHandler.reticleInertiaController.getYaw();
                double pitch = ClientEventHandler.reticleInertiaController.getPitch();
                Quaternionf q = new Quaternionf(pitch, yaw, 0.0, 1.0);
                poseStack.m_85837_(-yaw * 25.0, pitch * 25.0, -8.0);
                poseStack.m_252781_(q);
                super.renderCubesOfBone(poseStack, reticleBone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
            poseStack.m_85849_();
        }
    }

    private void renderPip(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, float red, float green, float blue, double aimingProgress) {
        List cubes;
        poseStack.m_85836_();
        if (aimingProgress > 0.9 && this.gunClientState != null && (cubes = bone.getCubes()) != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            ClientSystem.getInstance().getAuxLevelRenderer().renderToBuffer(poseStack, northQuad, buffer, packedLight);
        }
        poseStack.m_85849_();
    }

    private void renderPipOverlay(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, float red, float green, float blue, double aimingProgress, boolean isParallaxEnabled) {
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            Vector4f n;
            Vector4f p0;
            Matrix4f modelMatrix;
            Pair<Vector4f, Float> intersection;
            Vector4f intersectionPoint;
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            if (isParallaxEnabled && (intersectionPoint = (Vector4f)(intersection = GunItemRenderer.getPlayerViewIntersection(modelMatrix = this.captureCubeMatrix(poseStack, cube, 3), p0 = new Vector4f(0.0f, 0.0f, 0.01f, 1.0f), n = new Vector4f(0.0f, 0.0f, -1.0f, 1.0f))).getFirst()) != null) {
                float maxOffsetFromTheCenter = 1.0f;
                float smoothFactor = 0.8f;
                poseStack.m_252880_(Mth.m_14036_((float)(intersectionPoint.x() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), Mth.m_14036_((float)(intersectionPoint.y() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter), Mth.m_14036_((float)(intersectionPoint.z() * smoothFactor), (float)(-maxOffsetFromTheCenter), (float)maxOffsetFromTheCenter));
            }
            float alpha = (float)aimingProgress;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 0.001f);
            RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }

    private void renderPipMask(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, float red, float green, float blue, double aimingProgress) {
        List cubes = bone.getCubes();
        if (cubes != null && !cubes.isEmpty()) {
            GeoCube cube = (GeoCube)cubes.get(0);
            GeoQuad northQuad = cube.quads()[3];
            float alpha = (float)aimingProgress;
            poseStack.m_85836_();
            RenderUtil.renderQuad(poseStack, northQuad, buffer, 0.0f, 0.0f, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }

    private void renderLeftArm(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        BakedGeoModel handsBakedGeoModel = this.getLeftHandModel();
        GeoBone leftArmBone = handsBakedGeoModel.getBone(BONE_LEFTARM).orElse(null);
        if (leftArmBone != null) {
            poseStack.m_85836_();
            this.applyArmRefTransforms(poseStack, bone, leftArmBone);
            super.renderCubesOfBone(poseStack, leftArmBone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }

    private void renderRightArm(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        BakedGeoModel handsBakedGeoModel = this.getRightHandModel();
        GeoBone rightArmBone = handsBakedGeoModel.getBone(BONE_RIGHTARM).orElse(null);
        if (rightArmBone != null) {
            poseStack.m_85836_();
            this.applyArmRefTransforms(poseStack, bone, rightArmBone);
            super.renderCubesOfBone(poseStack, rightArmBone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }

    private void captureMuzzlePose(GeoBone refBone, PoseStack poseStack, ItemDisplayContext itemDisplayContext) {
        if (this.gunClientState != null) {
            poseStack.m_85836_();
            GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
            RenderUtils.translateToPivotPoint((PoseStack)poseStack, (GeoCube)refCube);
            RenderUtils.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)refCube);
            RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)refCube);
            poseStack.m_252880_(refBone.getPivotX() / 16.0f, refBone.getPivotY() / 16.0f, refBone.getPivotZ() / 16.0f);
            GunStatePoseProvider gunStatePoseProvider = GunStatePoseProvider.getInstance();
            if (itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                GunStatePoseProvider.PoseContext poseContext = null;
                if (!refBone.getName().equals(BONE_MUZZLE) && !refBone.getName().equals(BONE_MUZZLE2)) {
                    if (refBone.getName().equals(BONE_MUZZLEFLASH) || refBone.getName().equals(BONE_MUZZLEFLASH2)) {
                        poseContext = GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH;
                    }
                } else {
                    poseContext = GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE;
                }
                if (poseContext != null) {
                    gunStatePoseProvider.setPose(this.gunClientState, poseContext, poseStack.m_85850_());
                    this.setCurrentMuzzlePosition(poseStack, poseContext);
                }
            } else if (itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                GunStatePoseProvider.PoseContext poseContext = null;
                if (!refBone.getName().equals(BONE_MUZZLE) && !refBone.getName().equals(BONE_MUZZLE2)) {
                    if (refBone.getName().equals(BONE_MUZZLEFLASH) || refBone.getName().equals(BONE_MUZZLEFLASH2)) {
                        poseContext = GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE_FLASH;
                    }
                } else {
                    poseContext = GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE;
                }
                if (poseContext != null) {
                    gunStatePoseProvider.setPose(this.gunClientState, poseContext, poseStack.m_85850_());
                    this.setCurrentMuzzlePosition(poseStack, poseContext);
                }
            }
            poseStack.m_85849_();
        }
    }

    private void setCurrentMuzzlePosition(PoseStack poseStack, GunStatePoseProvider.PoseContext poseContext) {
        poseStack.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        double fov = ((Integer)mc.f_91066_.m_231837_().m_231551_()).doubleValue();
        Matrix4f fovProjectionMatrix = mc.f_91063_.m_253088_(fov);
        Matrix4f transform = new Matrix4f((Matrix3fc)RenderSystem.getInverseViewRotationMatrix()).mul((Matrix4fc)fovProjectionMatrix.invert()).mul((Matrix4fc)RenderSystem.getProjectionMatrix()).mul((Matrix4fc)poseStack.m_85850_().m_252922_());
        Vector4f relPos = transform.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        Vector4f pos = new Vector4f((Vector4fc)relPos);
        pos.add((float)cameraPos.f_82479_, (float)cameraPos.f_82480_, (float)cameraPos.f_82481_, 1.0f);
        Vector4f direction = transform.transform(new Vector4f(0.0f, 0.0f, -1.0f, 1.0f));
        direction.sub((Vector4fc)relPos);
        direction.normalize();
        GunStatePoseProvider.getInstance().setPositionAndDirection(this.gunClientState, poseContext, new Vec3((double)pos.x, (double)pos.y, (double)pos.z), new Vec3((double)direction.x, (double)direction.y, (double)direction.z));
        poseStack.m_85849_();
    }

    public void renderCubesOfBoneParent(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderCubesOfBoneParent(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, boolean useCustomGlowingTexture, Set<Direction> directions, Supplier<SpriteUVProvider> glowingSpriteUVProviderSupplier, float glowingProgress) {
        boolean hadCustomGlowingTexture = this.useCustomGlowingTexture;
        this.useCustomGlowingTexture = useCustomGlowingTexture;
        this.glowDirections = directions;
        this.glowingSpriteUVProviderSupplier = glowingSpriteUVProviderSupplier;
        this.glowingProgress = glowingProgress;
        super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.glowDirections = null;
        this.useCustomGlowingTexture = hadCustomGlowingTexture;
    }

    public void renderCube(PoseStack poseStack, GeoCube cube, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (GeoCube)cube);
        RenderUtils.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)cube);
        RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)cube);
        Matrix3f normalisedPoseState = poseStack.m_85850_().m_252943_();
        Matrix4f poseState = poseStack.m_85850_().m_252922_();
        for (GeoQuad quad : cube.quads()) {
            if (quad == null || this.glowDirections != null && !this.glowDirections.contains(quad.direction())) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtils.fixInvertedFlatCube((GeoCube)cube, (Vector3f)normal);
            this.createVerticesOfQuad(quad, poseState, normal, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    private void applyArmRefTransforms(PoseStack poseStack, GeoBone refBone, GeoBone leftArmBone) {
        GeoCube leftArmBoneCube = (GeoCube)leftArmBone.getCubes().get(0);
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        GeoVertex leftArmBoneVertex = leftArmBoneCube.quads()[0].vertices()[0];
        GeoVertex refVertex = refCube.quads()[0].vertices()[0];
        float dx = refVertex.position().x() - leftArmBoneVertex.position().x();
        float dy = refVertex.position().y() - leftArmBoneVertex.position().y();
        float dz = refVertex.position().z() - leftArmBoneVertex.position().z();
        poseStack.m_252880_(dx, dy, dz);
    }

    private void applyRefTransforms(PoseStack poseStack, GeoBone refBone, GeoBone actualBone) {
        GeoCube actualArmBoneCube = (GeoCube)actualBone.getCubes().get(0);
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        GeoVertex refQ0v0 = refCube.quads()[2].vertices()[0];
        GeoVertex refQ0v2 = refCube.quads()[2].vertices()[2];
        GeoVertex actualQ0v0 = actualArmBoneCube.quads()[2].vertices()[0];
        GeoVertex actualQ0v2 = actualArmBoneCube.quads()[2].vertices()[2];
        float refSizeX = Math.abs(refQ0v0.position().x - refQ0v2.position().x);
        float actualSizeX = Math.abs(actualQ0v0.position().x - actualQ0v2.position().x);
        float refSizeY = Math.abs(refQ0v0.position().y - refQ0v2.position().y);
        float actualSizeY = Math.abs(actualQ0v0.position().y - actualQ0v2.position().y);
        float refXLeft = refQ0v0.position().x;
        float refZLeft = refQ0v2.position().z;
        float actualXLeft = actualQ0v0.position().x;
        float actualYTop = actualQ0v0.position().y;
        float refYTop = refQ0v0.position().y;
        float actualZLeft = actualQ0v0.position().z;
        float dx = -(actualXLeft + (refXLeft - (refSizeX - actualSizeX) / 2.0f));
        float dy = refYTop + (actualSizeY - refSizeY) / 2.0f - actualYTop;
        float dz = refZLeft - actualZLeft;
        poseStack.m_252880_(dx, dy, dz);
    }

    @Override
    public boolean approveRendering(RenderPass renderPass, String boneName, ItemStack rootStack, ItemStack currentStack, String path, ItemDisplayContext itemDisplayContext) {
        List<Features.EnabledFeature> enabledVisibilityFeatures = Features.getEnabledFeatures(rootStack, PartVisibilityFeature.class);
        ConditionContext conditionContext = new ConditionContext(null, rootStack, currentStack, this.gunClientState, itemDisplayContext);
        for (Features.EnabledFeature enabledVisibilityFeature : enabledVisibilityFeatures) {
            PartVisibilityFeature visibilityFeature = (PartVisibilityFeature)enabledVisibilityFeature.feature();
            if (visibilityFeature.isPartVisible((ItemLike)currentStack.m_41720_(), boneName, conditionContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEffectLayer() {
        return false;
    }

    @Override
    public RenderType getRenderType() {
        return null;
    }

    @Override
    public boolean isSupportedItemDisplayContext(ItemDisplayContext context) {
        return true;
    }

    @Override
    public boolean canRenderPart(String boneName) {
        return !boneName.equals(BONE_LEFTARM) && !boneName.equals(BONE_RIGHTARM) && !boneName.equals(BONE_SCOPE) && !boneName.equals(BONE_RETICLE) && !boneName.equals(BONE_SCOPE_PIP);
    }

    @Override
    public RenderPass getRenderPass() {
        return RenderPass.MAIN_ITEM;
    }

    @Override
    public Class<? extends Feature> getFeatureType() {
        return null;
    }

    private static Pair<Vector4f, Float> getPlayerViewIntersection(Matrix4f modelMatrix, Vector4f p0, Vector4f n) {
        Minecraft mc = Minecraft.m_91087_();
        Player player = ClientUtils.getClientPlayer();
        float partialTicks = mc.getPartialTick();
        Vec3 playerEyePositionRelativeToCamera = new Vec3(0.0, 0.0, 0.0);
        Vec3 playerViewVector = player.m_20252_(partialTicks);
        Matrix4f transform3 = new Matrix4f((Matrix4fc)modelMatrix).invert().mul((Matrix4fc)new Matrix4f((Matrix3fc)RenderSystem.getInverseViewRotationMatrix()).invert());
        double farDistance = 5.0;
        Vec3 farPointWorld = playerEyePositionRelativeToCamera.m_82549_(playerViewVector.m_82490_(farDistance));
        Vector4f eyePositionModel = new Vector4f();
        transform3.transform((float)playerEyePositionRelativeToCamera.f_82479_, (float)playerEyePositionRelativeToCamera.f_82480_, (float)playerEyePositionRelativeToCamera.f_82481_, 1.0f, eyePositionModel);
        Vector4f farPointModel = new Vector4f();
        transform3.transform((float)farPointWorld.f_82479_, (float)farPointWorld.f_82480_, (float)farPointWorld.f_82481_, 1.0f, farPointModel);
        Vector4f l = new Vector4f((Vector4fc)farPointModel).sub((Vector4fc)eyePositionModel).normalize();
        Vector4f p0MinusL0 = new Vector4f(p0.x, p0.y, p0.z, 1.0f).sub((Vector4fc)eyePositionModel);
        float numerator = p0MinusL0.dot(n.x, n.y, n.z, 1.0f);
        float denominator = l.dot(n.x, n.y, n.z, 1.0f);
        Vector4f intersectionPoint = null;
        if (denominator > 0.0f) {
            float d = numerator / denominator;
            intersectionPoint = new Vector4f((Vector4fc)l).mul(d).add((Vector4fc)eyePositionModel);
        }
        return Pair.of(intersectionPoint, (Object)Float.valueOf(denominator));
    }

    public Matrix4f captureCubeMatrix(PoseStack poseStack, GeoCube cube, int side) {
        GeoQuad quad = cube.quads()[side];
        poseStack.m_85836_();
        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (GeoCube)cube);
        RenderUtils.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)cube);
        RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)cube);
        Vector3f v0Pos = quad.vertices()[0].position();
        Vector3f v2Pos = quad.vertices()[2].position();
        poseStack.m_252880_((v0Pos.x + v2Pos.x) * 0.5f, (v0Pos.y + v2Pos.y) * 0.5f, (v0Pos.z + v2Pos.z) * 0.5f);
        Matrix4f cubeMatrix = poseStack.m_85850_().m_252922_();
        poseStack.m_85849_();
        return cubeMatrix;
    }
}

