/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.atomic.AtomicInteger;
import mod.pbj.client.render.DefaultRenderTypeProvider;
import mod.pbj.compat.iris.IrisCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;

public interface RenderTypeProvider {
    public static final RenderType NO_RENDER_TYPE = new RenderType(null, null, null, 0, false, false, null, null){};
    public static final AtomicInteger wrappedCounter = new AtomicInteger();
    public static final Runnable SETUP_STENCIL_MASK_RENDER = () -> {
        GL11.glEnable((int)2960);
        RenderSystem.clear((int)1024, (boolean)Minecraft.f_91002_);
        RenderSystem.clearStencil((int)0);
        RenderSystem.stencilMask((int)255);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.stencilFunc((int)519, (int)1, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
    };
    public static final Runnable CLEAR_STENCIL_MASK_RENDER = () -> {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.stencilMask((int)0);
        GL11.glDisable((int)2960);
    };
    public static final Runnable SETUP_STENCIL_RENDER = () -> {
        GL11.glEnable((int)2960);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
    };
    public static final Runnable CLEAR_STENCIL_RENDER = () -> {
        GL11.glStencilMask((int)255);
        GL11.glDisable((int)2960);
    };

    public static RenderTypeProvider getInstance() {
        IrisCompat irisCompat = IrisCompat.getInstance();
        return irisCompat.isShaderPackEnabled() ? irisCompat.getRenderTypeProvider() : DefaultRenderTypeProvider.getInstance();
    }

    public RenderType getPipRenderType(boolean var1);

    public RenderType getPipOverlayRenderType(ResourceLocation var1, boolean var2);

    public RenderType getPipMaskRenderType(ResourceLocation var1);

    public RenderType getGlowRenderType(ResourceLocation var1);

    public RenderType getMuzzleFlashRenderType(ResourceLocation var1);

    public RenderType getReticleRenderType(ResourceLocation var1, boolean var2);

    public RenderType getGlowBlockEntityRenderType(ResourceLocation var1);

    public static RenderType wrapRenderType(RenderType renderType, Runnable setupRenderState, Runnable clearRenderState) {
        return new RenderType("pointblank:" + String.valueOf(renderType) + ":" + wrappedCounter.incrementAndGet(), renderType.m_110508_(), renderType.m_173186_(), renderType.m_110507_(), renderType.m_110405_(), false, () -> {
            renderType.m_110185_();
            setupRenderState.run();
        }, () -> {
            clearRenderState.run();
            renderType.m_110188_();
        }){};
    }

    default public MultiBufferSource wrapBufferSource(MultiBufferSource source) {
        return renderType -> renderType == NO_RENDER_TYPE ? null : source.m_6299_(renderType);
    }

    default public float getReticleBrightness() {
        return 1.0f;
    }

    default public float getGlowBrightness() {
        return 1.0f;
    }

    public static enum Key {
        MUZZLE_FLASH,
        PIP,
        PIP_OVERLAY,
        RETICLE;

    }
}

