/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.render.HierarchicalRenderContext;
import mod.pbj.client.render.RenderApprover;
import mod.pbj.client.render.RenderPass;
import mod.pbj.client.render.RenderPassGeoRenderer;
import mod.pbj.client.render.RenderPassProvider;
import mod.pbj.client.render.RenderTypeProvider;
import mod.pbj.client.render.layer.GunHandsItemLayer;
import mod.pbj.compat.iris.IrisCompat;
import mod.pbj.feature.Feature;
import mod.pbj.feature.SkinFeature;
import mod.pbj.item.ThrowableItem;
import mod.pbj.mixin.BakedModelMixin;
import mod.pbj.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.SeparateTransformsModel;
import org.joml.Quaternionf;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.ClientUtils;

public class ThrowableItemRenderer
extends GeoItemRenderer<ThrowableItem>
implements RenderPassGeoRenderer<ThrowableItem>,
RenderApprover {
    public static final String BONE_RIGHTARM = "rightarm";
    public static final String BONE_LEFTARM = "leftarm";
    public static final String BONE_CAMERA = "_camera_";
    private ItemTransforms transforms;
    private final ResourceLocation leftHandModelResource = new ResourceLocation("pointblank", "geo/item/left_arm.geo.json");
    private final ResourceLocation rightHandModelResource = new ResourceLocation("pointblank", "geo/item/right_arm.geo.json");

    public ThrowableItemRenderer(ResourceLocation modelResource) {
        super((GeoModel)new DefaultedItemGeoModel(modelResource));
        this.addRenderLayer(new GunHandsItemLayer<ThrowableItem>(this));
    }

    public ResourceLocation getTextureLocation(ThrowableItem animatable) {
        ResourceLocation texture = null;
        HierarchicalRenderContext hrc = HierarchicalRenderContext.getRoot();
        if (hrc != null) {
            ItemStack itemStack = hrc.getItemStack();
            texture = SkinFeature.getTexture(itemStack);
        }
        if (texture == null) {
            texture = super.getTextureLocation((Item)animatable);
        }
        return texture;
    }

    @Override
    public GeoRenderer<ThrowableItem> getRenderer() {
        return this;
    }

    private BakedGeoModel getLeftHandModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.leftHandModelResource);
    }

    private BakedGeoModel getRightHandModel() {
        return (BakedGeoModel)GeckoLibCache.getBakedModels().get(this.rightHandModelResource);
    }

    private Player getPlayer(ItemDisplayContext itemDisplayContext) {
        if (itemDisplayContext != ItemDisplayContext.FIRST_PERSON_LEFT_HAND && itemDisplayContext != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && itemDisplayContext != ItemDisplayContext.GROUND) {
            LivingEntity renderedEntity = ClientEventHandler.getCurrentEntityLiving();
            return renderedEntity instanceof Player ? (Player)renderedEntity : null;
        }
        return ClientUtils.getClientPlayer();
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Player player;
        if (!IrisCompat.getInstance().isRenderingShadows() && (player = this.getPlayer(itemDisplayContext)) != null) {
            MultiBufferSource wrappedBufferSource = RenderTypeProvider.getInstance().wrapBufferSource(bufferSource);
            try (HierarchicalRenderContext hrc = HierarchicalRenderContext.push(stack, itemDisplayContext);){
                this.renderPass(() -> {
                    boolean isFirstPerson = itemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                    poseStack.m_85836_();
                    ThrowableItem gunItem = (ThrowableItem)stack.m_41720_();
                    GeoModel geoModel = this.getGeoModel();
                    if (isFirstPerson) {
                        this.initTransforms(player, stack, itemDisplayContext);
                        this.adjustFirstPersonPose(stack, gunItem, poseStack, (GeoModel<ThrowableItem>)geoModel);
                    }
                    super.m_108829_(stack, itemDisplayContext, poseStack, wrappedBufferSource, packedLight, packedOverlay);
                    poseStack.m_85849_();
                });
            }
        }
    }

    @Override
    public void renderPass(Runnable runnablePass) {
        RenderPass.push(this.getRenderPass());
        try {
            runnablePass.run();
        }
        finally {
            RenderPass.pop();
        }
    }

    private void adjustFirstPersonPose(ItemStack itemStack, ThrowableItem throwableItem, PoseStack poseStack, GeoModel<ThrowableItem> geoModel) {
        ItemTransform fprt;
        if (this.transforms != null && (fprt = this.transforms.f_111790_) != null) {
            float rescale = throwableItem.getModelScale();
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(new Quaternionf().rotationXYZ(-fprt.f_111755_.x * ((float)Math.PI / 180), -fprt.f_111755_.y * ((float)Math.PI / 180), -fprt.f_111755_.z * ((float)Math.PI / 180)));
            poseStack.m_252880_(-fprt.f_111756_.x, -fprt.f_111756_.y, -fprt.f_111756_.z);
            poseStack.m_252880_(fprt.f_111756_.x * rescale, fprt.f_111756_.y * rescale, fprt.f_111756_.z * rescale);
            poseStack.m_252781_(new Quaternionf().rotationXYZ(fprt.f_111755_.x * ((float)Math.PI / 180), fprt.f_111755_.y * ((float)Math.PI / 180), fprt.f_111755_.z * ((float)Math.PI / 180)));
            poseStack.m_85841_(rescale, rescale, rescale);
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            poseStack.m_252880_(0.48f, -1.12f, -0.72f);
            poseStack.m_252880_(-0.006f, 0.6f, 0.0f);
        }
    }

    private void initTransforms(Player player, ItemStack stack, ItemDisplayContext itemDisplayContext) {
        if (this.transforms == null) {
            Minecraft minecraft = Minecraft.m_91087_();
            BakedModel bakedModel = minecraft.m_91291_().m_174264_(stack, MiscUtil.getLevel((Entity)player), (LivingEntity)player, player.m_19879_() + itemDisplayContext.ordinal());
            if (bakedModel instanceof SeparateTransformsModel.Baked) {
                BakedModel baseModel = ((BakedModelMixin)bakedModel).getBaseModel();
                this.transforms = baseModel.m_7442_();
            } else {
                this.transforms = bakedModel.m_7442_();
            }
        }
    }

    private boolean shouldRenderBone(String boneName) {
        if (boneName.charAt(0) == '_') {
            return false;
        }
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        ItemStack rootStack = HierarchicalRenderContext.getRoot().getItemStack();
        boolean shouldRender = true;
        for (GeoRenderLayer layer : this.getRenderLayers()) {
            RenderPass renderPass;
            RenderPass var10000;
            if (!(layer instanceof RenderApprover)) continue;
            RenderApprover renderApprover = (RenderApprover)layer;
            if (layer instanceof RenderPassProvider) {
                RenderPassProvider rp = (RenderPassProvider)layer;
                var10000 = rp.getRenderPass();
            } else {
                var10000 = null;
            }
            if (renderApprover.approveRendering(renderPass = var10000, boneName, rootStack, current.getItemStack(), current.getPath(), current.getItemDisplayContext())) continue;
            shouldRender = false;
            break;
        }
        return shouldRender;
    }

    public void renderRecursively(PoseStack poseStack, ThrowableItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        ItemStack rootStack = HierarchicalRenderContext.getRoot().getItemStack();
        boolean shouldRender = this.approveRendering(this.getRenderPass(), bone.getName(), rootStack, current.getItemStack(), current.getPath(), current.getItemDisplayContext());
        if (shouldRender) {
            super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    public void renderCubesOfBone(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderPass renderPass = RenderPass.current();
        if (this.shouldRenderBone(bone.getName())) {
            switch (renderPass) {
                case HANDS: {
                    if (bone.getName().equals(BONE_RIGHTARM)) {
                        this.renderRightArm(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                        break;
                    }
                    if (!bone.getName().equals(BONE_LEFTARM)) break;
                    this.renderLeftArm(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    break;
                }
                case MAIN_ITEM: {
                    if (!this.canRenderPart(bone.getName())) break;
                    super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)renderPass));
                }
            }
        }
    }

    private void renderLeftArm(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        BakedGeoModel handsBakedGeoModel = this.getLeftHandModel();
        GeoBone leftArmBone = handsBakedGeoModel.getBone(BONE_LEFTARM).orElse(null);
        if (leftArmBone != null) {
            poseStack.m_85836_();
            this.applyArmRefTransforms(poseStack, bone, leftArmBone);
            super.renderCubesOfBone(poseStack, leftArmBone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }

    private void renderRightArm(PoseStack poseStack, GeoBone bone, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        BakedGeoModel handsBakedGeoModel = this.getRightHandModel();
        GeoBone rightArmBone = handsBakedGeoModel.getBone(BONE_RIGHTARM).orElse(null);
        if (rightArmBone != null) {
            poseStack.m_85836_();
            this.applyArmRefTransforms(poseStack, bone, rightArmBone);
            super.renderCubesOfBone(poseStack, rightArmBone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }

    private void applyArmRefTransforms(PoseStack poseStack, GeoBone refBone, GeoBone leftArmBone) {
        GeoCube leftArmBoneCube = (GeoCube)leftArmBone.getCubes().get(0);
        GeoCube refCube = (GeoCube)refBone.getCubes().get(0);
        GeoVertex leftArmBoneVertex = leftArmBoneCube.quads()[0].vertices()[0];
        GeoVertex refVertex = refCube.quads()[0].vertices()[0];
        float dx = refVertex.position().x() - leftArmBoneVertex.position().x();
        float dy = refVertex.position().y() - leftArmBoneVertex.position().y();
        float dz = refVertex.position().z() - leftArmBoneVertex.position().z();
        poseStack.m_252880_(dx, dy, dz);
    }

    @Override
    public boolean isEffectLayer() {
        return false;
    }

    @Override
    public RenderType getRenderType() {
        return null;
    }

    @Override
    public boolean isSupportedItemDisplayContext(ItemDisplayContext context) {
        return true;
    }

    @Override
    public boolean canRenderPart(String boneName) {
        return !boneName.equals(BONE_LEFTARM) && !boneName.equals(BONE_RIGHTARM);
    }

    @Override
    public RenderPass getRenderPass() {
        return RenderPass.MAIN_ITEM;
    }

    @Override
    public Class<? extends Feature> getFeatureType() {
        return null;
    }
}

