/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.attachment.AttachmentModelInfo;
import mod.pbj.attachment.Attachments;
import mod.pbj.client.GunClientState;
import mod.pbj.client.gui.AttachmentManagerScreen;
import mod.pbj.client.render.HierarchicalRenderContext;
import mod.pbj.client.render.RenderApprover;
import mod.pbj.client.render.RenderPass;
import mod.pbj.client.render.RenderPassGeoRenderer;
import mod.pbj.client.render.RenderPassRenderer;
import mod.pbj.client.render.layer.FeaturePassLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class AttachmentLayer<T extends GeoAnimatable>
extends FeaturePassLayer<T> {
    private static final Vector4f COLOR_GREEN = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
    private static final Vector4f COLOR_NORMAL = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private RenderPassRenderer<T> currentRenderer;
    private final RenderPassGeoRenderer<T> mainRenderer;

    public AttachmentLayer(RenderPassGeoRenderer<T> renderer) {
        super(renderer, null, RenderPass.ATTACHMENTS, ALL_PARTS, true, null);
        this.mainRenderer = renderer;
    }

    @Override
    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (animatable instanceof AttachmentHost) {
            ItemStack rootStack = HierarchicalRenderContext.current().getItemStack();
            this.currentRenderer = this.mainRenderer;
            this.renderPass(() -> {
                this.renderAttachments(null, null, animatable, "/", rootStack, poseStack, bufferSource, buffer, partialTick, packedLight, packedOverlay);
                for (GeoRenderLayer effectLayer : this.mainRenderer.getRenderLayers()) {
                    GunClientState state;
                    RenderPassRenderer renderPassRenderer;
                    if (effectLayer == this || !(effectLayer instanceof RenderPassRenderer) || !(renderPassRenderer = (RenderPassRenderer)effectLayer).isEffectLayer() || (state = GunClientState.getMainHeldState()) == null) continue;
                    renderPassRenderer.renderPass(() -> {
                        this.currentRenderer = renderPassRenderer;
                        this.renderAttachments(state, null, animatable, "/", rootStack, poseStack, bufferSource, buffer, partialTick, packedLight, packedOverlay);
                        this.currentRenderer = null;
                    });
                }
            });
        }
    }

    public void renderAttachments(GunClientState state, RenderType renderTypeOverride, T gunItem, String parentPath, ItemStack baseItemStack, PoseStack poseStack, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        Item attachmentItemStacks = baseItemStack.m_41720_();
        if (attachmentItemStacks instanceof AttachmentHost) {
            AttachmentHost attachmentHost = (AttachmentHost)attachmentItemStacks;
            for (ItemStack attachmentItemStack : Attachments.getAttachments(baseItemStack)) {
                Item item = attachmentItemStack.m_41720_();
                if (!(item instanceof Attachment)) continue;
                Attachment attachment = (Attachment)item;
                AttachmentModelInfo.attachmentInfos.apply(attachmentHost, attachment).ifPresent(attachmentInfo -> this.renderAttachment(state, renderTypeOverride, gunItem, parentPath, baseItemStack, attachmentInfo.baseModel(), attachmentInfo.baseBone(), attachmentItemStack, attachmentInfo.attachmentModel(), attachmentInfo.attachmentBone(), poseStack, bufferSource, buffer, partialTick, packedLight, packedOverlay));
            }
        }
    }

    protected void renderAttachment(GunClientState state, RenderType renderTypeOverride, T gunItem, String parentPath, ItemStack baseItemStack, BakedGeoModel baseModel, CoreGeoBone baseBone, ItemStack attachmentItemStack, BakedGeoModel attachmentModel, CoreGeoBone attachmentBone, PoseStack poseStack, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        Item itemDisplayContext = attachmentItemStack.m_41720_();
        if (itemDisplayContext instanceof Attachment) {
            Attachment attachment = (Attachment)itemDisplayContext;
            ItemDisplayContext var28 = HierarchicalRenderContext.current().getItemDisplayContext();
            try (HierarchicalRenderContext hrc = HierarchicalRenderContext.push(attachmentItemStack, var28);){
                String attachmentPath = parentPath + "/" + attachment.getName();
                Pair basePos = AttachmentModelInfo.modelBonePositions.apply(new AttachmentModelInfo.ModelBoneKey(baseModel, baseBone.getName(), 1.0f)).orElse(null);
                Pair attachmentPos = AttachmentModelInfo.modelBonePositions.apply(new AttachmentModelInfo.ModelBoneKey(attachmentModel, attachmentBone.getName(), 1.0f)).orElse(null);
                if (basePos != null && attachmentPos != null) {
                    RenderType attachmentRenderType = null;
                    Vector4f color = COLOR_NORMAL;
                    if (renderTypeOverride == null) {
                        Pair<RenderType, Vector4f> p = this.getRenderType(baseItemStack, attachmentItemStack, attachment.getName(), attachmentPath, var28);
                        attachmentRenderType = (RenderType)p.getFirst();
                        color = (Vector4f)p.getSecond();
                    } else {
                        attachmentRenderType = renderTypeOverride;
                        color = COLOR_GREEN;
                    }
                    if (attachmentRenderType != null) {
                        poseStack.m_85836_();
                        AttachmentModelInfo.preparePoseStackForBoneInHierarchy(poseStack, baseBone);
                        poseStack.m_252931_((Matrix4f)basePos.getFirst());
                        poseStack.m_252931_((Matrix4f)attachmentPos.getSecond());
                        this.currentRenderer.render(attachmentModel, poseStack, bufferSource, gunItem, attachmentRenderType, bufferSource.m_6299_(attachmentRenderType), partialTick, packedLight, OverlayTexture.f_118083_, color.x, color.y, color.z, color.w);
                        this.renderAttachments(state, renderTypeOverride, gunItem, attachmentPath, attachmentItemStack, poseStack, bufferSource, buffer, partialTick, packedLight, packedOverlay);
                        poseStack.m_85849_();
                    }
                }
            }
        }
    }

    private Pair<RenderType, Vector4f> getRenderType(ItemStack baseItemStack, ItemStack attachmentItemStack, String attachmentName, String attachmentPath, ItemDisplayContext itemDisplayContext) {
        AttachmentManagerScreen ams;
        Pair<RenderType, Vector4f> p;
        Screen screen;
        RenderType renderType = null;
        ResourceLocation texture = new ResourceLocation("pointblank", "textures/item/" + attachmentName + ".png");
        Vector4f color = null;
        Minecraft mc = Minecraft.m_91087_();
        if (itemDisplayContext == ItemDisplayContext.GROUND && (screen = mc.f_91080_) instanceof AttachmentManagerScreen && (p = (ams = (AttachmentManagerScreen)screen).getRenderTypeOverride(baseItemStack, attachmentItemStack, attachmentName, attachmentPath)) != null) {
            renderType = (RenderType)p.getFirst();
            color = (Vector4f)p.getSecond();
        }
        if (renderType == null) {
            renderType = this.currentRenderer.getRenderType();
        }
        if (renderType == null) {
            renderType = RenderType.m_110458_((ResourceLocation)texture);
        }
        if (color == null) {
            color = COLOR_NORMAL;
        }
        return Pair.of((Object)renderType, (Object)color);
    }

    @Override
    public boolean approveRendering(RenderPass renderPass, String boneName, ItemStack rootStack, ItemStack currentStack, String path, ItemDisplayContext itemDisplayContext) {
        if (renderPass == RenderPass.ATTACHMENTS) {
            return true;
        }
        HierarchicalRenderContext hrc = HierarchicalRenderContext.current();
        Item category = hrc.getItemStack().m_41720_();
        if (category instanceof Attachment) {
            Attachment currentAttachment = (Attachment)category;
            AttachmentCategory var13 = currentAttachment.getCategory();
            Pair<String, ItemStack> activeCategoryAttachment = Attachments.getSelectedAttachment(rootStack, var13);
            if (activeCategoryAttachment != null && !Objects.equals(activeCategoryAttachment.getFirst(), hrc.getPath())) {
                return false;
            }
            RenderPassRenderer<T> var12 = this.currentRenderer;
            if (var12 instanceof RenderApprover) {
                RenderApprover renderApprover = (RenderApprover)((Object)var12);
                return renderApprover.approveRendering(renderPass, boneName, rootStack, currentStack, path, itemDisplayContext);
            }
            return true;
        }
        return true;
    }

    @Override
    public RenderType getRenderType() {
        return null;
    }

    @Override
    public boolean isSupportedItemDisplayContext(ItemDisplayContext context) {
        return context != ItemDisplayContext.GUI;
    }
}

