/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import mod.pbj.client.render.GunItemRenderer;
import mod.pbj.client.render.HierarchicalRenderContext;
import mod.pbj.client.render.RenderPass;
import mod.pbj.client.render.RenderTypeProvider;
import mod.pbj.client.render.layer.FeaturePassLayer;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.ReticleFeature;
import mod.pbj.item.GunItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class ReticleItemLayer
extends FeaturePassLayer<GunItem> {
    public static final String HRC_ATTRIBUTE_PARALLAX_ENABLED = "is_parallax_enabled";
    public static final String HRC_ATTRIBUTE_MAX_ANGULAR_OFFSET_COS = "max_angular_offset_cos";

    public ReticleItemLayer(GunItemRenderer renderer) {
        super(renderer, ReticleFeature.class, RenderPass.RETICLE, List.of("scope", "reticle"), true, null);
    }

    @Override
    public void render(BakedGeoModel attachmentModel, PoseStack poseStack, MultiBufferSource bufferSource, GunItem animatable, RenderType origRenderType, VertexConsumer origBuffer, float partialTick, int packedLight, int overlay, float red, float green, float blue, float alpha) {
        FeatureProvider fp;
        Item var19;
        boolean isParallaxEnabled = false;
        float maxAngularOffsetCos = ReticleFeature.DEFAULT_MAX_ANGULAR_OFFSET_COS;
        RenderType renderType = null;
        ReticleFeature feature = null;
        HierarchicalRenderContext hrc = HierarchicalRenderContext.current();
        if (hrc != null && (var19 = hrc.getItemStack().m_41720_()) instanceof FeatureProvider && (feature = (fp = (FeatureProvider)var19).getFeature(ReticleFeature.class)) != null && feature.isEnabled(hrc.getItemStack())) {
            isParallaxEnabled = feature.isParallaxEnabled();
            maxAngularOffsetCos = feature.getMaxAngularOffsetCos();
            RenderTypeProvider renderTypeProvider = RenderTypeProvider.getInstance();
            ResourceLocation reticleTexture = feature.getTexture();
            if (feature.hasFunction("getReticleTexture")) {
                reticleTexture = (ResourceLocation)feature.invokeFunction("getReticleTexture", hrc.getItemStack(), feature);
            }
            renderType = renderTypeProvider.getReticleRenderType(reticleTexture, isParallaxEnabled);
        }
        if (renderType != null) {
            VertexConsumer buffer = bufferSource.m_6299_(renderType);
            RenderTypeProvider renderTypeProvider = RenderTypeProvider.getInstance();
            float reticleBrightness = renderTypeProvider.getReticleBrightness();
            try (HierarchicalRenderContext subHrc = HierarchicalRenderContext.push();){
                subHrc.setAttribute(HRC_ATTRIBUTE_PARALLAX_ENABLED, isParallaxEnabled);
                subHrc.setAttribute(HRC_ATTRIBUTE_MAX_ANGULAR_OFFSET_COS, Float.valueOf(maxAngularOffsetCos));
                if (feature.hasFunction("renderReticleBefore")) {
                    feature.invokeFunction("renderReticleBefore", feature, attachmentModel, poseStack, bufferSource, animatable, renderType, buffer, Float.valueOf(partialTick), packedLight, Float.valueOf(reticleBrightness));
                }
                super.render(attachmentModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, buffer, partialTick, packedLight, overlay, reticleBrightness, reticleBrightness, reticleBrightness, 1.0f);
                if (feature.hasFunction("renderReticleAfter")) {
                    feature.invokeFunction("renderReticleAfter", feature, attachmentModel, poseStack, bufferSource, animatable, renderType, buffer, Float.valueOf(partialTick), packedLight, Float.valueOf(reticleBrightness));
                }
            }
        }
    }

    @Override
    public RenderType getRenderType() {
        return RenderTypeProvider.NO_RENDER_TYPE;
    }

    @Override
    public boolean isSupportedItemDisplayContext(ItemDisplayContext context) {
        return context == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || context == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
    }

    public static boolean isParallaxEnabled() {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        Boolean isParallaxEnabled = (Boolean)current.getAttribute(HRC_ATTRIBUTE_PARALLAX_ENABLED);
        return isParallaxEnabled != null && isParallaxEnabled != false;
    }
}

