/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.uv;

import mod.pbj.client.uv.SpriteUVProvider;

public class LoopingSpriteUVProvider
implements SpriteUVProvider {
    private final int totalSprites;
    private final double spriteFrameDurationMillis;
    private final int rows;
    private final int columns;
    private final long lifetimeMillis;

    public LoopingSpriteUVProvider(int rows, int columns, int spritesPerSecond, long lifetimeMillis) {
        this.rows = rows;
        this.columns = columns;
        this.totalSprites = rows * columns;
        this.spriteFrameDurationMillis = 1000.0 / (double)spritesPerSecond;
        this.lifetimeMillis = lifetimeMillis;
    }

    public int getSpriteIndex(float progress) {
        double elapsedTimeMillis = progress * (float)this.lifetimeMillis;
        int elapsedSprites = (int)(elapsedTimeMillis / this.spriteFrameDurationMillis);
        return elapsedSprites % this.totalSprites;
    }

    @Override
    public float[] getSpriteUV(float progress) {
        int spriteIndex = this.getSpriteIndex(progress);
        return SpriteUVProvider.getSpriteUV(spriteIndex, this.rows, this.columns);
    }
}

