/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.compat.iris;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.FileNotFoundException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.pbj.client.ClientSystem;
import mod.pbj.client.render.Flushable;
import mod.pbj.client.render.RenderTypeProvider;
import mod.pbj.compat.iris.IrisAuxShaderProvider;
import net.irisshaders.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class IrisRenderTypeProvider
extends RenderStateShard
implements RenderTypeProvider {
    private final Function<Boolean, RenderType> pipRenderTypes = Util.m_143827_(this::createPipRenderType);
    private final Function<ResourceLocation, RenderType> pipMaskRenderTypes = Util.m_143827_(texture -> this.createPipMaskRenderType(IrisRenderTypeProvider.getIrisTexture(texture), this::getPipMaskShader));
    private final Function<ResourceLocation, RenderType> pipOverlayRenderTypes = Util.m_143827_(texture -> IrisRenderTypeProvider.createPipOverlayRenderType(IrisRenderTypeProvider.getIrisTexture(texture), GameRenderer::m_172820_, false));
    private final Function<ResourceLocation, RenderType> pipOverlayMaskedRenderTypes = Util.m_143827_(texture -> IrisRenderTypeProvider.createPipOverlayRenderType(IrisRenderTypeProvider.getIrisTexture(texture), this::getPipOverlayShader, true));
    private final Function<ResourceLocation, RenderType> reticleRenderTypes = Util.m_143827_(texture -> IrisRenderTypeProvider.createReticleRenderType(IrisRenderTypeProvider.getIrisTexture(texture)));
    private final Function<ResourceLocation, RenderType> reticleRenderTypesWithParallax = Util.m_143827_(texture -> IrisRenderTypeProvider.createReticleRenderType(IrisRenderTypeProvider.getIrisTexture(texture), GameRenderer::m_172820_));
    private final Function<ResourceLocation, RenderType> glowRenderTypes = Util.m_143827_(texture -> GlowRenderType.createRenderType(IrisRenderTypeProvider.getIrisTexture(texture)));

    public IrisRenderTypeProvider() {
        super(null, null, null);
    }

    @Override
    public MultiBufferSource wrapBufferSource(MultiBufferSource source) {
        return new WrappedBufferSource(source);
    }

    @Override
    public RenderType getPipRenderType(boolean isMasked) {
        return this.pipRenderTypes.apply(isMasked);
    }

    private ShaderInstance getPipShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        ShaderInstance shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankAuxShader();
        }
        if (shader == null) {
            shader = GameRenderer.m_172820_();
        }
        return shader;
    }

    private ShaderInstance getPipOverlayShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        ShaderInstance shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankAuxPlainShader();
        }
        if (shader == null) {
            shader = GameRenderer.m_172820_();
        }
        return shader;
    }

    private ShaderInstance getPipMaskShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        ShaderInstance shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankMaskShader();
        }
        if (shader == null) {
            shader = GameRenderer.m_172820_();
        }
        return shader;
    }

    @Override
    public RenderType getPipOverlayRenderType(ResourceLocation texture, boolean isMasked) {
        return isMasked ? this.pipOverlayMaskedRenderTypes.apply(texture) : this.pipOverlayRenderTypes.apply(texture);
    }

    @Override
    public RenderType getPipMaskRenderType(ResourceLocation texture) {
        return this.pipMaskRenderTypes.apply(texture);
    }

    @Override
    public RenderType getGlowRenderType(ResourceLocation texture) {
        return this.glowRenderTypes.apply(texture);
    }

    @Override
    public RenderType getGlowBlockEntityRenderType(ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }

    @Override
    public RenderType getMuzzleFlashRenderType(ResourceLocation texture) {
        return RenderType.m_234338_((ResourceLocation)texture);
    }

    @Override
    public RenderType getReticleRenderType(ResourceLocation texture, boolean isParallaxEnabled) {
        return isParallaxEnabled ? this.reticleRenderTypesWithParallax.apply(texture) : this.reticleRenderTypes.apply(texture);
    }

    private static ResourceLocation getIrisTexture(ResourceLocation originalTexture) {
        Minecraft mc = Minecraft.m_91087_();
        ResourceManager resourceManager = mc.m_91098_();
        String path = originalTexture.m_135815_();
        if (path.endsWith(".png")) {
            String modifiedPath = path.replace(".png", "_iris.png");
            ResourceLocation irisTexture = new ResourceLocation(originalTexture.m_135827_(), modifiedPath);
            try {
                resourceManager.m_215593_(irisTexture);
                return irisTexture;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return originalTexture;
    }

    private static RenderType createReticleRenderType(ResourceLocation texture, Supplier<ShaderInstance> shaderSupplier) {
        VertexFormat var10001 = DefaultVertexFormat.f_85819_;
        VertexFormat.Mode var10002 = VertexFormat.Mode.QUADS;
        RenderType.CompositeState.CompositeStateBuilder var10006 = RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110153_).m_110677_(f_110155_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false));
        Objects.requireNonNull(shaderSupplier);
        return RenderType.m_173215_((String)"pointblank:reticle_iris_with_parallax", (VertexFormat)var10001, (VertexFormat.Mode)var10002, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)var10006.m_173292_(new RenderStateShard.ShaderStateShard(shaderSupplier)).m_110691_(false));
    }

    private static RenderType createReticleRenderType(ResourceLocation texture) {
        RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(f_234323_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110691_(true);
        return RenderType.m_173215_((String)"pointblank:reticle_iris", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState);
    }

    private RenderType createPipRenderType(boolean isMasked) {
        RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(this::getPipShader)).m_173290_((RenderStateShard.EmptyTextureStateShard)new PipTextureStateShard()).m_110685_(f_110134_).m_110671_(f_110153_).m_110677_(f_110155_).m_110691_(true);
        Runnable setup = isMasked ? SETUP_STENCIL_RENDER : () -> {};
        Runnable clear = isMasked ? CLEAR_STENCIL_RENDER : () -> {};
        return RenderTypeProvider.wrapRenderType((RenderType)RenderType.m_173215_((String)("pointblank:pip_iris_" + isMasked), (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState), setup, clear);
    }

    private RenderType createPipMaskRenderType(ResourceLocation maskTexture, Supplier<ShaderInstance> shaderSupplier) {
        VertexFormat var10001 = DefaultVertexFormat.f_85819_;
        VertexFormat.Mode var10002 = VertexFormat.Mode.QUADS;
        RenderType.CompositeState.CompositeStateBuilder var10006 = RenderType.CompositeState.m_110628_().m_110663_(f_110111_).m_110671_(f_110153_).m_110677_(f_110155_).m_110685_(f_110134_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(maskTexture, false, false));
        Objects.requireNonNull(shaderSupplier);
        return RenderTypeProvider.wrapRenderType((RenderType)RenderType.m_173215_((String)"pointblank:pip_mask_iris", (VertexFormat)var10001, (VertexFormat.Mode)var10002, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)var10006.m_173292_(new RenderStateShard.ShaderStateShard(shaderSupplier)).m_110691_(false)), RenderTypeProvider.SETUP_STENCIL_MASK_RENDER, RenderTypeProvider.CLEAR_STENCIL_MASK_RENDER);
    }

    private static RenderType createPipOverlayRenderType(ResourceLocation overlayTexture, Supplier<ShaderInstance> shaderSupplier, boolean isMasked) {
        Runnable setup = isMasked ? SETUP_STENCIL_RENDER : () -> {};
        Runnable clear = isMasked ? CLEAR_STENCIL_RENDER : () -> {};
        String var10000 = "pointblank:pip_overlay_iris_" + isMasked;
        VertexFormat var10001 = DefaultVertexFormat.f_85819_;
        VertexFormat.Mode var10002 = VertexFormat.Mode.QUADS;
        RenderType.CompositeState.CompositeStateBuilder var10006 = RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110153_).m_110677_(f_110155_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(overlayTexture, false, false));
        Objects.requireNonNull(shaderSupplier);
        return RenderTypeProvider.wrapRenderType((RenderType)RenderType.m_173215_((String)var10000, (VertexFormat)var10001, (VertexFormat.Mode)var10002, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)var10006.m_173292_(new RenderStateShard.ShaderStateShard(shaderSupplier)).m_110691_(false)), setup, clear);
    }

    @Override
    public float getReticleBrightness() {
        return 0.6f;
    }

    @Override
    public float getGlowBrightness() {
        return 0.6f;
    }

    private record WrappedBufferSource(MultiBufferSource delegate) implements MultiBufferSource,
    Flushable
    {
        @Override
        public void flush() {
            MultiBufferSource multiBufferSource = this.delegate;
            if (multiBufferSource instanceof FullyBufferedMultiBufferSource) {
                FullyBufferedMultiBufferSource fbmbs = (FullyBufferedMultiBufferSource)multiBufferSource;
                fbmbs.m_109911_();
            }
        }

        public VertexConsumer m_6299_(RenderType renderType) {
            return renderType == RenderTypeProvider.NO_RENDER_TYPE ? null : this.delegate.m_6299_(renderType);
        }
    }

    private static class PipTextureStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        public PipTextureStateShard() {
            super(() -> {
                int textureId = ClientSystem.getInstance().getAuxLevelRenderer().getRenderTarget().m_83975_();
                RenderSystem.setShaderTexture((int)0, (int)textureId);
            }, () -> {});
        }
    }

    private static final class GlowRenderType
    extends RenderType {
        public GlowRenderType(String renderTypeName, VertexFormat vertexFormat, VertexFormat.Mode mode, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
            super(renderTypeName, vertexFormat, mode, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
        }

        private static RenderType createRenderType(ResourceLocation glowTexture) {
            return RenderType.m_173215_((String)"pointblank:glow_iris", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110152_).m_110677_(f_110155_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(glowTexture, false, false)).m_173292_(RenderStateShard.f_234323_).m_110691_(false));
        }
    }
}

