/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.compat.playeranimator;

import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import mod.pbj.item.GunItem;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib.util.ClientUtils;

public enum PlayerAnimationPartGroup {
    ARMS("arms", p -> new ModifierLayer()),
    LEGS("legs", p -> new ModifierLayer()),
    TORSO("torso", p -> new ModifierLayer()),
    HEAD("head", p -> new ModifierLayer()),
    BODY("body", p -> new ModifierLayer()),
    AUX("aux", p -> new ModifierLayer(null, new AbstractModifier[]{new AdjustmentModifier(bodyPart -> PlayerAnimationPartGroup.correctRotation((Player)p, bodyPart))}));

    private final String name;
    private final ResourceLocation resourceLocation;
    private final PlayerAnimationFactory playerAnimationFactory;
    private static final Set<String> ROTATED_PARTS;

    private PlayerAnimationPartGroup(String name, PlayerAnimationFactory playerAnimationFactory) {
        this.name = name;
        this.playerAnimationFactory = playerAnimationFactory;
        this.resourceLocation = new ResourceLocation("pointblank", this.name().toLowerCase(Locale.ROOT));
    }

    String getGroupName() {
        return this.name;
    }

    ResourceLocation getLayerResource() {
        return this.resourceLocation;
    }

    public static PlayerAnimationPartGroup fromName(String name) {
        return PlayerAnimationPartGroup.valueOf(name.toUpperCase(Locale.ROOT));
    }

    public PlayerAnimationFactory getAnimationFactory() {
        return this.playerAnimationFactory;
    }

    private static Optional<AdjustmentModifier.PartModifier> correctRotation(Player player, String partName) {
        Minecraft mc = Minecraft.m_91087_();
        Player mainPlayer = ClientUtils.getClientPlayer();
        if (player == mainPlayer && mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON && mc.f_91080_ == null && mainPlayer.m_21205_().m_41720_() instanceof GunItem && ROTATED_PARTS.contains(partName)) {
            float partialTicks = mc.getPartialTick();
            float pitch = player.m_5686_(partialTicks) * ((float)Math.PI / 180);
            float yawDelta = Mth.m_14189_((float)partialTicks, (float)(player.f_20886_ - player.f_20884_), (float)(player.f_20885_ - player.f_20883_));
            float yaw = -yawDelta * ((float)Math.PI / 180);
            if (partName.equals("body")) {
                return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0.0f, yaw, 0.0f), Vec3f.ZERO));
            }
            if (partName.equals("head")) {
                return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch, 0.0f, 0.0f), Vec3f.ZERO));
            }
            if (partName.equals("leftArm") || partName.equals("rightArm")) {
                return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch, 0.0f, 0.0f), Vec3f.ZERO));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    static {
        ROTATED_PARTS = Set.of("head", "leftArm", "rightArm", "body");
    }
}

