/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.compat.playeranimator;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.gson.AnimationSerializing;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import mod.pbj.compat.playeranimator.PlayerAnimation;
import mod.pbj.compat.playeranimator.PlayerAnimationPartGroup;
import mod.pbj.compat.playeranimator.PlayerAnimationPreprocessor;
import mod.pbj.compat.playeranimator.PlayerAnimationRegistry;
import mod.pbj.compat.playeranimator.PlayerAnimationType;

public class PlayerAnimationRegistryImpl
implements PlayerAnimationRegistry<KeyframeAnimation> {
    private static final Gson GSON = new Gson();
    private static final String ATTR_NAME = "name";
    static final KeyframeAnimation AUX_ANIMATION = PlayerAnimationRegistryImpl.createAux();
    private final Map<String, Map<PlayerAnimationType, List<PlayerAnimation<KeyframeAnimation>>>> registeredAnimations = new HashMap<String, Map<PlayerAnimationType, List<PlayerAnimation<KeyframeAnimation>>>>();
    private final Map<String, List<Supplier<Reader>>> registrations = new HashMap<String, List<Supplier<Reader>>>();

    PlayerAnimationRegistryImpl() {
    }

    @Override
    public void reload() {
        this.registeredAnimations.clear();
        for (Map.Entry<String, List<Supplier<Reader>>> stringListEntry : this.registrations.entrySet()) {
            for (Supplier<Reader> o : stringListEntry.getValue()) {
                this.read(stringListEntry.getKey(), o);
            }
        }
    }

    @Override
    public boolean isRegistered(String ownerId) {
        return this.registrations.containsKey(ownerId);
    }

    @Override
    public void register(String ownerId, Supplier<Reader> readerFactory) {
        this.registrations.computeIfAbsent(ownerId, o -> new ArrayList()).add(readerFactory);
        this.read(ownerId, readerFactory);
    }

    private void read(String ownerId, Supplier<Reader> readerFactory) {
        try (Reader reader = readerFactory.get();){
            PlayerAnimationPreprocessor.preprocess(reader, outputReader -> this.readOne(ownerId, (Reader)outputReader));
        }
        catch (IOException var8) {
            var8.printStackTrace();
        }
    }

    private void readOne(String ownerId, Reader reader) {
        for (KeyframeAnimation keyframeAnimation : AnimationSerializing.deserializeAnimation((Reader)reader)) {
            String encoded;
            String animationName;
            int index;
            Object var6;
            if (keyframeAnimation.extraData == null || !((var6 = keyframeAnimation.extraData.get(ATTR_NAME)) instanceof String) || (index = (animationName = ((String)GSON.fromJson(encoded = (String)var6, String.class)).toLowerCase(Locale.ROOT)).lastIndexOf(46)) <= 0) continue;
            String baseAnimationName = animationName.substring(0, index);
            String group = animationName.substring(index + 1);
            PlayerAnimationType playerAnimationType = PlayerAnimationType.fromBaseAnimationName(baseAnimationName);
            if (playerAnimationType == null) continue;
            Map keyframeAnimations = this.registeredAnimations.computeIfAbsent(ownerId, key -> new HashMap());
            List playerAnimations = keyframeAnimations.computeIfAbsent(playerAnimationType, t -> new ArrayList());
            playerAnimations.add(new PlayerAnimation<KeyframeAnimation>(animationName, ownerId, keyframeAnimation, PlayerAnimationPartGroup.fromName(group)));
        }
    }

    @Override
    public List<PlayerAnimation<KeyframeAnimation>> getAnimations(String ownerId, PlayerAnimationType animationType) {
        Map<PlayerAnimationType, List<PlayerAnimation<KeyframeAnimation>>> ownerAnimations = this.registeredAnimations.get(ownerId);
        List<PlayerAnimation<KeyframeAnimation>> result = null;
        if (ownerAnimations != null) {
            result = ownerAnimations.get((Object)animationType);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    private static KeyframeAnimation createAux() {
        JsonObject auxGroup = new JsonObject();
        auxGroup.addProperty("format_version", "1.8.0");
        JsonObject auxAnimation = new JsonObject();
        auxAnimation.addProperty("loop", Boolean.valueOf(true));
        JsonObject bonesObject = new JsonObject();
        JsonObject bodyObject = new JsonObject();
        bonesObject.add("body", (JsonElement)bodyObject);
        auxAnimation.add("bones", (JsonElement)bonesObject);
        JsonObject animations = new JsonObject();
        animations.add("aux", (JsonElement)auxAnimation);
        auxGroup.add("animations", (JsonElement)animations);
        String s = GSON.toJson((JsonElement)auxGroup);
        List auxAnimations = AnimationSerializing.deserializeAnimation((Reader)new StringReader(s));
        return (KeyframeAnimation)auxAnimations.get(0);
    }
}

