/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.compat.playeranimator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mod.pbj.compat.playeranimator.PlayerAnimationPartGroup;

public final class PlayerAnimationType
extends Enum<PlayerAnimationType> {
    public static final /* enum */ PlayerAnimationType FIRING = new PlayerAnimationType("animation.model.shooting", false, Map.of(PlayerAnimationPartGroup.ARMS, 0, PlayerAnimationPartGroup.HEAD, 1, PlayerAnimationPartGroup.TORSO, 4, PlayerAnimationPartGroup.LEGS, 5, PlayerAnimationPartGroup.BODY, 10));
    public static final /* enum */ PlayerAnimationType FIRING_AIMING = new PlayerAnimationType("animation.model.shootingaiming", false, Map.of(PlayerAnimationPartGroup.ARMS, 0, PlayerAnimationPartGroup.HEAD, 1, PlayerAnimationPartGroup.TORSO, 4, PlayerAnimationPartGroup.LEGS, 5, PlayerAnimationPartGroup.BODY, 10));
    public static final /* enum */ PlayerAnimationType RELOADING = new PlayerAnimationType("animation.model.reload", false, Map.of(PlayerAnimationPartGroup.ARMS, 0, PlayerAnimationPartGroup.HEAD, 6, PlayerAnimationPartGroup.TORSO, 4, PlayerAnimationPartGroup.LEGS, 5, PlayerAnimationPartGroup.BODY, 10));
    public static final /* enum */ PlayerAnimationType RELOADING_EMPTY = new PlayerAnimationType("animation.model.reloadempty", false, Map.of(PlayerAnimationPartGroup.ARMS, 0, PlayerAnimationPartGroup.HEAD, 6, PlayerAnimationPartGroup.TORSO, 4, PlayerAnimationPartGroup.LEGS, 5, PlayerAnimationPartGroup.BODY, 10));
    public static final /* enum */ PlayerAnimationType AIMING = new PlayerAnimationType("animation.model.aiming", true, Map.of(PlayerAnimationPartGroup.ARMS, 0, PlayerAnimationPartGroup.HEAD, 1, PlayerAnimationPartGroup.TORSO, 4, PlayerAnimationPartGroup.LEGS, 5, PlayerAnimationPartGroup.BODY, 10));
    public static final /* enum */ PlayerAnimationType WALKING = new PlayerAnimationType("animation.model.walking", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 4, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType WALKING_RIGHT = new PlayerAnimationType("animation.model.walkingright", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 4, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType WALKING_LEFT = new PlayerAnimationType("animation.model.walkingleft", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 4, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType WALKING_BACKWARDS = new PlayerAnimationType("animation.model.walkingback", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 4, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType RUNNING = new PlayerAnimationType("animation.model.running", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 4, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType CROUCH_WALKING = new PlayerAnimationType("animation.model.crouchwalking", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 4, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType CROUCH_WALKING_BACKWARDS = new PlayerAnimationType("animation.model.crouchwalkingback", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 4, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType CROUCH_WALKING_RIGHT = new PlayerAnimationType("animation.model.crouchwalkingright", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 4, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType CROUCH_WALKING_LEFT = new PlayerAnimationType("animation.model.crouchwalkingleft", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 4, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType CROUCHING = new PlayerAnimationType("animation.model.crouch", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 7, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType OFF_GROUND = new PlayerAnimationType("animation.model.off_ground", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 4, PlayerAnimationPartGroup.ARMS, 5));
    public static final /* enum */ PlayerAnimationType IDLE = new PlayerAnimationType("animation.model.idle", true, Map.of(PlayerAnimationPartGroup.LEGS, 0, PlayerAnimationPartGroup.BODY, 1, PlayerAnimationPartGroup.TORSO, 3, PlayerAnimationPartGroup.HEAD, 7, PlayerAnimationPartGroup.ARMS, 5));
    private static final Map<String, PlayerAnimationType> baseAnimationNameToType;
    private final String baseAnimationName;
    private final boolean isLooped;
    private final List<PlayerAnimationPartGroup> groups;
    private final List<PartGroupPriority> partGroupPriorities;
    private static final /* synthetic */ PlayerAnimationType[] $VALUES;

    public static PlayerAnimationType[] values() {
        return (PlayerAnimationType[])$VALUES.clone();
    }

    public static PlayerAnimationType valueOf(String name) {
        return Enum.valueOf(PlayerAnimationType.class, name);
    }

    private PlayerAnimationType(String baseAnimationName, boolean isLooped, Map<PlayerAnimationPartGroup, Integer> groupPriorities) {
        this.baseAnimationName = baseAnimationName;
        this.isLooped = isLooped;
        this.groups = new ArrayList<PlayerAnimationPartGroup>(groupPriorities.keySet());
        this.partGroupPriorities = new ArrayList<PartGroupPriority>();
        for (Map.Entry<PlayerAnimationPartGroup, Integer> entry : groupPriorities.entrySet()) {
            this.partGroupPriorities.add(new PartGroupPriority(entry.getKey(), entry.getValue(), this));
        }
    }

    public String getBaseAnimationName() {
        return this.baseAnimationName;
    }

    public boolean isLooped() {
        return this.isLooped;
    }

    public List<PlayerAnimationPartGroup> getGroups() {
        return this.groups;
    }

    public static PlayerAnimationType fromBaseAnimationName(String animationName) {
        return animationName == null ? null : baseAnimationNameToType.get(animationName);
    }

    public static Map<PlayerAnimationPartGroup, PlayerAnimationType> compose(List<PlayerAnimationType> animationTypes) {
        ArrayList<PartGroupPriority> partGroupPriorities = new ArrayList<PartGroupPriority>();
        for (PlayerAnimationType type : animationTypes) {
            partGroupPriorities.addAll(type.partGroupPriorities);
        }
        Collections.sort(partGroupPriorities);
        LinkedHashMap<PlayerAnimationPartGroup, PlayerAnimationType> result = new LinkedHashMap<PlayerAnimationPartGroup, PlayerAnimationType>();
        for (PartGroupPriority p : partGroupPriorities) {
            if (result.containsKey((Object)p.partGroup)) continue;
            result.put(p.partGroup, p.parentType);
        }
        return result;
    }

    private static PlayerAnimationType[] $values() {
        return new PlayerAnimationType[]{FIRING, FIRING_AIMING, RELOADING, RELOADING_EMPTY, AIMING, WALKING, WALKING_RIGHT, WALKING_LEFT, WALKING_BACKWARDS, RUNNING, CROUCH_WALKING, CROUCH_WALKING_BACKWARDS, CROUCH_WALKING_RIGHT, CROUCH_WALKING_LEFT, CROUCHING, OFF_GROUND, IDLE};
    }

    private static /* synthetic */ PlayerAnimationType[] $values$() {
        return new PlayerAnimationType[]{FIRING, FIRING_AIMING, RELOADING, RELOADING_EMPTY, AIMING, WALKING, WALKING_RIGHT, WALKING_LEFT, WALKING_BACKWARDS, RUNNING, CROUCH_WALKING, CROUCH_WALKING_BACKWARDS, CROUCH_WALKING_RIGHT, CROUCH_WALKING_LEFT, CROUCHING, OFF_GROUND, IDLE};
    }

    static {
        $VALUES = PlayerAnimationType.$values$();
        baseAnimationNameToType = new HashMap<String, PlayerAnimationType>();
        PlayerAnimationType[] var0 = PlayerAnimationType.values();
        int var1 = var0.length;
        for (PlayerAnimationType type : var0) {
            baseAnimationNameToType.put(type.getBaseAnimationName(), type);
        }
    }

    private record PartGroupPriority(PlayerAnimationPartGroup partGroup, int priority, PlayerAnimationType parentType) implements Comparable<PartGroupPriority>
    {
        @Override
        public int compareTo(PartGroupPriority o) {
            int result = Integer.compare(this.priority, o.priority);
            return result != 0 ? result : Integer.compare(this.parentType.ordinal(), o.parentType.ordinal());
        }
    }
}

