/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.compat.vivecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.lang.reflect.InvocationTargetException;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class VivecraftCompat {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static VivecraftCompat instance;

    public static VivecraftCompat getInstance() {
        if (instance == null) {
            ModFileInfo compatModFileInfo = LoadingModList.get().getModFileById("vivecraft");
            if (compatModFileInfo == null) {
                return null;
            }
            try {
                Class<?> compatImpl = Class.forName("mod.pbj.compat.vivecraft.VivecraftCompatImpl");
                instance = (VivecraftCompat)compatImpl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LOGGER.info("Compatibility with Vivecraft version {} enabled", (Object)compatModFileInfo.versionString());
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.error("Vivecraft mod version {} detected, but compatibility could not be enabled. This is likely due to an outdated and/or incompatible version of the Player Animator mod. ", (Object)compatModFileInfo.versionString(), (Object)e);
            }
        }
        return instance;
    }

    public abstract RenderTarget getTelescopeRenderTarget();

    public abstract boolean isVrActive();
}

