/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.entity;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mod.pbj.client.EntityRendererBuilder;
import mod.pbj.item.EffectBuilderInfo;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public interface EntityBuilder<T extends EntityBuilder<T, E>, E extends Entity> {
    public static EntityBuilder<?, ?> fromZipEntry(ZipFile zipFile, ZipEntry entry) {
        try {
            EntityBuilder<?, ?> var3;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));){
                var3 = EntityBuilder.fromReader(reader);
            }
            return var3;
        }
        catch (IOException var7) {
            throw new RuntimeException(var7);
        }
    }

    public static EntityBuilder<?, ?> fromPath(Path path) {
        try {
            EntityBuilder<?, ?> var2;
            try (BufferedReader br = Files.newBufferedReader(path);){
                var2 = EntityBuilder.fromReader(br);
            }
            return var2;
        }
        catch (IOException var6) {
            throw new RuntimeException(var6);
        }
    }

    public static EntityBuilder<?, ?> fromReader(Reader reader) {
        throw new UnsupportedOperationException();
    }

    public T withJsonObject(JsonObject var1);

    public String getName();

    public EntityTypeExt getEntityTypeExt();

    public EntityType.Builder<E> getEntityTypeBuilder();

    public boolean hasRenderer();

    public EntityRenderer<?> createEntityRenderer(EntityRendererProvider.Context var1);

    public EntityBuilder<?, ?> withName(String var1);

    public EntityBuilder<?, ?> withItem(Supplier<Item> var1);

    public EntityBuilder<?, ?> withInitialVelocity(double var1);

    public EntityBuilder<?, ?> withMaxLifetime(long var1);

    public EntityBuilder<?, ?> withRenderer(Supplier<EntityRendererBuilder<?, Entity, EntityRenderer<Entity>>> var1);

    public EntityBuilder<?, ?> withGravity(double var1);

    public EntityBuilder<?, ?> withEffect(EffectBuilderInfo var1);

    public EntityBuilder<?, ?> withRicochet(boolean var1);

    public E build(Level var1);

    public static enum EntityTypeExt {
        PROJECTILE;

    }
}

