/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.entity;

import mod.pbj.Config;
import mod.pbj.item.GunItem;
import mod.pbj.network.HitScanFireResponsePacket;
import mod.pbj.network.Network;
import mod.pbj.registry.SoundRegistry;
import mod.pbj.util.HitboxHelper;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.SimpleHitResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;

public class ProjectileBulletEntity
extends Projectile {
    public static final EntityType<ProjectileBulletEntity> TYPE;
    private int correlationId;
    public float speed;
    public float damage;
    public int time = 0;
    public int shotCount;
    public Vec3 initPos = new Vec3(0.0, 0.0, 0.0);
    public float maxDistance = 1500.0f;
    public float headshotMultiplier = 1.0f;
    public ItemStack gunStack;
    public static TagKey<Block> PASSABLE;
    public static TagKey<Block> BREAKABLE;
    private float bulletGravity = 0.03f;

    public void setBulletGravity(float gravity) {
        this.bulletGravity = gravity;
    }

    public ProjectileBulletEntity(Level world) {
        super(TYPE, world);
    }

    public ProjectileBulletEntity(EntityType<ProjectileBulletEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ProjectileBulletEntity(EntityType<ProjectileBulletEntity> entityType, double x, double y, double z, Level world) {
        super(entityType, world);
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20090_();
    }

    public boolean m_37276_() {
        Entity entity = this.m_19749_();
        if (entity != null) {
            for (Entity entity1 : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), p_37272_ -> !p_37272_.m_5833_() && p_37272_.m_6087_())) {
                if (entity1.m_20201_() != entity.m_20201_()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean m_5603_(Entity pTarget) {
        return super.m_5603_(pTarget) && !pTarget.f_19794_;
    }

    public boolean m_6087_() {
        return true;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        Entity entity = this.m_19749_();
        if (this.m_9236_().f_46443_ || (entity == null || !entity.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            super.m_8119_();
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
            if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            this.m_20101_();
            Vec3 vec3 = this.m_20184_();
            double d0 = this.m_20185_() + vec3.f_82479_;
            double d1 = this.m_20186_() + vec3.f_82480_;
            double d2 = this.m_20189_() + vec3.f_82481_;
            ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
            float f = 0.95f;
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d0 - vec3.f_82479_ * 0.25, d1 - vec3.f_82480_ * 0.25, d2 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
                f = 0.8f;
            }
            this.m_20256_(vec3.m_82490_((double)f));
            this.m_246865_(new Vec3(0.0, (double)(-this.bulletGravity), 0.0));
            this.m_6034_(d0, d1, d2);
        } else {
            this.m_146870_();
        }
    }

    public ProjectileBulletEntity(LivingEntity shooter, Level world, float damage, float speed, int shotCount, float maxDistance, float headshotMultiplier, ItemStack gunStack, int correlationId) {
        this(TYPE, shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_(), world);
        this.m_5602_((Entity)shooter);
        this.m_19915_(shooter.m_146908_(), shooter.m_146909_());
        this.damage = damage;
        this.speed = speed;
        this.shotCount = shotCount;
        this.initPos = new Vec3(shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        this.maxDistance = maxDistance;
        this.headshotMultiplier = headshotMultiplier;
        this.gunStack = gunStack;
        this.correlationId = correlationId;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    protected void m_6532_(HitResult pResult) {
        HitResult.Type hitresult$type = pResult.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)pResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, pResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)pResult;
            this.m_8060_(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            BlockState blockState = this.m_9236_().m_8055_(blockpos);
            if (blockState.m_204336_(BREAKABLE)) {
                this.m_9236_().m_46953_(blockpos, true, this.m_19749_());
                return;
            }
            if (blockState.m_204336_(PASSABLE)) {
                return;
            }
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        if (pResult.m_82450_().m_82554_(this.initPos) >= (double)this.maxDistance) {
            this.m_146870_();
            return;
        }
        BlockState blockState = this.m_9236_().m_8055_(pResult.m_82425_());
        if (blockState.m_204336_(BREAKABLE)) {
            this.m_9236_().m_46953_(pResult.m_82425_(), true, this.m_19749_());
            return;
        }
        if (blockState.m_204336_(PASSABLE)) {
            return;
        }
        super.m_8060_(pResult);
        if (this.m_19749_() != null && this.m_9236_() instanceof ServerLevel) {
            for (ServerPlayer serverPlayer : ((ServerLevel)MiscUtil.getLevel(this.m_19749_())).m_8795_(p -> true)) {
                if (serverPlayer != this.m_19749_() && !(serverPlayer.m_20280_(this.m_19749_()) < (double)(this.maxDistance * this.maxDistance))) continue;
                Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new HitScanFireResponsePacket(this.m_19749_().m_19879_(), GunItem.getItemStackId(this.gunStack), serverPlayer.m_150109_().m_36030_(this.gunStack), this.correlationId, SimpleHitResult.fromHitResult((HitResult)pResult), this.damage));
            }
        }
        this.m_5496_(this.m_9236_().m_8055_(pResult.m_82425_()).m_60827_().m_56778_(), 1.0f / (float)this.shotCount, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        RandomSource source = RandomSource.m_216327_();
        double d0 = pResult.m_82450_().f_82479_;
        double d1 = pResult.m_82450_().f_82480_;
        double d2 = pResult.m_82450_().f_82481_;
        double d3 = d0 - (double)pResult.m_82425_().m_123341_() - 0.5;
        double d5 = d2 - (double)pResult.m_82425_().m_123343_() - 0.5;
        double d6 = Math.max(Math.abs(d3), Math.abs(d5));
        d0 = (double)pResult.m_82425_().m_123341_() + 0.5 + d3 / d6 * 0.5;
        d2 = (double)pResult.m_82425_().m_123343_() + 0.5 + d5 / d6 * 0.5;
        float f = Mth.m_14167_((float)this.damage);
        double d4 = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int i = (int)(15.0 * d4);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            for (int j = 0; j < i; ++j) {
                sv.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState).setPos(pResult.m_82425_()), d0, d1, d2, 1, source.m_188499_() ? source.m_188500_() / 4.0 : -source.m_188500_() / 4.0, (double)j / (double)i / 2.0, source.m_188499_() ? source.m_188500_() / 4.0 : -source.m_188500_() / 4.0, 0.15);
            }
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (pResult.m_82450_().m_82554_(this.initPos) >= (double)this.maxDistance) {
            this.m_146870_();
            return;
        }
        Entity entity = pResult.m_82443_();
        AABB boundingBox = HitboxHelper.getFixedBoundingBox(entity, this.m_19749_());
        Vec3 startVec = this.m_20182_();
        Vec3 endVec = startVec.m_82549_(this.m_20184_());
        Vec3 hitPos = boundingBox.m_82371_(startVec, endVec).orElse(null);
        double headshotmulti = 1.0;
        if (hitPos != null) {
            if (this.m_19749_() != null && this.m_9236_() instanceof ServerLevel) {
                for (ServerPlayer serverPlayer : ((ServerLevel)MiscUtil.getLevel(this.m_19749_())).m_8795_(p -> true)) {
                    if (serverPlayer != this.m_19749_() && !(serverPlayer.m_20280_(this.m_19749_()) < (double)(this.maxDistance * this.maxDistance))) continue;
                    Network.networkChannel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new HitScanFireResponsePacket(this.m_19749_().m_19879_(), GunItem.getItemStackId(this.gunStack), serverPlayer.m_150109_().m_36030_(this.gunStack), this.correlationId, SimpleHitResult.fromHitResult((HitResult)pResult), this.damage));
                }
            }
            Vec3 hitBoxPos = hitPos.m_82546_(entity.m_20182_());
            boolean headshot = false;
            float eyeHeight = entity.m_20192_();
            if (entity instanceof Player && ((Boolean)Config.PLAYERHEADSHOTS.get()).booleanValue() && (double)eyeHeight - 0.25 < hitBoxPos.f_82480_ && hitBoxPos.f_82480_ < (double)eyeHeight + 0.25) {
                headshot = true;
                headshotmulti = this.headshotMultiplier;
            }
            if (!(entity instanceof Player) && ((Boolean)Config.MOBHEADSHOTS.get()).booleanValue() && (double)eyeHeight - 0.25 < hitBoxPos.f_82480_ && hitBoxPos.f_82480_ < (double)eyeHeight + 0.25) {
                headshot = true;
                headshotmulti = this.headshotMultiplier;
            }
            DamageSource damageSource = pResult.m_82443_().m_269291_().m_269299_((Entity)this, (LivingEntity)this.m_19749_());
            if (headshot) {
                this.m_9236_().m_5594_(null, entity.m_20183_(), SoundRegistry.HIT_HEADSHOT.get(), SoundSource.HOSTILE, 0.8f / (float)this.shotCount, 1.0f);
            }
            pResult.m_82443_().m_6469_(damageSource, (float)((double)this.damage * headshotmulti));
            pResult.m_82443_().f_19802_ = Config.iframes;
            this.m_146870_();
        }
    }

    static {
        PASSABLE = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"passable"));
        BREAKABLE = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"breakable"));
        TYPE = EntityType.Builder.m_20704_(ProjectileBulletEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20716_().m_20719_().m_20699_(0.0225f, 0.0225f).m_20702_(256).m_20720_().setTrackingRange(512).m_20717_(1).setShouldReceiveVelocityUpdates(true).m_20712_("bullet");
    }
}

