/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.entity;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.pbj.client.EntityRendererBuilder;
import mod.pbj.client.effect.AbstractEffect;
import mod.pbj.client.effect.AttachedProjectileEffect;
import mod.pbj.client.effect.Effect;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.client.effect.TrailEffect;
import mod.pbj.entity.EntityBuilder;
import mod.pbj.entity.ProjectileLike;
import mod.pbj.item.AmmoItem;
import mod.pbj.item.EffectBuilderInfo;
import mod.pbj.item.GunItem;
import mod.pbj.item.HurtingItem;
import mod.pbj.registry.EntityRegistry;
import mod.pbj.util.DirectAttackTrajectory;
import mod.pbj.util.HitScan;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.TimeUnit;
import mod.pbj.util.TopDownAttackTrajectory;
import mod.pbj.util.Trajectory;
import mod.pbj.util.TrajectoryProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlowProjectile
extends AbstractHurtingProjectile
implements ProjectileLike,
IEntityAdditionalSpawnData {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final double MAX_RENDER_DISTANCE_SQR = 40000.0;
    private static final float MAX_HIT_SCAN_DISTANCE = 10.0f;
    static final float DEFAULT_MAX_DISTANCE = 150.0f;
    private static final double DEFAULT_GRAVITY = 0.05;
    private static final EntityDataAccessor<OptionalInt> DATA_ATTACHED_TO_TARGET = SynchedEntityData.m_135353_(SlowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private static final EntityDataAccessor<Boolean> DATA_SHOT_AT_ANGLE = SynchedEntityData.m_135353_(SlowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private double initialVelocityBlocksPerTick;
    private int life;
    private int lifetime;
    private HitResult hitScanTarget;
    private double gravity;
    @Nullable
    private LivingEntity attachedToEntity;
    private final float initialAngle;
    private final long startTimeMillis;
    private List<ProjectileLike.EffectInfo> trailEffects;
    private List<ProjectileLike.EffectInfo> attachedEffects;
    private List<Effect> activeTrailEffects = Collections.emptyList();
    private List<Effect> activeAttachedEffects = Collections.emptyList();
    private Trajectory<?> trajectory;
    private Entity targetEntity;
    public HurtingItem hurtingItem;
    private ItemStack hurtingItemStack;

    public static Builder builder() {
        return new Builder();
    }

    public SlowProjectile(EntityType<? extends SlowProjectile> entityType, Level level) {
        super(entityType, level);
        this.initialAngle = this.f_19796_.m_188501_() * 360.0f;
        this.startTimeMillis = System.currentTimeMillis();
    }

    @Override
    public void launchAtLookTarget(LivingEntity entity, double inaccuracy, long seed) {
        this.hitScanTarget = HitScan.getNearestObjectInCrosshair(entity, 0.0f, 150.0, inaccuracy, seed, block -> false, block -> false, new ArrayList<BlockPos>());
        Vec3 hitLocation = this.hitScanTarget.m_82450_();
        Vec3 muzzleWorldPos = this.m_20182_();
        Vec3 eyePos = entity.m_146892_();
        Vec3 viewHitVector = hitLocation.m_82546_(eyePos);
        Vec3 spawnOffset = muzzleWorldPos.m_82546_(eyePos);
        Vec3 direction = viewHitVector.m_82546_(spawnOffset).m_82541_();
        this.shoot(direction.f_82479_, direction.f_82480_, direction.f_82481_, this.getInitialVelocityBlocksPerTick());
    }

    @Override
    public void launchAtTargetEntity(LivingEntity player, HitResult hitResult, Entity targetEntity) {
        this.hitScanTarget = hitResult;
        this.targetEntity = targetEntity;
        Vec3 hitLocation = this.hitScanTarget.m_82450_();
        Vec3 muzzleWorldPos = this.m_20182_();
        Vec3 eyePos = player.m_146892_();
        Vec3 viewHitVector = hitLocation.m_82546_(eyePos);
        Vec3 spawnOffset = muzzleWorldPos.m_82546_(eyePos);
        Vec3 direction = viewHitVector.m_82546_(spawnOffset).m_82541_();
        this.shoot(direction.f_82479_, direction.f_82480_, direction.f_82481_, this.getInitialVelocityBlocksPerTick());
    }

    public void shoot(double dx, double dy, double dz, double initialSpeed) {
        Vec3 deltaMovement = new Vec3(dx, dy, dz).m_82541_().m_82490_(initialSpeed);
        this.m_20256_(deltaMovement);
        double horizontalDistance = deltaMovement.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)deltaMovement.f_82479_, (double)deltaMovement.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)deltaMovement.f_82480_, (double)horizontalDistance) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        LOGGER.debug("{} initializing projectile trajectory", (Object)(System.currentTimeMillis() % 100000L));
        this.initTrajectory(this.hitScanTarget.m_82450_());
        LOGGER.debug("{} performed projectile shot", (Object)(System.currentTimeMillis() % 100000L));
    }

    private void initTrajectory(Vec3 targetLocation) {
        Vec3 startPosition = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        HurtingItem hurtingItem = this.hurtingItem;
        if (hurtingItem instanceof TrajectoryProvider) {
            TrajectoryProvider trajectoryProvider = (TrajectoryProvider)((Object)hurtingItem);
            this.trajectory = trajectoryProvider.createTrajectory(this.m_9236_(), startPosition, targetLocation);
        }
        if (this.trajectory == null) {
            this.trajectory = new DirectAttackTrajectory(startPosition, this.m_20184_(), this.gravity);
        }
    }

    public int getLife() {
        return this.life;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ATTACHED_TO_TARGET, (Object)OptionalInt.empty());
        this.f_19804_.m_135372_(DATA_SHOT_AT_ANGLE, (Object)false);
    }

    public boolean m_6783_(double distance) {
        return distance < 40000.0;
    }

    public void m_8119_() {
        Entity entity;
        int entityId;
        Level level = MiscUtil.getLevel((Entity)this);
        if (MiscUtil.isClientSide((Entity)this)) {
            Vec3 dm = this.m_20184_();
            for (Effect trailEffect : this.getActiveTrailEffects()) {
                ((TrailEffect)trailEffect).launchNext((Entity)this, new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), dm);
            }
        }
        if (level.f_46443_ && this.attachedToEntity == null && (entityId = ((OptionalInt)this.f_19804_.m_135370_(DATA_ATTACHED_TO_TARGET)).orElse(-1)) >= 0 && (entity = MiscUtil.getLevel((Entity)this).m_6815_(entityId)) instanceof LivingEntity) {
            this.attachedToEntity = (LivingEntity)entity;
        }
        if (this.life > this.getLifetime()) {
            this.m_146870_();
        }
        if (this.trajectory != null) {
            this.trajectory.tick();
            if (!level.f_46443_ && this.trajectory.isCompleted()) {
                this.explode();
            }
        }
        if (level.f_46443_) {
            this.activeAttachedEffects = this.attachedEffects.stream().filter(ei -> ei.predicate().test(this)).map(ProjectileLike.EffectInfo::effect).toList();
            this.activeTrailEffects = this.trailEffects.stream().filter(ei -> ei.predicate().test(this)).map(ProjectileLike.EffectInfo::effect).toList();
        }
        if (this.targetEntity != null) {
            this.trajectory.setTargetPosition(this.targetEntity.m_20318_(0.0f));
        }
        Entity entity2 = this.m_19749_();
        if (level.f_46443_ || (entity2 == null || !entity2.m_213877_()) && MiscUtil.getLevel((Entity)this).m_46805_(this.m_20183_())) {
            HitResult hitresult = this.getHitResultOnMoveOrViewVector();
            if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            if (this.trajectory != null) {
                this.m_20256_(this.trajectory.getDeltaMovement());
                this.m_146884_(this.trajectory.getEndOfTickPosition());
            } else {
                Vec3 deltaMovement = this.m_20184_();
                double d0 = this.m_20185_() + deltaMovement.f_82479_;
                double d1 = this.m_20186_() + deltaMovement.f_82480_;
                double d2 = this.m_20189_() + deltaMovement.f_82481_;
                this.m_20334_(deltaMovement.f_82479_, deltaMovement.f_82480_ - this.getGravity(), deltaMovement.f_82481_);
                this.m_6034_(d0, d1, d2);
            }
        } else {
            this.m_146870_();
        }
        if (!level.f_46443_ && this.life > this.getLifetime()) {
            this.explode();
        }
        ++this.life;
    }

    public void m_6453_(double x, double y, double z, float xRot, float yRot, int p_19901_, boolean p_19902_) {
    }

    public void m_20334_(double dx, double dy, double dz) {
        super.m_20334_(dx, dy, dz);
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        this.m_146922_((float)(Mth.m_14136_((double)dx, (double)dz) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)dy, (double)horizontalDistance) * 57.29577951308232));
    }

    public void m_20256_(Vec3 dm) {
        super.m_20256_(dm);
        double horizontalDistance = Math.sqrt(dm.f_82479_ * dm.f_82479_ + dm.f_82481_ * dm.f_82481_);
        this.m_146922_((float)(Mth.m_14136_((double)dm.f_82479_, (double)dm.f_82481_) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)dm.f_82480_, (double)horizontalDistance) * 57.29577951308232));
    }

    private HitResult getHitResultOnMoveOrViewVector() {
        Entity owner = this.m_19749_();
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        if (owner != null) {
            Vec3 ownerPos = owner.m_20182_();
            Vec3 originalHitPos = hitResult.m_82450_();
            double distanceToOwner = originalHitPos.m_82554_(ownerPos);
            if (distanceToOwner <= 10.0 && this.hitScanTarget != null && this.hitScanTarget.m_82450_().m_82554_(ownerPos) <= 10.0) {
                hitResult = this.hitScanTarget;
            }
        }
        return hitResult;
    }

    protected boolean m_5603_(Entity entity) {
        return entity != this.m_19749_() && super.m_5603_(entity) && !entity.f_19794_;
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    protected EntityHitResult findHitEntity(Vec3 p_36758_, Vec3 p_36759_) {
        return ProjectileUtil.m_37304_((Level)MiscUtil.getLevel((Entity)this), (Entity)this, (Vec3)p_36758_, (Vec3)p_36759_, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), this::m_5603_);
    }

    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.MISS || !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)result)) {
            super.m_6532_(result);
            this.m_146870_();
        }
    }

    private void explode() {
        if (this.hurtingItem != null) {
            this.hurtingItem.explodeProjectile((Entity)this);
        }
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        Entity owner = this.m_19749_();
        HurtingItem var4 = this.hurtingItem;
        if (var4 instanceof AmmoItem) {
            AmmoItem ammoItem = (AmmoItem)var4;
            if (owner instanceof LivingEntity) {
                this.hurtingItem.hurtEntity((LivingEntity)owner, entityHitResult, (Entity)this, new ItemStack((ItemLike)ammoItem));
            }
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        BlockPos blockpos = new BlockPos((Vec3i)blockHitResult.m_82425_());
        MiscUtil.getLevel((Entity)this).m_8055_(blockpos).m_60682_(MiscUtil.getLevel((Entity)this), blockpos, (Entity)this);
        Entity owner = this.m_19749_();
        if (this.hurtingItem != null && !MiscUtil.isClientSide((Entity)this) && owner instanceof LivingEntity) {
            this.hurtingItem.handleBlockHit((LivingEntity)((Player)owner), blockHitResult, (Entity)this);
        }
        super.m_8060_(blockHitResult);
    }

    public boolean isShotAtAngle() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHOT_AT_ANGLE);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Life", this.life);
        tag.m_128405_("LifeTime", this.getLifetime());
        tag.m_128379_("ShotAtAngle", ((Boolean)this.f_19804_.m_135370_(DATA_SHOT_AT_ANGLE)).booleanValue());
    }

    public void m_7378_(CompoundTag compoundTag) {
        this.m_146870_();
    }

    public boolean m_6097_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Vec3 movement = this.m_20184_();
        buffer.writeInt(this.getLifetime());
        buffer.writeDouble(this.m_20185_());
        buffer.writeDouble(this.m_20186_());
        buffer.writeDouble(this.m_20189_());
        buffer.writeDouble(movement.f_82479_);
        buffer.writeDouble(movement.f_82480_);
        buffer.writeDouble(movement.f_82481_);
        buffer.writeFloat(this.m_146909_());
        buffer.writeFloat(this.m_6080_());
        Vec3 targetLocation = this.hitScanTarget != null ? this.hitScanTarget.m_82450_() : Vec3.f_82478_;
        buffer.writeDouble(targetLocation.f_82479_);
        buffer.writeDouble(targetLocation.f_82480_);
        buffer.writeDouble(targetLocation.f_82481_);
        buffer.writeInt(this.targetEntity != null ? this.targetEntity.m_19879_() : -1);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.setLifetime(buffer.readInt());
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        double dx = buffer.readDouble();
        double dy = buffer.readDouble();
        double dz = buffer.readDouble();
        float xRot = buffer.readFloat();
        float yRot = buffer.readFloat();
        double hitLocationX = buffer.readDouble();
        double hitLocationY = buffer.readDouble();
        double hitLocationZ = buffer.readDouble();
        int entityId = buffer.readInt();
        this.m_19890_(x, y, z, yRot, xRot);
        this.m_20334_(dx, dy, dz);
        this.m_5616_(yRot);
        this.m_5618_(yRot);
        if (entityId >= 0) {
            this.targetEntity = this.m_9236_().m_6815_(entityId);
        }
        this.initTrajectory(new Vec3(hitLocationX, hitLocationY, hitLocationZ));
    }

    @Override
    public float getProgress(float partialTick) {
        return ((float)this.life + partialTick) / (float)this.getLifetime();
    }

    @Override
    public long getElapsedTimeMillis() {
        return System.currentTimeMillis() - this.startTimeMillis;
    }

    public float getInitialAngle() {
        return this.initialAngle;
    }

    @Override
    public ItemStack getItem() {
        return this.hurtingItemStack;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public double getGravity() {
        return this.gravity;
    }

    private void setGravity(double gravity) {
        this.gravity = gravity;
    }

    @Override
    public double getInitialVelocityBlocksPerTick() {
        return this.initialVelocityBlocksPerTick;
    }

    private void setInitialVelocityBlocksPerTick(double initialVelocityBlocksPerTick) {
        this.initialVelocityBlocksPerTick = initialVelocityBlocksPerTick;
    }

    @Override
    public List<Effect> getActiveAttachedEffects() {
        return this.activeAttachedEffects;
    }

    public List<Effect> getActiveTrailEffects() {
        return this.activeTrailEffects;
    }

    @Override
    public void setTrailEffects(List<ProjectileLike.EffectInfo> trailEffects) {
        this.trailEffects = trailEffects;
    }

    @Override
    public void setAttachedEffects(List<ProjectileLike.EffectInfo> attachedEffects) {
        this.attachedEffects = attachedEffects;
    }

    @Override
    public Trajectory<?> getTrajectory() {
        return this.trajectory;
    }

    public static Predicate<ProjectileLike> topDownTrajectoryPhasePredicate(Predicate<TopDownAttackTrajectory> tp) {
        return projectile -> {
            TopDownAttackTrajectory tdat;
            Trajectory<?> patt29669$temp;
            if (projectile.getTrajectory() != null && (patt29669$temp = projectile.getTrajectory()) instanceof TopDownAttackTrajectory && tp.test(tdat = (TopDownAttackTrajectory)patt29669$temp)) {
                boolean var10000 = true;
                return var10000;
            }
            boolean var10000 = false;
            return var10000;
        };
    }

    public static class Builder
    implements EntityBuilder<Builder, SlowProjectile> {
        private static final float DEFAULT_WIDTH = 0.25f;
        private static final float DEFAULT_HEIGHT = 0.25f;
        private static final int DEFAULT_TRACKING_RANGE = 1024;
        private static final int DEFAULT_CLIENT_TRACKING_RANGE = 1024;
        private static final int DEFAULT_UPDATE_INTERVAL = 1;
        private static final int DEFAULT_LIFETIME_TICKS = 200;
        private String name;
        private float width = 0.25f;
        private float height = 0.25f;
        private final int clientTrackingRange = 1024;
        private final int trackingRange = 1024;
        private int updateInterval = 1;
        private double initialVelocityBlocksPerSecond;
        private int lifetimeTicks = 200;
        private double gravity;
        private final List<EffectBuilderInfo> effectBuilderSuppliers = new ArrayList<EffectBuilderInfo>();
        private Supplier<EntityRendererBuilder<?, Entity, EntityRenderer<Entity>>> rendererBuilder;
        private Supplier<HurtingItem> hurtingItem;

        private Builder() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Builder withItem(Supplier<Item> hurtingItem) {
            this.hurtingItem = () -> (HurtingItem)hurtingItem.get();
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withMaxLifetime(long lifetimeMillis) {
            this.lifetimeTicks = (int)TimeUnit.MILLISECOND.toTicks(lifetimeMillis);
            return this;
        }

        public Builder withSize(float width, float height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Override
        public EntityBuilder<?, ?> withRicochet(boolean ricochet) {
            return this;
        }

        public Builder withInitialVelocity(double initialVelocityBlocksPerSecond) {
            this.initialVelocityBlocksPerSecond = initialVelocityBlocksPerSecond;
            return this;
        }

        public Builder withRenderer(Supplier<EntityRendererBuilder<?, Entity, EntityRenderer<Entity>>> rendererBuilder2) {
            this.rendererBuilder = rendererBuilder2;
            return this;
        }

        public Builder withGravity(boolean isGravityEnabled) {
            this.gravity = isGravityEnabled ? 0.05 : 0.0;
            return this;
        }

        public Builder withGravity(double gravity) {
            this.gravity = Mth.m_14008_((double)gravity, (double)-1.0, (double)1.0);
            return this;
        }

        public Builder withEffect(EffectBuilderInfo effectInfo) {
            this.effectBuilderSuppliers.add(effectInfo);
            return this;
        }

        @Override
        public EntityBuilder.EntityTypeExt getEntityTypeExt() {
            return EntityBuilder.EntityTypeExt.PROJECTILE;
        }

        @Override
        public EntityType.Builder<SlowProjectile> getEntityTypeBuilder() {
            EntityType.Builder builder = EntityType.Builder.m_20704_(this::create, (MobCategory)MobCategory.MISC).m_20699_(this.width, this.height);
            Objects.requireNonNull(this);
            EntityType.Builder builder2 = builder.m_20702_(1024);
            Objects.requireNonNull(this);
            return builder2.setTrackingRange(1024).m_20717_(this.updateInterval).setShouldReceiveVelocityUpdates(false);
        }

        public SlowProjectile create(EntityType<SlowProjectile> entityType, Level level) {
            SlowProjectile projectile = new SlowProjectile(entityType, level);
            if (level.f_46443_) {
                this.initEffects(projectile);
            }
            projectile.setGravity(this.gravity);
            if (this.hurtingItem != null) {
                projectile.hurtingItem = this.hurtingItem.get();
                projectile.hurtingItemStack = new ItemStack((ItemLike)projectile.hurtingItem);
            }
            return projectile;
        }

        @Override
        public SlowProjectile build(Level level) {
            RegistryObject<EntityType<?>> entityType = EntityRegistry.getTypeByName(this.name);
            SlowProjectile projectile = new SlowProjectile((EntityType<? extends SlowProjectile>)((EntityType)entityType.get()), level);
            projectile.setInitialVelocityBlocksPerTick(this.initialVelocityBlocksPerSecond * (double)0.05f);
            projectile.setLifetime(this.lifetimeTicks);
            projectile.m_20242_(MiscUtil.isNearlyZero(this.gravity));
            projectile.setGravity(this.gravity);
            if (this.hurtingItem != null) {
                projectile.hurtingItem = this.hurtingItem.get();
                projectile.hurtingItemStack = new ItemStack((ItemLike)projectile.hurtingItem);
            }
            if (level.f_46443_) {
                this.initEffects(projectile);
            }
            return projectile;
        }

        public void initEffects(SlowProjectile projectile) {
            ArrayList<ProjectileLike.EffectInfo> trailEffects = new ArrayList<ProjectileLike.EffectInfo>();
            ArrayList<ProjectileLike.EffectInfo> attachedEffects = new ArrayList<ProjectileLike.EffectInfo>();
            GunItem.FirePhase phase = GunItem.FirePhase.FLYING;
            for (EffectBuilderInfo effectBuilderInfo : this.effectBuilderSuppliers) {
                AbstractEffect effect;
                EffectBuilder.Context context;
                EffectBuilder<EffectBuilder<?, ?>, ?> effectBuilder = effectBuilderInfo.effectSupplier().get();
                if (effectBuilder.getCompatiblePhases().contains(GunItem.FirePhase.FLYING)) {
                    context = new EffectBuilder.Context();
                    effect = (TrailEffect)effectBuilder.build(context);
                    trailEffects.add(new ProjectileLike.EffectInfo(effect, effectBuilderInfo.predicate()));
                    continue;
                }
                if (!(effectBuilder instanceof AttachedProjectileEffect.Builder)) {
                    throw new IllegalStateException("Effect builder " + String.valueOf(effectBuilder) + " is not compatible with phase '" + String.valueOf(phase) + "'. Check how you construct projectile: " + this.getName());
                }
                context = new EffectBuilder.Context();
                effect = (AttachedProjectileEffect)effectBuilder.build(context);
                attachedEffects.add(new ProjectileLike.EffectInfo(effect, effectBuilderInfo.predicate()));
            }
            projectile.trailEffects = Collections.unmodifiableList(trailEffects);
            projectile.attachedEffects = Collections.unmodifiableList(attachedEffects);
        }

        @Override
        public boolean hasRenderer() {
            return this.rendererBuilder != null;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public EntityRenderer<Entity> createEntityRenderer(EntityRendererProvider.Context context) {
            return this.rendererBuilder.get().build(context);
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            throw new UnsupportedOperationException();
        }
    }
}

